/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.propertysheet;

import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertyDescriptorAdapter;
import com.l2fprod.common.propertysheet.PropertyEditorFactory;
import com.l2fprod.common.propertysheet.PropertyEditorRegistry;
import com.l2fprod.common.propertysheet.PropertyRendererFactory;
import com.l2fprod.common.propertysheet.PropertyRendererRegistry;
import com.l2fprod.common.propertysheet.PropertySheet;
import com.l2fprod.common.propertysheet.PropertySheetTable;
import com.l2fprod.common.propertysheet.PropertySheetTableModel;
import com.l2fprod.common.swing.IconPool;
import com.l2fprod.common.swing.LookAndFeelTweaks;
import com.l2fprod.common.swing.plaf.blue.BlueishButtonUI;
import com.l2fprod.common.util.ResourceManager;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.beans.BeanInfo;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PropertySheetPanel
extends JPanel
implements PropertySheet,
PropertyChangeListener {
    private PropertySheetTable table;
    private PropertySheetTableModel model;
    private JScrollPane tableScroll;
    private ListSelectionListener selectionListener = new SelectionListener();
    private JPanel actionPanel;
    private JToggleButton sortButton;
    private JToggleButton asCategoryButton;
    private JToggleButton descriptionButton;
    private JSplitPane split;
    private int lastDescriptionHeight;
    private JEditorPane descriptionPanel;
    private JScrollPane descriptionScrollPane;

    public PropertySheetPanel() {
        this(new PropertySheetTable());
    }

    public PropertySheetPanel(PropertySheetTable propertySheetTable) {
        this.buildUI();
        this.setTable(propertySheetTable);
    }

    public void setTable(PropertySheetTable propertySheetTable) {
        if (propertySheetTable == null) {
            throw new IllegalArgumentException("table must not be null");
        }
        if (this.model != null) {
            this.model.removePropertyChangeListener(this);
        }
        this.model = (PropertySheetTableModel)propertySheetTable.getModel();
        this.model.addPropertyChangeListener(this);
        if (this.table != null) {
            this.table.getSelectionModel().removeListSelectionListener(this.selectionListener);
        }
        propertySheetTable.getSelectionModel().addListSelectionListener(this.selectionListener);
        this.tableScroll.getViewport().setView(propertySheetTable);
        this.table = propertySheetTable;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.repaint();
    }

    public PropertySheetTable getTable() {
        return this.table;
    }

    public void setDescriptionVisible(boolean bl) {
        if (bl) {
            this.add("Center", this.split);
            this.split.setTopComponent(this.tableScroll);
            this.split.setBottomComponent(this.descriptionScrollPane);
            this.split.setDividerLocation(this.split.getHeight() - this.lastDescriptionHeight);
        } else {
            this.lastDescriptionHeight = this.split.getHeight() - this.split.getDividerLocation();
            this.remove(this.split);
            this.add("Center", this.tableScroll);
        }
        this.descriptionButton.setSelected(bl);
        this.revalidate();
    }

    public void setToolBarVisible(boolean bl) {
        this.actionPanel.setVisible(bl);
        this.revalidate();
    }

    public void setMode(int n) {
        this.model.setMode(n);
        this.asCategoryButton.setSelected(1 == n);
    }

    @Override
    public void setProperties(Property[] propertyArray) {
        this.model.setProperties(propertyArray);
    }

    @Override
    public Property[] getProperties() {
        return this.model.getProperties();
    }

    @Override
    public void addProperty(Property property) {
        this.model.addProperty(property);
    }

    @Override
    public void addProperty(int n, Property property) {
        this.model.addProperty(n, property);
    }

    @Override
    public void removeProperty(Property property) {
        this.model.removeProperty(property);
    }

    @Override
    public int getPropertyCount() {
        return this.model.getPropertyCount();
    }

    @Override
    public Iterator propertyIterator() {
        return this.model.propertyIterator();
    }

    public void setBeanInfo(BeanInfo beanInfo) {
        this.setProperties(beanInfo.getPropertyDescriptors());
    }

    public void setProperties(PropertyDescriptor[] propertyDescriptorArray) {
        Property[] propertyArray = new Property[propertyDescriptorArray.length];
        int n = 0;
        int n2 = propertyDescriptorArray.length;
        while (n < n2) {
            propertyArray[n] = new PropertyDescriptorAdapter(propertyDescriptorArray[n]);
            ++n;
        }
        this.model.setProperties(propertyArray);
    }

    public void readFromObject(Object object) {
        this.getTable().cancelEditing();
        Property[] propertyArray = this.model.getProperties();
        int n = 0;
        int n2 = propertyArray.length;
        while (n < n2) {
            propertyArray[n].readFromObject(object);
            ++n;
        }
        this.repaint();
    }

    public void writeToObject(Object object) {
        this.getTable().commitEditing();
        Property[] propertyArray = this.getProperties();
        int n = 0;
        int n2 = propertyArray.length;
        while (n < n2) {
            propertyArray[n].writeToObject(object);
            ++n;
        }
    }

    public void addPropertySheetChangeListener(PropertyChangeListener propertyChangeListener) {
        this.model.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertySheetChangeListener(PropertyChangeListener propertyChangeListener) {
        this.model.removePropertyChangeListener(propertyChangeListener);
    }

    public void setEditorFactory(PropertyEditorFactory propertyEditorFactory) {
        this.table.setEditorFactory(propertyEditorFactory);
    }

    public PropertyEditorFactory getEditorFactory() {
        return this.table.getEditorFactory();
    }

    public void setEditorRegistry(PropertyEditorRegistry propertyEditorRegistry) {
        this.table.setEditorFactory(propertyEditorRegistry);
    }

    public PropertyEditorRegistry getEditorRegistry() {
        return (PropertyEditorRegistry)this.table.getEditorFactory();
    }

    public void setRendererFactory(PropertyRendererFactory propertyRendererFactory) {
        this.table.setRendererFactory(propertyRendererFactory);
    }

    public PropertyRendererFactory getRendererFactory() {
        return this.table.getRendererFactory();
    }

    public void setRendererRegistry(PropertyRendererRegistry propertyRendererRegistry) {
        this.table.setRendererRegistry(propertyRendererRegistry);
    }

    public PropertyRendererRegistry getRendererRegistry() {
        return this.table.getRendererRegistry();
    }

    public void setSortingCategories(boolean bl) {
        this.model.setSortingCategories(bl);
        this.sortButton.setSelected(this.isSorting());
    }

    public boolean isSortingCategories() {
        return this.model.isSortingCategories();
    }

    public void setSortingProperties(boolean bl) {
        this.model.setSortingProperties(bl);
        this.sortButton.setSelected(this.isSorting());
    }

    public boolean isSortingProperties() {
        return this.model.isSortingProperties();
    }

    public void setSorting(boolean bl) {
        this.model.setSortingCategories(bl);
        this.model.setSortingProperties(bl);
        this.sortButton.setSelected(bl);
    }

    public boolean isSorting() {
        return this.model.isSortingCategories() || this.model.isSortingProperties();
    }

    public void setCategorySortingComparator(Comparator comparator) {
        this.model.setCategorySortingComparator(comparator);
    }

    public void setPropertySortingComparator(Comparator comparator) {
        this.model.setPropertySortingComparator(comparator);
    }

    private void buildUI() {
        LookAndFeelTweaks.setBorderLayout(this);
        LookAndFeelTweaks.setBorder(this);
        this.actionPanel = new JPanel(new FlowLayout(3, 2, 0));
        this.actionPanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this.add("North", this.actionPanel);
        this.sortButton = new JToggleButton(new ToggleSortingAction());
        this.sortButton.setUI(new BlueishButtonUI());
        this.sortButton.setText(null);
        this.actionPanel.add(this.sortButton);
        this.asCategoryButton = new JToggleButton(new ToggleModeAction());
        this.asCategoryButton.setUI(new BlueishButtonUI());
        this.asCategoryButton.setText(null);
        this.actionPanel.add(this.asCategoryButton);
        this.descriptionButton = new JToggleButton(new ToggleDescriptionAction());
        this.descriptionButton.setUI(new BlueishButtonUI());
        this.descriptionButton.setText(null);
        this.actionPanel.add(this.descriptionButton);
        this.split = new JSplitPane(0);
        this.split.setBorder(null);
        this.split.setResizeWeight(1.0);
        this.split.setContinuousLayout(true);
        this.add("Center", this.split);
        this.tableScroll = new JScrollPane();
        this.split.setTopComponent(this.tableScroll);
        this.descriptionPanel = new JEditorPane("text/html", "<html>");
        this.descriptionPanel.setBorder(BorderFactory.createEmptyBorder());
        this.descriptionPanel.setEditable(false);
        this.descriptionPanel.setBackground(UIManager.getColor("Panel.background"));
        LookAndFeelTweaks.htmlize(this.descriptionPanel);
        this.selectionListener = new SelectionListener();
        this.descriptionScrollPane = new JScrollPane(this.descriptionPanel);
        this.descriptionScrollPane.setBorder(LookAndFeelTweaks.addMargin(BorderFactory.createLineBorder(UIManager.getColor("controlDkShadow"))));
        this.descriptionScrollPane.getViewport().setBackground(this.descriptionPanel.getBackground());
        this.descriptionScrollPane.setMinimumSize(new Dimension(50, 50));
        this.split.setBottomComponent(this.descriptionScrollPane);
        this.setDescriptionVisible(false);
        this.setToolBarVisible(true);
    }

    class SelectionListener
    implements ListSelectionListener {
        SelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = PropertySheetPanel.this.table.getSelectedRow();
            Property property = null;
            if (n >= 0 && PropertySheetPanel.this.table.getRowCount() > n) {
                property = PropertySheetPanel.this.model.getPropertySheetElement(n).getProperty();
            }
            if (property != null) {
                PropertySheetPanel.this.descriptionPanel.setText("<html><b>" + (property.getDisplayName() == null ? "" : property.getDisplayName()) + "</b><br>" + (property.getShortDescription() == null ? "" : property.getShortDescription()));
            } else {
                PropertySheetPanel.this.descriptionPanel.setText("<html>");
            }
            PropertySheetPanel.this.descriptionPanel.setCaretPosition(0);
        }
    }

    class ToggleDescriptionAction
    extends AbstractAction {
        public ToggleDescriptionAction() {
            super("toggleDescription", IconPool.shared().get(PropertySheet.class.getResource("icons/description.gif")));
            this.putValue("ShortDescription", ResourceManager.get(PropertySheet.class).getString("PropertySheetPanel.description.shortDescription"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PropertySheetPanel.this.setDescriptionVisible(PropertySheetPanel.this.descriptionButton.isSelected());
        }
    }

    class ToggleModeAction
    extends AbstractAction {
        public ToggleModeAction() {
            super("toggle", IconPool.shared().get(PropertySheet.class.getResource("icons/category.gif")));
            this.putValue("ShortDescription", ResourceManager.get(PropertySheet.class).getString("PropertySheetPanel.category.shortDescription"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (PropertySheetPanel.this.asCategoryButton.isSelected()) {
                PropertySheetPanel.this.model.setMode(1);
            } else {
                PropertySheetPanel.this.model.setMode(0);
            }
        }
    }

    class ToggleSortingAction
    extends AbstractAction {
        public ToggleSortingAction() {
            super("toggleSorting", IconPool.shared().get(PropertySheet.class.getResource("icons/sort.gif")));
            this.putValue("ShortDescription", ResourceManager.get(PropertySheet.class).getString("PropertySheetPanel.sort.shortDescription"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PropertySheetPanel.this.setSorting(PropertySheetPanel.this.sortButton.isSelected());
        }
    }
}

