/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.propertysheet;

import com.l2fprod.common.propertysheet.CellEditorAdapter;
import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertyEditorFactory;
import com.l2fprod.common.propertysheet.PropertyEditorRegistry;
import com.l2fprod.common.propertysheet.PropertyRendererFactory;
import com.l2fprod.common.propertysheet.PropertyRendererRegistry;
import com.l2fprod.common.propertysheet.PropertySheetTableModel;
import com.l2fprod.common.swing.HeaderlessColumnResizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyEditor;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class PropertySheetTable
extends JTable {
    private static final int HOTSPOT_SIZE = 30;
    private static final String TREE_EXPANDED_ICON_KEY = "Tree.expandedIcon";
    private static final String TREE_COLLAPSED_ICON_KEY = "Tree.collapsedIcon";
    private static final String TABLE_BACKGROUND_COLOR_KEY = "Table.background";
    private static final String TABLE_FOREGROUND_COLOR_KEY = "Table.foreground";
    private static final String TABLE_SELECTED_BACKGROUND_COLOR_KEY = "Table.selectionBackground";
    private static final String TABLE_SELECTED_FOREGROUND_COLOR_KEY = "Table.selectionForeground";
    private static final String PANEL_BACKGROUND_COLOR_KEY = "Panel.background";
    private PropertyEditorFactory editorFactory;
    private PropertyRendererFactory rendererFactory;
    private TableCellRenderer categoryValueRenderer;
    private TableCellRenderer nameRenderer;
    private boolean wantsExtraIndent = false;
    private TableModelListener cancelEditing;

    public PropertySheetTable() {
        this(new PropertySheetTableModel());
    }

    public PropertySheetTable(PropertySheetTableModel propertySheetTableModel) {
        super(propertySheetTableModel);
        this.addMouseListener(new CategoryVisibilityToggle());
        this.getSelectionModel().setSelectionMode(0);
        Dimension dimension = new Dimension(0, 0);
        this.getTableHeader().setPreferredSize(dimension);
        this.getTableHeader().setMinimumSize(dimension);
        this.getTableHeader().setMaximumSize(dimension);
        this.getTableHeader().setVisible(false);
        new HeaderlessColumnResizer(this);
        this.setRendererFactory(new PropertyRendererRegistry());
        this.setEditorFactory(new PropertyEditorRegistry());
        this.categoryValueRenderer = new CategoryValueRenderer();
        this.nameRenderer = new NameRenderer();
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.setRowHeight(30);
    }

    public void setEditorFactory(PropertyEditorFactory propertyEditorFactory) {
        this.editorFactory = propertyEditorFactory;
    }

    public final PropertyEditorFactory getEditorFactory() {
        return this.editorFactory;
    }

    public void setEditorRegistry(PropertyEditorRegistry propertyEditorRegistry) {
        this.setEditorFactory(propertyEditorRegistry);
    }

    public PropertyEditorRegistry getEditorRegistry() {
        return (PropertyEditorRegistry)this.editorFactory;
    }

    public void setRendererFactory(PropertyRendererFactory propertyRendererFactory) {
        this.rendererFactory = propertyRendererFactory;
    }

    public PropertyRendererFactory getRendererFactory() {
        return this.rendererFactory;
    }

    public void setRendererRegistry(PropertyRendererRegistry propertyRendererRegistry) {
        this.setRendererFactory(propertyRendererRegistry);
    }

    public PropertyRendererRegistry getRendererRegistry() {
        return (PropertyRendererRegistry)this.getRendererFactory();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n2 == 0) {
            return false;
        }
        PropertySheetTableModel.Item item = this.getSheetModel().getPropertySheetElement(n);
        return item.isProperty() && item.getProperty().isEditable();
    }

    @Override
    public TableCellEditor getCellEditor(int n, int n2) {
        if (n2 == 0) {
            return null;
        }
        PropertySheetTableModel.Item item = this.getSheetModel().getPropertySheetElement(n);
        if (!item.isProperty()) {
            return null;
        }
        CellEditorAdapter cellEditorAdapter = null;
        Property property = item.getProperty();
        PropertyEditor propertyEditor = this.getEditorFactory().createPropertyEditor(property);
        if (propertyEditor != null) {
            cellEditorAdapter = new CellEditorAdapter(propertyEditor);
        }
        return cellEditorAdapter;
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        PropertySheetTableModel propertySheetTableModel = (PropertySheetTableModel)this.getModel();
        PropertySheetTableModel.Item item = propertySheetTableModel.getPropertySheetElement(n);
        switch (n2) {
            case 0: {
                return this.nameRenderer;
            }
            case 1: {
                if (!item.isProperty()) {
                    return this.categoryValueRenderer;
                }
                Property property = item.getProperty();
                TableCellRenderer tableCellRenderer = this.getRendererFactory().createTableCellRenderer(property);
                if (tableCellRenderer == null) {
                    tableCellRenderer = this.getCellRenderer(property.getType());
                }
                return new WrappedRenderer(tableCellRenderer);
            }
        }
        return super.getCellRenderer(n, n2);
    }

    private TableCellRenderer getCellRenderer(Class clazz) {
        TableCellRenderer tableCellRenderer = this.getRendererFactory().createTableCellRenderer(clazz);
        if (tableCellRenderer == null && clazz != null) {
            tableCellRenderer = this.getCellRenderer(clazz.getSuperclass());
        }
        if (tableCellRenderer == null) {
            tableCellRenderer = super.getDefaultRenderer(Object.class);
        }
        return tableCellRenderer;
    }

    public final PropertySheetTableModel getSheetModel() {
        return (PropertySheetTableModel)this.getModel();
    }

    @Override
    public void setModel(TableModel tableModel) {
        TableModel tableModel2;
        if (!(tableModel instanceof PropertySheetTableModel)) {
            throw new IllegalArgumentException("dataModel must be of type " + PropertySheetTableModel.class.getName());
        }
        if (this.cancelEditing == null) {
            this.cancelEditing = new CancelEditing();
        }
        if ((tableModel2 = this.getModel()) != null) {
            tableModel2.removeTableModelListener(this.cancelEditing);
        }
        super.setModel(tableModel);
        tableModel.addTableModelListener(this.cancelEditing);
        this.getColumnModel().getColumn(1).setResizable(false);
    }

    public boolean getWantsExtraIndent() {
        return this.wantsExtraIndent;
    }

    public void setWantsExtraIndent(boolean bl) {
        this.wantsExtraIndent = bl;
        this.repaint();
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.getPreferredSize().height < this.getParent().getHeight();
    }

    public void commitEditing() {
        TableCellEditor tableCellEditor = this.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
    }

    public void cancelEditing() {
        TableCellEditor tableCellEditor = this.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.cancelCellEditing();
        }
    }

    static int getIndent(PropertySheetTable propertySheetTable, PropertySheetTableModel.Item item) {
        int n = 0;
        if (item.isProperty()) {
            n = (item.getParent() == null || !item.getParent().isProperty()) && !item.hasToggle() ? (propertySheetTable.getWantsExtraIndent() ? 30 : 0) : (item.hasToggle() ? item.getDepth() * 30 : (item.getDepth() + 1) * 30);
            if (propertySheetTable.getSheetModel().getMode() == 1 && propertySheetTable.getWantsExtraIndent()) {
                n += 30;
            }
        } else {
            n = 0;
        }
        return n;
    }

    private class CancelEditing
    implements TableModelListener {
        private CancelEditing() {
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            if (tableModelEvent.getType() == 0) {
                int n = tableModelEvent.getFirstRow();
                int n2 = tableModelEvent.getLastRow();
                int n3 = PropertySheetTable.this.getEditingRow();
                TableCellEditor tableCellEditor = PropertySheetTable.this.getCellEditor();
                if (tableCellEditor != null && n <= n3 && n3 <= n2) {
                    tableCellEditor.cancelCellEditing();
                }
            }
        }
    }

    private static class CategoryValueRenderer
    extends DefaultTableCellRenderer {
        private Color background;
        private Color foreground;

        public CategoryValueRenderer() {
            this(UIManager.getColor(PropertySheetTable.PANEL_BACKGROUND_COLOR_KEY), UIManager.getColor(PropertySheetTable.PANEL_BACKGROUND_COLOR_KEY).darker().darker().darker());
        }

        public CategoryValueRenderer(Color color, Color color2) {
            this.background = color;
            this.foreground = color2;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setBackground(this.background);
            this.setForeground(this.foreground);
            this.setText("");
            return this;
        }
    }

    private static class CategoryVisibilityToggle
    extends MouseAdapter {
        private CategoryVisibilityToggle() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            PropertySheetTable propertySheetTable = (PropertySheetTable)mouseEvent.getComponent();
            int n = propertySheetTable.rowAtPoint(mouseEvent.getPoint());
            int n2 = propertySheetTable.columnAtPoint(mouseEvent.getPoint());
            if (n != -1 && n2 == 0) {
                PropertySheetTableModel.Item item = propertySheetTable.getSheetModel().getPropertySheetElement(n);
                int n3 = mouseEvent.getX() - PropertySheetTable.getIndent(propertySheetTable, item);
                if (n3 > 0 && n3 < 30) {
                    item.toggle();
                }
            }
        }
    }

    private static class CellBorder
    implements Border {
        private Color background = UIManager.getColor("Panel.background");
        private int indentWidth;
        private boolean showToggle;
        private boolean toggleState;
        private Icon expandedIcon = (Icon)UIManager.get("Tree.expandedIcon");
        private Icon collapsedIcon = (Icon)UIManager.get("Tree.collapsedIcon");
        private Insets insets = new Insets(1, 0, 1, 1);
        private boolean isProperty;

        private CellBorder() {
        }

        public void configure(PropertySheetTable propertySheetTable, PropertySheetTableModel.Item item) {
            this.isProperty = item.isProperty();
            this.toggleState = item.isVisible();
            this.showToggle = item.hasToggle();
            this.indentWidth = PropertySheetTable.getIndent(propertySheetTable, item);
            this.insets.left = this.indentWidth + (this.showToggle ? 30 : 0) + 2;
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return this.insets;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Object object;
            if (!this.isProperty) {
                object = graphics.getColor();
                graphics.setColor(this.background);
                graphics.fillRect(n, n2, n + 30 - 2, n2 + n4);
                graphics.setColor((Color)object);
            }
            if (this.showToggle) {
                object = this.toggleState ? this.expandedIcon : this.collapsedIcon;
                object.paintIcon(component, graphics, n + this.indentWidth + (28 - object.getIconWidth()) / 2, n2 + (n4 - object.getIconHeight()) / 2);
            }
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }

    private static class NameRenderer
    extends DefaultTableCellRenderer {
        private Color background;
        private Color foreground;
        private Color propertyBackground;
        private Color propertyForeground;
        private Color selectedBackground;
        private Color selectedForeground;
        private CellBorder border;

        public NameRenderer() {
            this(UIManager.getColor(PropertySheetTable.PANEL_BACKGROUND_COLOR_KEY), UIManager.getColor(PropertySheetTable.PANEL_BACKGROUND_COLOR_KEY).darker());
        }

        public NameRenderer(Color color, Color color2) {
            this.background = color;
            this.foreground = color2;
            this.propertyBackground = UIManager.getColor(PropertySheetTable.TABLE_BACKGROUND_COLOR_KEY);
            this.propertyForeground = UIManager.getColor(PropertySheetTable.TABLE_FOREGROUND_COLOR_KEY);
            this.selectedBackground = UIManager.getColor(PropertySheetTable.TABLE_SELECTED_BACKGROUND_COLOR_KEY);
            this.selectedForeground = UIManager.getColor(PropertySheetTable.TABLE_SELECTED_FOREGROUND_COLOR_KEY);
            this.border = new CellBorder();
        }

        private Color getForeground(boolean bl, boolean bl2) {
            return bl ? (bl2 ? this.selectedForeground : this.propertyForeground) : this.foreground;
        }

        private Color getBackground(boolean bl, boolean bl2) {
            return bl ? (bl2 ? this.selectedBackground : this.propertyBackground) : this.background;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setBorder(this.border);
            PropertySheetTableModel.Item item = (PropertySheetTableModel.Item)object;
            this.border.configure((PropertySheetTable)jTable, item);
            this.setBackground(this.getBackground(item.isProperty(), bl));
            this.setForeground(this.getForeground(item.isProperty(), bl));
            if (item.getProperty().isEditable()) {
                this.setForeground(Color.RED);
            }
            this.setFont(this.getFont().deriveFont(item.isProperty() ? 0 : 1));
            this.setText(item.getName());
            return this;
        }
    }

    private static class WrappedRenderer
    implements TableCellRenderer {
        private TableCellRenderer renderer;

        public WrappedRenderer(TableCellRenderer tableCellRenderer) {
            this.renderer = tableCellRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return this.renderer.getTableCellRendererComponent(jTable, object, false, false, n, n2);
        }
    }
}

