/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.propertysheet;

import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertySheet;
import com.l2fprod.common.swing.ObjectTableModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class PropertySheetTableModel
extends AbstractTableModel
implements PropertyChangeListener,
PropertySheet,
ObjectTableModel {
    public static final int NAME_COLUMN = 0;
    public static final int VALUE_COLUMN = 1;
    public static final int NUM_COLUMNS = 2;
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private List model = new ArrayList();
    private List publishedModel = new ArrayList();
    private List properties = new ArrayList();
    private int mode = 0;
    private boolean sortingCategories = false;
    private boolean sortingProperties = false;
    private Comparator categorySortingComparator;
    private Comparator propertySortingComparator;
    private static final Comparator STRING_COMPARATOR = new NaturalOrderStringComparator();

    @Override
    public void setProperties(Property[] propertyArray) {
        int n;
        Property[] propertyArray2;
        for (Property property : this.properties) {
            property.removePropertyChangeListener(this);
            propertyArray2 = property.getSubProperties();
            if (propertyArray2 == null) continue;
            n = 0;
            while (n < propertyArray2.length) {
                propertyArray2[n].removePropertyChangeListener(this);
                ++n;
            }
        }
        this.properties.clear();
        this.properties.addAll(Arrays.asList(propertyArray));
        for (Property property : this.properties) {
            property.addPropertyChangeListener(this);
            propertyArray2 = property.getSubProperties();
            if (propertyArray2 == null) continue;
            n = 0;
            while (n < propertyArray2.length) {
                propertyArray2[n].addPropertyChangeListener(this);
                ++n;
            }
        }
        this.buildModel();
    }

    @Override
    public Property[] getProperties() {
        return this.properties.toArray(new Property[this.properties.size()]);
    }

    @Override
    public void addProperty(Property property) {
        this.properties.add(property);
        property.addPropertyChangeListener(this);
        this.buildModel();
    }

    @Override
    public void addProperty(int n, Property property) {
        this.properties.add(n, property);
        property.addPropertyChangeListener(this);
        this.buildModel();
    }

    @Override
    public void removeProperty(Property property) {
        this.properties.remove(property);
        property.removePropertyChangeListener(this);
        this.buildModel();
    }

    @Override
    public int getPropertyCount() {
        return this.properties.size();
    }

    @Override
    public Iterator propertyIterator() {
        return this.properties.iterator();
    }

    public void setMode(int n) {
        if (this.mode == n) {
            return;
        }
        this.mode = n;
        this.buildModel();
    }

    public int getMode() {
        return this.mode;
    }

    public Class getColumnClass(int n) {
        return super.getColumnClass(n);
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.publishedModel.size();
    }

    @Override
    public Object getObject(int n) {
        return this.getPropertySheetElement(n);
    }

    public Item getPropertySheetElement(int n) {
        return (Item)this.publishedModel.get(n);
    }

    public boolean isSortingCategories() {
        return this.sortingCategories;
    }

    public void setSortingCategories(boolean bl) {
        boolean bl2 = this.sortingCategories;
        this.sortingCategories = bl;
        if (this.sortingCategories != bl2) {
            this.buildModel();
        }
    }

    public boolean isSortingProperties() {
        return this.sortingProperties;
    }

    public void setSortingProperties(boolean bl) {
        boolean bl2 = this.sortingProperties;
        this.sortingProperties = bl;
        if (this.sortingProperties != bl2) {
            this.buildModel();
        }
    }

    public void setCategorySortingComparator(Comparator comparator) {
        Comparator comparator2 = this.categorySortingComparator;
        this.categorySortingComparator = comparator;
        if (this.categorySortingComparator != comparator2) {
            this.buildModel();
        }
    }

    public void setPropertySortingComparator(Comparator comparator) {
        Comparator comparator2 = this.propertySortingComparator;
        this.propertySortingComparator = comparator;
        if (this.propertySortingComparator != comparator2) {
            this.buildModel();
        }
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object object = null;
        Item item = this.getPropertySheetElement(n);
        if (item.isProperty()) {
            switch (n2) {
                case 0: {
                    object = item;
                    break;
                }
                case 1: {
                    try {
                        object = item.getProperty().getValue();
                        break;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        } else {
            object = item;
        }
        return object;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        Item item = this.getPropertySheetElement(n);
        if (item.isProperty() && n2 == 1) {
            try {
                item.getProperty().setValue(object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.listeners.firePropertyChange(propertyChangeEvent);
    }

    protected void visibilityChanged() {
        this.publishedModel.clear();
        for (Item item : this.model) {
            Item item2 = item.getParent();
            if (item2 != null && !item2.isVisible()) continue;
            this.publishedModel.add(item);
        }
        this.fireTableDataChanged();
    }

    private void buildModel() {
        this.model.clear();
        this.publishedModel.clear();
        if (this.properties != null && this.properties.size() > 0) {
            List list = this.sortProperties(this.properties);
            switch (this.mode) {
                case 0: {
                    this.addPropertiesToModel(list, null);
                    break;
                }
                case 1: {
                    List list2 = this.sortCategories(this.getPropertyCategories(list));
                    for (String string : list2) {
                        Item item = new Item(string, null);
                        this.model.add(item);
                        this.addPropertiesToModel(this.sortProperties(this.getPropertiesForCategory(this.properties, string)), item);
                    }
                    break;
                }
            }
        }
        this.visibilityChanged();
        this.fireTableDataChanged();
    }

    protected List sortProperties(List list) {
        ArrayList arrayList = new ArrayList(list);
        if (this.sortingProperties) {
            if (this.propertySortingComparator == null) {
                this.propertySortingComparator = new PropertyComparator();
            }
            Collections.sort(arrayList, this.propertySortingComparator);
        }
        return arrayList;
    }

    protected List sortCategories(List list) {
        ArrayList arrayList = new ArrayList(list);
        if (this.sortingCategories) {
            if (this.categorySortingComparator == null) {
                this.categorySortingComparator = STRING_COMPARATOR;
            }
            Collections.sort(arrayList, this.categorySortingComparator);
        }
        return arrayList;
    }

    protected List getPropertyCategories(List list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Property property : list) {
            if (arrayList.contains(property.getCategory())) continue;
            arrayList.add(property.getCategory());
        }
        return arrayList;
    }

    private void addPropertiesToModel(List list, Item item) {
        for (Property property : list) {
            Item item2 = new Item(property, item);
            this.model.add(item2);
            Property[] propertyArray = property.getSubProperties();
            if (propertyArray == null || propertyArray.length <= 0) continue;
            this.addPropertiesToModel(Arrays.asList(propertyArray), item2);
        }
    }

    private List getPropertiesForCategory(List list, String string) {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        for (Property property : list) {
            if (string != property.getCategory() && (string == null || !string.equals(property.getCategory()))) continue;
            arrayList.add(property);
        }
        return arrayList;
    }

    public class Item {
        private String name;
        private Property property;
        private Item parent;
        private boolean hasToggle = true;
        private boolean visible = true;

        private Item(String string, Item item) {
            this.name = string;
            this.parent = item;
            this.hasToggle = true;
        }

        private Item(Property property, Item item) {
            this.name = property.getDisplayName();
            this.property = property;
            this.parent = item;
            this.visible = property == null;
            Property[] propertyArray = property.getSubProperties();
            this.hasToggle = propertyArray != null && propertyArray.length > 0;
        }

        public String getName() {
            return this.name;
        }

        public boolean isProperty() {
            return this.property != null;
        }

        public Property getProperty() {
            return this.property;
        }

        public Item getParent() {
            return this.parent;
        }

        public int getDepth() {
            int n = 0;
            if (this.parent != null) {
                n = this.parent.getDepth();
                if (this.parent.isProperty()) {
                    ++n;
                }
            }
            return n;
        }

        public boolean hasToggle() {
            return this.hasToggle;
        }

        public void toggle() {
            if (this.hasToggle()) {
                this.visible = !this.visible;
                PropertySheetTableModel.this.visibilityChanged();
            }
        }

        public boolean isVisible() {
            return !(this.parent != null && !this.parent.isVisible() || this.hasToggle && !this.visible);
        }
    }

    public static class NaturalOrderStringComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            String string = (String)object;
            String string2 = (String)object2;
            if (string == null) {
                return string2 == null ? 0 : -1;
            }
            if (string2 == null) {
                return 1;
            }
            return string.compareTo(string2);
        }
    }

    public static class PropertyComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            if (object instanceof Property && object2 instanceof Property) {
                Property property = (Property)object;
                Property property2 = (Property)object2;
                if (property == null) {
                    return property2 == null ? 0 : -1;
                }
                return STRING_COMPARATOR.compare(property.getDisplayName() == null ? null : property.getDisplayName().toLowerCase(), property2.getDisplayName() == null ? null : property2.getDisplayName().toLowerCase());
            }
            return 0;
        }
    }
}

