/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing;

import com.l2fprod.common.swing.LookAndFeelTweaks;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.text.JTextComponent;

public class BannerPanel
extends JPanel {
    private JLabel titleLabel;
    private JTextComponent subtitleLabel;
    private JLabel iconLabel;

    public BannerPanel() {
        this.setBorder(new CompoundBorder(new EtchedBorder(), LookAndFeelTweaks.PANEL_BORDER));
        this.setOpaque(true);
        this.setBackground(UIManager.getColor("Table.background"));
        this.titleLabel = new JLabel();
        this.titleLabel.setOpaque(false);
        this.subtitleLabel = new JEditorPane("text/html", "<html>");
        this.subtitleLabel.setFont(this.titleLabel.getFont());
        LookAndFeelTweaks.makeBold(this.titleLabel);
        LookAndFeelTweaks.makeMultilineLabel(this.subtitleLabel);
        LookAndFeelTweaks.htmlize(this.subtitleLabel);
        this.iconLabel = new JLabel();
        this.iconLabel.setPreferredSize(new Dimension(50, 50));
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.add("North", this.titleLabel);
        jPanel.add("Center", this.subtitleLabel);
        this.add("Center", jPanel);
        this.add("East", this.iconLabel);
    }

    public void setTitleColor(Color color) {
        this.titleLabel.setForeground(color);
    }

    public Color getTitleColor() {
        return this.titleLabel.getForeground();
    }

    public void setSubtitleColor(Color color) {
        this.subtitleLabel.setForeground(color);
    }

    public Color getSubtitleColor() {
        return this.subtitleLabel.getForeground();
    }

    public void setTitle(String string) {
        this.titleLabel.setText(string);
    }

    public String getTitle() {
        return this.titleLabel.getText();
    }

    public void setSubtitle(String string) {
        this.subtitleLabel.setText(string);
    }

    public String getSubtitle() {
        return this.subtitleLabel.getText();
    }

    public void setSubtitleVisible(boolean bl) {
        this.subtitleLabel.setVisible(bl);
    }

    public boolean isSubtitleVisible() {
        return this.subtitleLabel.isVisible();
    }

    public void setIcon(Icon icon) {
        this.iconLabel.setIcon(icon);
    }

    public Icon getIcon() {
        return this.iconLabel.getIcon();
    }

    public void setIconVisible(boolean bl) {
        this.iconLabel.setVisible(bl);
    }

    public boolean isIconVisible() {
        return this.iconLabel.isVisible();
    }
}

