/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing;

import com.l2fprod.common.swing.FontChooserModel;
import com.l2fprod.common.swing.plaf.FontChooserUI;
import java.awt.GraphicsEnvironment;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.SortedMap;

public class DefaultFontChooserModel
implements FontChooserModel {
    private static final int[] DEFAULT_FONT_SIZES = new int[]{6, 8, 10, 11, 12, 14, 16, 18, 20, 22, 24, 26, 28, 32, 40, 48, 56, 64, 72};
    private final String[] fontFamilies = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    private final String[] charSets;
    private final String previewMessage;

    public DefaultFontChooserModel() {
        Arrays.sort(this.fontFamilies);
        SortedMap<String, Charset> sortedMap = Charset.availableCharsets();
        this.charSets = new String[sortedMap.size()];
        int n = 0;
        Object object = sortedMap.keySet().iterator();
        while (object.hasNext()) {
            this.charSets[n] = object.next();
            ++n;
        }
        object = ResourceBundle.getBundle(String.valueOf(FontChooserUI.class.getName()) + "RB");
        this.previewMessage = ((ResourceBundle)object).getString("FontChooserUI.previewText");
    }

    @Override
    public String[] getFontFamilies(String string) {
        return this.fontFamilies;
    }

    @Override
    public int[] getDefaultSizes() {
        return DEFAULT_FONT_SIZES;
    }

    @Override
    public String[] getCharSets() {
        return this.charSets;
    }

    @Override
    public String getPreviewMessage(String string) {
        return this.previewMessage;
    }
}

