/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.TableColumn;

public class HeaderlessColumnResizer
extends MouseInputAdapter {
    private static Cursor resizeCursor = Cursor.getPredefinedCursor(11);
    private int mouseXOffset;
    private Cursor otherCursor = resizeCursor;
    private JTable table;

    public HeaderlessColumnResizer(JTable jTable) {
        this.table = jTable;
        jTable.addMouseListener(this);
        jTable.addMouseMotionListener(this);
    }

    private boolean canResize(TableColumn tableColumn) {
        return tableColumn != null && this.table.getTableHeader().getResizingAllowed() && tableColumn.getResizable();
    }

    private TableColumn getResizingColumn(Point point) {
        return this.getResizingColumn(point, this.table.columnAtPoint(point));
    }

    private TableColumn getResizingColumn(Point point, int n) {
        int n2;
        if (n == -1) {
            return null;
        }
        int n3 = this.table.rowAtPoint(point);
        Rectangle rectangle = this.table.getCellRect(n3, n, true);
        rectangle.grow(-3, 0);
        if (rectangle.contains(point)) {
            return null;
        }
        int n4 = rectangle.x + rectangle.width / 2;
        if (this.table.getTableHeader().getComponentOrientation().isLeftToRight()) {
            n2 = point.x < n4 ? n - 1 : n;
        } else {
            int n5 = n2 = point.x < n4 ? n : n - 1;
        }
        if (n2 == -1) {
            return null;
        }
        return this.table.getTableHeader().getColumnModel().getColumn(n2);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        TableColumn tableColumn;
        this.table.getTableHeader().setDraggedColumn(null);
        this.table.getTableHeader().setResizingColumn(null);
        this.table.getTableHeader().setDraggedDistance(0);
        Point point = mouseEvent.getPoint();
        int n = this.table.columnAtPoint(point);
        if (n != -1 && this.canResize(tableColumn = this.getResizingColumn(point, n))) {
            this.table.getTableHeader().setResizingColumn(tableColumn);
            this.mouseXOffset = this.table.getTableHeader().getComponentOrientation().isLeftToRight() ? point.x - tableColumn.getWidth() : point.x + tableColumn.getWidth();
        }
    }

    private void swapCursor() {
        Cursor cursor = this.table.getCursor();
        this.table.setCursor(this.otherCursor);
        this.otherCursor = cursor;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.canResize(this.getResizingColumn(mouseEvent.getPoint())) != (this.table.getCursor() == resizeCursor)) {
            this.swapCursor();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        TableColumn tableColumn = this.table.getTableHeader().getResizingColumn();
        boolean bl = this.table.getTableHeader().getComponentOrientation().isLeftToRight();
        if (tableColumn != null) {
            Container container;
            int n2 = tableColumn.getWidth();
            int n3 = bl ? n - this.mouseXOffset : this.mouseXOffset - n;
            tableColumn.setWidth(n3);
            if (this.table.getTableHeader().getParent() == null || (container = this.table.getTableHeader().getParent().getParent()) == null || !(container instanceof JScrollPane)) {
                return;
            }
            if (!container.getComponentOrientation().isLeftToRight() && !bl && this.table != null) {
                JViewport jViewport = ((JScrollPane)container).getViewport();
                int n4 = jViewport.getWidth();
                int n5 = n3 - n2;
                int n6 = this.table.getWidth() + n5;
                Dimension dimension = this.table.getSize();
                dimension.width += n5;
                this.table.setSize(dimension);
                if (n6 >= n4 && this.table.getAutoResizeMode() == 0) {
                    Point point = jViewport.getViewPosition();
                    point.x = Math.max(0, Math.min(n6 - n4, point.x + n5));
                    jViewport.setViewPosition(point);
                    this.mouseXOffset += n5;
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.table.getTableHeader().setResizingColumn(null);
        this.table.getTableHeader().setDraggedColumn(null);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

