/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing;

import com.l2fprod.common.swing.plaf.ButtonBarButtonUI;
import com.l2fprod.common.swing.plaf.ButtonBarUI;
import com.l2fprod.common.swing.plaf.JButtonBarAddon;
import com.l2fprod.common.swing.plaf.LookAndFeelAddons;
import java.awt.Component;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.SwingConstants;

public class JButtonBar
extends JComponent
implements SwingConstants {
    public static final String UI_CLASS_ID = "ButtonBarUI";
    public static final String ORIENTATION_CHANGED_KEY = "orientation";
    private int orientation;
    private static PropertyChangeListener uiUpdater;
    private static ContainerListener buttonTracker;

    static {
        LookAndFeelAddons.contribute(new JButtonBarAddon());
        uiUpdater = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                AbstractButton abstractButton;
                if (propertyChangeEvent.getSource() instanceof AbstractButton && (abstractButton = (AbstractButton)propertyChangeEvent.getSource()).getParent() instanceof JButtonBar && !(abstractButton.getUI() instanceof ButtonBarButtonUI)) {
                    ((ButtonBarUI)((JButtonBar)abstractButton.getParent()).ui).installButtonBarUI(abstractButton);
                }
            }
        };
        buttonTracker = new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent containerEvent) {
                JButtonBar jButtonBar = (JButtonBar)containerEvent.getContainer();
                if (containerEvent.getChild() instanceof AbstractButton) {
                    ((ButtonBarUI)jButtonBar.ui).installButtonBarUI((AbstractButton)containerEvent.getChild());
                    ((AbstractButton)containerEvent.getChild()).addPropertyChangeListener("UI", uiUpdater);
                }
            }

            @Override
            public void componentRemoved(ContainerEvent containerEvent) {
                if (containerEvent.getChild() instanceof AbstractButton) {
                    ((AbstractButton)containerEvent.getChild()).removePropertyChangeListener("UI", uiUpdater);
                }
            }
        };
    }

    public JButtonBar() {
        this(0);
    }

    public JButtonBar(int n) {
        this.orientation = n;
        this.updateUI();
        this.addContainerListener(buttonTracker);
    }

    @Override
    public void updateUI() {
        this.setUI((ButtonBarUI)LookAndFeelAddons.getUI(this, ButtonBarUI.class));
    }

    @Override
    public ButtonBarUI getUI() {
        return (ButtonBarUI)this.ui;
    }

    public void setUI(ButtonBarUI buttonBarUI) {
        super.setUI(buttonBarUI);
        Component[] componentArray = this.getComponents();
        int n = 0;
        int n2 = componentArray.length;
        while (n < n2) {
            if (componentArray[n] instanceof AbstractButton) {
                buttonBarUI.installButtonBarUI((AbstractButton)componentArray[n]);
            }
            ++n;
        }
    }

    @Override
    public String getUIClassID() {
        return UI_CLASS_ID;
    }

    public void setOrientation(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("orientation must be one of: VERTICAL, HORIZONTAL");
        }
        if (this.orientation != n) {
            int n2 = this.orientation;
            this.orientation = n;
            this.firePropertyChange(ORIENTATION_CHANGED_KEY, n2, this.orientation);
        }
    }

    public int getOrientation() {
        return this.orientation;
    }
}

