/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing;

import com.l2fprod.common.swing.PercentLayout;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class JCollapsiblePane
extends JPanel {
    public static final String ANIMATION_STATE_KEY = "animationState";
    private boolean collapsed = false;
    private Timer animateTimer;
    private AnimationListener animator;
    private int currentHeight = -1;
    private WrapperContainer wrapper;
    private boolean useAnimation = true;
    private AnimationParams animationParams;

    public JCollapsiblePane() {
        super.setLayout(new BorderLayout(0, 0));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new PercentLayout(1, 2));
        this.setContentPane(jPanel);
        this.animator = new AnimationListener();
        this.setAnimationParams(new AnimationParams(30, 8, 0.01f, 1.0f));
        this.getActionMap().put("toggle", new AbstractAction("Toggle"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCollapsiblePane.this.setCollapsed(!JCollapsiblePane.this.isCollapsed());
            }
        });
    }

    public void setContentPane(Container container) {
        if (container == null) {
            throw new IllegalArgumentException("Content pane can't be null");
        }
        if (this.wrapper != null) {
            super.remove(this.wrapper);
        }
        this.wrapper = new WrapperContainer(container);
        super.addImpl(this.wrapper, "Center", -1);
    }

    public Container getContentPane() {
        return this.wrapper.c;
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
        if (this.wrapper != null) {
            this.getContentPane().setLayout(layoutManager);
        }
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        this.getContentPane().add(component, object, n);
    }

    @Override
    public void remove(Component component) {
        this.getContentPane().remove(component);
    }

    @Override
    public void remove(int n) {
        this.getContentPane().remove(n);
    }

    @Override
    public void removeAll() {
        this.getContentPane().removeAll();
    }

    public void setAnimated(boolean bl) {
        if (bl != this.useAnimation) {
            this.useAnimation = bl;
            this.firePropertyChange("animated", !this.useAnimation, this.useAnimation);
        }
    }

    public boolean isAnimated() {
        return this.useAnimation;
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setCollapsed(boolean bl) {
        if (this.collapsed != bl) {
            this.collapsed = bl;
            if (this.isAnimated()) {
                if (this.collapsed) {
                    this.setAnimationParams(new AnimationParams(30, Math.max(8, this.wrapper.getHeight() / 10), 1.0f, 0.01f));
                    this.animator.reinit(this.wrapper.getHeight(), 0);
                    this.animateTimer.start();
                } else {
                    this.setAnimationParams(new AnimationParams(30, Math.max(8, this.getContentPane().getPreferredSize().height / 10), 0.01f, 1.0f));
                    this.animator.reinit(this.wrapper.getHeight(), this.getContentPane().getPreferredSize().height);
                    this.animateTimer.start();
                }
            } else {
                this.wrapper.c.setVisible(!this.collapsed);
                this.invalidate();
                this.doLayout();
            }
            this.repaint();
            this.firePropertyChange("collapsed", !this.collapsed, this.collapsed);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension;
        if (!this.isAnimated()) {
            dimension = this.getContentPane().isVisible() ? this.getContentPane().getPreferredSize() : super.getPreferredSize();
        } else {
            dimension = new Dimension(this.getContentPane().getPreferredSize());
            if (!this.getContentPane().isVisible() && this.currentHeight != -1) {
                dimension.height = this.currentHeight;
            }
        }
        return dimension;
    }

    private void setAnimationParams(AnimationParams animationParams) {
        if (animationParams == null) {
            throw new IllegalArgumentException("params can't be null");
        }
        if (this.animateTimer != null) {
            this.animateTimer.stop();
        }
        this.animationParams = animationParams;
        this.animateTimer = new Timer(this.animationParams.waitTime, this.animator);
        this.animateTimer.setInitialDelay(0);
    }

    private final class AnimationListener
    implements ActionListener {
        private final Object ANIMATION_MUTEX = "Animation Synchronization Mutex";
        private int startHeight = 0;
        private int finalHeight = 0;
        private float animateAlpha = 1.0f;

        private AnimationListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = this.ANIMATION_MUTEX;
            synchronized (object) {
                if (this.startHeight == this.finalHeight) {
                    JCollapsiblePane.this.animateTimer.stop();
                    this.animateAlpha = ((JCollapsiblePane)JCollapsiblePane.this).animationParams.alphaEnd;
                    if (this.finalHeight > 0) {
                        JCollapsiblePane.this.wrapper.showContent();
                        this.validate();
                        JCollapsiblePane.this.firePropertyChange(JCollapsiblePane.ANIMATION_STATE_KEY, null, "expanded");
                        return;
                    }
                }
                boolean bl = this.startHeight > this.finalHeight;
                int n = bl ? -1 * ((JCollapsiblePane)JCollapsiblePane.this).animationParams.deltaY : ((JCollapsiblePane)JCollapsiblePane.this).animationParams.deltaY;
                int n2 = JCollapsiblePane.this.wrapper.getHeight() + n;
                if (bl) {
                    if (n2 < this.finalHeight) {
                        n2 = this.finalHeight;
                    }
                } else if (n2 > this.finalHeight) {
                    n2 = this.finalHeight;
                }
                this.animateAlpha = (float)n2 / (float)((WrapperContainer)((JCollapsiblePane)JCollapsiblePane.this).wrapper).c.getPreferredSize().height;
                Rectangle rectangle = JCollapsiblePane.this.wrapper.getBounds();
                int n3 = rectangle.height;
                rectangle.height = n2;
                JCollapsiblePane.this.wrapper.setBounds(rectangle);
                rectangle = JCollapsiblePane.this.getBounds();
                rectangle.height = rectangle.height - n3 + n2;
                JCollapsiblePane.this.currentHeight = rectangle.height;
                JCollapsiblePane.this.setBounds(rectangle);
                this.startHeight = n2;
                if (bl) {
                    if (this.animateAlpha < ((JCollapsiblePane)JCollapsiblePane.this).animationParams.alphaEnd) {
                        this.animateAlpha = ((JCollapsiblePane)JCollapsiblePane.this).animationParams.alphaEnd;
                    }
                    if (this.animateAlpha > ((JCollapsiblePane)JCollapsiblePane.this).animationParams.alphaStart) {
                        this.animateAlpha = ((JCollapsiblePane)JCollapsiblePane.this).animationParams.alphaStart;
                    }
                } else {
                    if (this.animateAlpha > ((JCollapsiblePane)JCollapsiblePane.this).animationParams.alphaEnd) {
                        this.animateAlpha = ((JCollapsiblePane)JCollapsiblePane.this).animationParams.alphaEnd;
                    }
                    if (this.animateAlpha < ((JCollapsiblePane)JCollapsiblePane.this).animationParams.alphaStart) {
                        this.animateAlpha = ((JCollapsiblePane)JCollapsiblePane.this).animationParams.alphaStart;
                    }
                }
                ((JCollapsiblePane)JCollapsiblePane.this).wrapper.alpha = this.animateAlpha;
                this.validate();
            }
        }

        void validate() {
            Container container = SwingUtilities.getAncestorOfClass(JCollapsiblePaneContainer.class, JCollapsiblePane.this);
            container = container != null ? ((JCollapsiblePaneContainer)((Object)container)).getValidatingContainer() : JCollapsiblePane.this.getParent();
            if (container != null) {
                if (container instanceof JComponent) {
                    ((JComponent)container).revalidate();
                } else {
                    container.invalidate();
                }
                container.doLayout();
                container.repaint();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reinit(int n, int n2) {
            Object object = this.ANIMATION_MUTEX;
            synchronized (object) {
                JCollapsiblePane.this.firePropertyChange(JCollapsiblePane.ANIMATION_STATE_KEY, null, "reinit");
                this.startHeight = n;
                this.finalHeight = n2;
                this.animateAlpha = ((JCollapsiblePane)JCollapsiblePane.this).animationParams.alphaStart;
                JCollapsiblePane.this.currentHeight = -1;
                JCollapsiblePane.this.wrapper.showImage();
            }
        }
    }

    private static class AnimationParams {
        final int waitTime;
        final int deltaY;
        final float alphaStart;
        final float alphaEnd;

        public AnimationParams(int n, int n2, float f, float f2) {
            this.waitTime = n;
            this.deltaY = n2;
            this.alphaStart = f;
            this.alphaEnd = f2;
        }
    }

    public static interface JCollapsiblePaneContainer {
        public Container getValidatingContainer();
    }

    private final class WrapperContainer
    extends JPanel {
        private BufferedImage img;
        private Container c;
        float alpha;

        public WrapperContainer(Container container) {
            super(new BorderLayout());
            this.alpha = 1.0f;
            this.c = container;
            this.add((Component)container, "Center");
            if (container instanceof JComponent && !((JComponent)container).isOpaque()) {
                ((JComponent)container).setOpaque(true);
            }
        }

        public void showImage() {
            this.makeImage();
            this.c.setVisible(false);
        }

        public void showContent() {
            JCollapsiblePane.this.currentHeight = -1;
            this.c.setVisible(true);
        }

        void makeImage() {
            if (this.getGraphicsConfiguration() != null && this.getWidth() > 0) {
                Dimension dimension = this.c.getPreferredSize();
                if (dimension.height > 0) {
                    this.img = this.getGraphicsConfiguration().createCompatibleImage(this.getWidth(), dimension.height);
                    this.c.setSize(this.getWidth(), dimension.height);
                    this.c.paint(this.img.getGraphics());
                } else {
                    this.img = null;
                }
            }
        }

        @Override
        public void paintComponent(Graphics graphics) {
            if (!JCollapsiblePane.this.useAnimation || this.c.isVisible()) {
                super.paintComponent(graphics);
            } else {
                if (this.img == null) {
                    this.makeImage();
                }
                if (graphics != null && this.img != null) {
                    graphics.drawImage(this.img, 0, this.getHeight() - this.img.getHeight(), null);
                }
            }
        }

        @Override
        public void paint(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, this.alpha);
            graphics2D.setComposite(alphaComposite);
            super.paint(graphics2D);
            graphics2D.setComposite(composite);
        }
    }
}

