/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing;

import com.l2fprod.common.swing.BaseDialog;
import com.l2fprod.common.swing.DefaultFontChooserModel;
import com.l2fprod.common.swing.FontChooserModel;
import com.l2fprod.common.swing.plaf.FontChooserUI;
import com.l2fprod.common.swing.plaf.JFontChooserAddon;
import com.l2fprod.common.swing.plaf.LookAndFeelAddons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class JFontChooser
extends JComponent {
    public static final String SELECTED_FONT_CHANGED_KEY = "selectedFont";
    protected Font selectedFont;
    private FontChooserModel model;

    static {
        LookAndFeelAddons.contribute(new JFontChooserAddon());
    }

    public JFontChooser() {
        this(new DefaultFontChooserModel());
    }

    public JFontChooser(FontChooserModel fontChooserModel) {
        this.model = fontChooserModel;
        this.selectedFont = this.getFont();
        this.updateUI();
    }

    @Override
    public void updateUI() {
        this.setUI((FontChooserUI)LookAndFeelAddons.getUI(this, FontChooserUI.class));
    }

    public void setUI(FontChooserUI fontChooserUI) {
        super.setUI(fontChooserUI);
    }

    @Override
    public String getUIClassID() {
        return "FontChooserUI";
    }

    public void setSelectedFont(Font font) {
        Font font2 = this.selectedFont;
        this.selectedFont = font;
        this.firePropertyChange(SELECTED_FONT_CHANGED_KEY, font2, this.selectedFont);
    }

    public Font getSelectedFont() {
        return this.selectedFont;
    }

    public FontChooserModel getModel() {
        return this.model;
    }

    public static Font showDialog(Component component, String string, Font font) {
        Window window = component == null ? JOptionPane.getRootFrame() : SwingUtilities.windowForComponent(component);
        BaseDialog baseDialog = window instanceof Frame ? new BaseDialog((Frame)window, string, true) : new BaseDialog((Dialog)window, string, true);
        baseDialog.setDialogMode(0);
        baseDialog.getBanner().setVisible(false);
        JFontChooser jFontChooser = new JFontChooser();
        jFontChooser.setSelectedFont(font);
        baseDialog.getContentPane().setLayout(new BorderLayout());
        baseDialog.getContentPane().add("Center", jFontChooser);
        baseDialog.pack();
        baseDialog.setLocationRelativeTo(component);
        if (baseDialog.ask()) {
            return jFontChooser.getSelectedFont();
        }
        return null;
    }
}

