/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing;

import com.l2fprod.common.swing.plaf.JOutlookBarAddon;
import com.l2fprod.common.swing.plaf.LookAndFeelAddons;
import com.l2fprod.common.swing.plaf.OutlookBarUI;
import java.awt.Color;
import java.awt.Component;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.plaf.TabbedPaneUI;

public class JOutlookBar
extends JTabbedPane {
    public static final String UI_CLASS_ID = "OutlookBarUI";
    public static final String ANIMATED_CHANGED_KEY = "animated";
    protected Map extendedPages = new WeakHashMap();
    private boolean animated = true;

    static {
        LookAndFeelAddons.contribute(new JOutlookBarAddon());
    }

    public JOutlookBar() {
        this(2);
    }

    public JOutlookBar(int n) {
        super(n, 0);
        this.updateUI();
    }

    @Override
    public void updateUI() {
        this.setUI((OutlookBarUI)((Object)LookAndFeelAddons.getUI(this, OutlookBarUI.class)));
    }

    public void setUI(OutlookBarUI outlookBarUI) {
        super.setUI((TabbedPaneUI)((Object)outlookBarUI));
    }

    @Override
    public String getUIClassID() {
        return UI_CLASS_ID;
    }

    public void setAnimated(boolean bl) {
        if (this.animated != bl) {
            this.animated = bl;
            this.firePropertyChange(ANIMATED_CHANGED_KEY, !bl, bl);
        }
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public JScrollPane makeScrollPane(Component component) {
        return ((OutlookBarUI)((Object)this.getUI())).makeScrollPane(component);
    }

    @Override
    public void removeTabAt(int n) {
        this.checkIndex(n);
        this.removeExtendedPage(n);
        super.removeTabAt(n);
    }

    public void setAllTabsAlignment(int n) {
        for (ExtendedPage extendedPage : this.extendedPages.values()) {
            extendedPage.setTabAlignment(n);
        }
    }

    public void setAlignmentAt(int n, int n2) {
        this.getExtendedPage(n).setTabAlignment(n2);
    }

    public int getAlignmentAt(int n) {
        return this.getExtendedPage(n).getTabAlignment();
    }

    @Override
    public void setTitleAt(int n, String string) {
        super.setTitleAt(n, string);
        this.firePropertyChange("tabPropertyChangedAtIndex", null, new Integer(n));
    }

    @Override
    public void setIconAt(int n, Icon icon) {
        super.setIconAt(n, icon);
        this.firePropertyChange("tabPropertyChangedAtIndex", null, new Integer(n));
    }

    @Override
    public void setBackgroundAt(int n, Color color) {
        super.setBackgroundAt(n, color);
        this.firePropertyChange("tabPropertyChangedAtIndex", null, new Integer(n));
    }

    @Override
    public void setForegroundAt(int n, Color color) {
        super.setForegroundAt(n, color);
        this.firePropertyChange("tabPropertyChangedAtIndex", null, new Integer(n));
    }

    @Override
    public void setToolTipTextAt(int n, String string) {
        super.setToolTipTextAt(n, string);
        this.firePropertyChange("tabPropertyChangedAtIndex", null, new Integer(n));
    }

    @Override
    public void setDisplayedMnemonicIndexAt(int n, int n2) {
        super.setDisplayedMnemonicIndexAt(n, n2);
        this.firePropertyChange("tabPropertyChangedAtIndex", null, new Integer(n));
    }

    @Override
    public void setMnemonicAt(int n, int n2) {
        super.setMnemonicAt(n, n2);
        this.firePropertyChange("tabPropertyChangedAtIndex", null, new Integer(n));
    }

    @Override
    public void setDisabledIconAt(int n, Icon icon) {
        super.setDisabledIconAt(n, icon);
        this.firePropertyChange("tabPropertyChangedAtIndex", null, new Integer(n));
    }

    @Override
    public void setEnabledAt(int n, boolean bl) {
        super.setEnabledAt(n, bl);
        this.firePropertyChange("tabPropertyChangedAtIndex", null, new Integer(n));
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        if (n != -1) {
            super.addImpl(component, object, n);
        } else {
            int n2 = this.indexOfComponent(component);
            if (n2 == -1) {
                super.addImpl(component, object, n);
            } else {
                super.addImpl(component, object, n2 * 2);
            }
        }
    }

    protected void removeExtendedPage(int n) {
        Component component = this.getComponentAt(n);
        this.extendedPages.remove(component);
    }

    protected ExtendedPage getExtendedPage(int n) {
        this.checkIndex(n);
        Component component = this.getComponentAt(n);
        ExtendedPage extendedPage = (ExtendedPage)this.extendedPages.get(component);
        if (extendedPage == null) {
            extendedPage = new ExtendedPage();
            extendedPage.component = component;
            this.extendedPages.put(component, extendedPage);
        }
        return extendedPage;
    }

    private void checkIndex(int n) {
        if (n < 0 || n >= this.getTabCount()) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Tab count: " + this.getTabCount());
        }
    }

    private class ExtendedPage {
        Component component;
        int alignment = UIManager.getInt("OutlookBar.tabAlignment");

        private ExtendedPage() {
        }

        public void setTabAlignment(int n) {
            if (this.alignment != n) {
                this.alignment = n;
                JOutlookBar.this.firePropertyChange("tabPropertyChangedAtIndex", null, new Integer(this.getIndex()));
            }
        }

        public int getIndex() {
            return JOutlookBar.this.indexOfComponent(this.component);
        }

        public int getTabAlignment() {
            return this.alignment;
        }
    }
}

