/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing;

import com.l2fprod.common.swing.JCollapsiblePane;
import com.l2fprod.common.swing.plaf.JTaskPaneGroupAddon;
import com.l2fprod.common.swing.plaf.LookAndFeelAddons;
import com.l2fprod.common.swing.plaf.TaskPaneGroupUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class JTaskPaneGroup
extends JPanel
implements JCollapsiblePane.JCollapsiblePaneContainer {
    public static final String UI_CLASS_ID = "TaskPaneGroupUI";
    public static final String EXPANDED_CHANGED_KEY = "expanded";
    public static final String SCROLL_ON_EXPAND_CHANGED_KEY = "scrollOnExpand";
    public static final String TITLE_CHANGED_KEY = "title";
    public static final String ICON_CHANGED_KEY = "icon";
    public static final String SPECIAL_CHANGED_KEY = "special";
    public static final String ANIMATED_CHANGED_KEY = "animated";
    private String title;
    private Icon icon;
    private boolean special;
    private boolean expanded = true;
    private boolean scrollOnExpand;
    private JCollapsiblePane collapsePane = new JCollapsiblePane();

    static {
        LookAndFeelAddons.contribute(new JTaskPaneGroupAddon());
    }

    public JTaskPaneGroup() {
        super.setLayout(new BorderLayout(0, 0));
        super.addImpl(this.collapsePane, "Center", -1);
        this.updateUI();
        this.setFocusable(true);
        this.setOpaque(false);
        this.setAnimated(!Boolean.FALSE.equals(UIManager.get("TaskPaneGroup.animate")));
        this.collapsePane.addPropertyChangeListener("animationState", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JTaskPaneGroup.this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        });
    }

    public Container getContentPane() {
        return this.collapsePane.getContentPane();
    }

    @Override
    public void updateUI() {
        if (this.collapsePane == null) {
            return;
        }
        this.setUI((TaskPaneGroupUI)LookAndFeelAddons.getUI(this, TaskPaneGroupUI.class));
    }

    public void setUI(TaskPaneGroupUI taskPaneGroupUI) {
        super.setUI(taskPaneGroupUI);
    }

    @Override
    public String getUIClassID() {
        return UI_CLASS_ID;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        String string2 = string;
        this.title = string;
        this.firePropertyChange(TITLE_CHANGED_KEY, string2, string);
    }

    public void setText(String string) {
        this.setTitle(string);
    }

    public String getText() {
        return this.getTitle();
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        Icon icon2 = icon;
        this.icon = icon;
        this.firePropertyChange(ICON_CHANGED_KEY, icon2, icon);
    }

    public boolean isSpecial() {
        return this.special;
    }

    public void setSpecial(boolean bl) {
        if (this.special != bl) {
            this.special = bl;
            this.firePropertyChange(SPECIAL_CHANGED_KEY, !bl, bl);
        }
    }

    public void setScrollOnExpand(boolean bl) {
        if (this.scrollOnExpand != bl) {
            this.scrollOnExpand = bl;
            this.firePropertyChange(SCROLL_ON_EXPAND_CHANGED_KEY, !bl, bl);
        }
    }

    public boolean isScrollOnExpand() {
        return this.scrollOnExpand;
    }

    public void setExpanded(boolean bl) {
        if (this.expanded != bl) {
            this.expanded = bl;
            this.collapsePane.setCollapsed(!bl);
            this.firePropertyChange(EXPANDED_CHANGED_KEY, !bl, bl);
        }
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setAnimated(boolean bl) {
        if (this.isAnimated() != bl) {
            this.collapsePane.setAnimated(bl);
            this.firePropertyChange(ANIMATED_CHANGED_KEY, !this.isAnimated(), this.isAnimated());
        }
    }

    public boolean isAnimated() {
        return this.collapsePane.isAnimated();
    }

    public Component add(Action action) {
        Component component = ((TaskPaneGroupUI)this.ui).createAction(action);
        this.add(component);
        return component;
    }

    @Override
    public Container getValidatingContainer() {
        return this.getParent();
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        this.getContentPane().add(component, object, n);
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
        if (this.collapsePane != null) {
            this.getContentPane().setLayout(layoutManager);
        }
    }

    @Override
    public void remove(Component component) {
        this.getContentPane().remove(component);
    }

    @Override
    public void remove(int n) {
        this.getContentPane().remove(n);
    }

    @Override
    public void removeAll() {
        this.getContentPane().removeAll();
    }

    @Override
    protected String paramString() {
        return String.valueOf(super.paramString()) + ",title=" + this.getTitle() + ",icon=" + this.getIcon() + ",expanded=" + String.valueOf(this.isExpanded()) + ",special=" + String.valueOf(this.isSpecial()) + ",scrollOnExpand=" + String.valueOf(this.isScrollOnExpand()) + ",ui=" + this.getUI();
    }
}

