/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public class PercentLayout
implements LayoutManager2 {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private static final Constraint REMAINING_SPACE = new Constraint("*");
    private static final Constraint PREFERRED_SIZE = new Constraint("");
    private int orientation;
    private int gap;
    private Hashtable m_ComponentToConstraint;

    public PercentLayout() {
        this(0, 0);
    }

    public PercentLayout(int n, int n2) {
        this.setOrientation(n);
        this.gap = n2;
        this.m_ComponentToConstraint = new Hashtable();
    }

    public void setGap(int n) {
        this.gap = n;
    }

    public int getGap() {
        return this.gap;
    }

    public void setOrientation(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Orientation must be one of HORIZONTAL or VERTICAL");
        }
        this.orientation = n;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public Constraint getConstraint(Component component) {
        return (Constraint)this.m_ComponentToConstraint.get(component);
    }

    public void setConstraint(Component component, Object object) {
        if (object instanceof Constraint) {
            this.m_ComponentToConstraint.put(component, object);
        } else if (object instanceof Number) {
            this.setConstraint(component, new NumberConstraint(((Number)object).intValue()));
        } else if ("*".equals(object)) {
            this.setConstraint(component, REMAINING_SPACE);
        } else if ("".equals(object)) {
            this.setConstraint(component, PREFERRED_SIZE);
        } else if (object instanceof String) {
            String string = (String)object;
            if (string.endsWith("%")) {
                float f = Float.valueOf(string.substring(0, string.length() - 1)).floatValue() / 100.0f;
                if (f > 1.0f || f < 0.0f) {
                    throw new IllegalArgumentException("percent value must be >= 0 and <= 100");
                }
                this.setConstraint(component, new PercentConstraint(f));
            } else {
                this.setConstraint(component, new NumberConstraint(Integer.valueOf(string)));
            }
        } else if (object == null) {
            this.setConstraint(component, PREFERRED_SIZE);
        } else {
            throw new IllegalArgumentException("Invalid Constraint");
        }
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        this.setConstraint(component, object);
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container container) {
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.m_ComponentToConstraint.remove(component);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Component[] componentArray = container.getComponents();
        Insets insets = container.getInsets();
        int n = 0;
        int n2 = 0;
        boolean bl = true;
        int n3 = 0;
        int n4 = componentArray.length;
        while (n3 < n4) {
            if (componentArray[n3].isVisible()) {
                Dimension dimension = componentArray[n3].getPreferredSize();
                if (this.orientation == 0) {
                    n2 = Math.max(n2, dimension.height);
                    n += dimension.width;
                    if (bl) {
                        bl = false;
                    } else {
                        n += this.gap;
                    }
                } else {
                    n2 += dimension.height;
                    n = Math.max(n, dimension.width);
                    if (bl) {
                        bl = false;
                    } else {
                        n2 += this.gap;
                    }
                }
            }
            ++n3;
        }
        return new Dimension(n + insets.right + insets.left, n2 + insets.top + insets.bottom);
    }

    @Override
    public void layoutContainer(Container container) {
        int n;
        Insets insets = container.getInsets();
        Dimension dimension = container.getSize();
        dimension.width = dimension.width - insets.left - insets.right;
        dimension.height = dimension.height - insets.top - insets.bottom;
        Component[] componentArray = container.getComponents();
        int[] nArray = new int[componentArray.length];
        int n2 = n = (this.orientation == 0 ? dimension.width : dimension.height) - (componentArray.length - 1) * this.gap;
        int n3 = 0;
        int n4 = componentArray.length;
        while (n3 < n4) {
            if (componentArray[n3].isVisible()) {
                Constraint constraint = (Constraint)this.m_ComponentToConstraint.get(componentArray[n3]);
                if (constraint == null || constraint == PREFERRED_SIZE) {
                    nArray[n3] = this.orientation == 0 ? componentArray[n3].getPreferredSize().width : componentArray[n3].getPreferredSize().height;
                    n2 -= nArray[n3];
                } else if (constraint instanceof NumberConstraint) {
                    nArray[n3] = ((NumberConstraint)constraint).intValue();
                    n2 -= nArray[n3];
                }
            }
            ++n3;
        }
        n3 = n2;
        n4 = 0;
        int n5 = componentArray.length;
        while (n4 < n5) {
            Constraint constraint;
            if (componentArray[n4].isVisible() && (constraint = (Constraint)this.m_ComponentToConstraint.get(componentArray[n4])) instanceof PercentConstraint) {
                nArray[n4] = (int)((float)n3 * ((PercentConstraint)constraint).floatValue());
                n2 -= nArray[n4];
            }
            ++n4;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        n5 = 0;
        int n6 = componentArray.length;
        while (n5 < n6) {
            Constraint constraint;
            if (componentArray[n5].isVisible() && (constraint = (Constraint)this.m_ComponentToConstraint.get(componentArray[n5])) == REMAINING_SPACE) {
                arrayList.add(new Integer(n5));
                nArray[n5] = 0;
            }
            ++n5;
        }
        if (arrayList.size() > 0) {
            n5 = n2 / arrayList.size();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                nArray[((Integer)iterator.next()).intValue()] = n5;
            }
        }
        n5 = this.orientation == 0 ? insets.left : insets.top;
        int n7 = 0;
        int n8 = componentArray.length;
        while (n7 < n8) {
            if (componentArray[n7].isVisible()) {
                if (this.orientation == 0) {
                    componentArray[n7].setBounds(n5, insets.top, nArray[n7], dimension.height);
                } else {
                    componentArray[n7].setBounds(insets.left, n5, dimension.width, nArray[n7]);
                }
                n5 += this.gap + nArray[n7];
            }
            ++n7;
        }
    }

    static class Constraint {
        protected Object value;

        private Constraint(Object object) {
            this.value = object;
        }

        /* synthetic */ Constraint(Object object, Constraint constraint, Constraint constraint2) {
            this(object);
        }
    }

    static class NumberConstraint
    extends Constraint {
        public NumberConstraint(int n) {
            this(new Integer(n));
        }

        public NumberConstraint(Integer n) {
            super(n, null, null);
        }

        public int intValue() {
            return (Integer)this.value;
        }
    }

    static class PercentConstraint
    extends Constraint {
        public PercentConstraint(float f) {
            super(new Float(f), null, null);
        }

        public float floatValue() {
            return ((Float)this.value).floatValue();
        }
    }
}

