/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing;

import com.l2fprod.common.swing.PercentLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Timer;

public class PercentLayoutAnimator
implements ActionListener {
    private Timer animatorTimer;
    private List tasks = new ArrayList();
    private PercentLayout layout;
    private Container container;

    public PercentLayoutAnimator(Container container, PercentLayout percentLayout) {
        this.container = container;
        this.layout = percentLayout;
    }

    public void setTargetPercent(Component component, float f) {
        PercentLayout.Constraint constraint = this.layout.getConstraint(component);
        if (constraint instanceof PercentLayout.PercentConstraint) {
            this.setTargetPercent(component, ((PercentLayout.PercentConstraint)constraint).floatValue(), f);
        }
    }

    public void setTargetPercent(Component component, float f, float f2) {
        this.tasks.add(new PercentTask(component, f, f2));
    }

    public void start() {
        this.animatorTimer = new Timer(15, this);
        this.animatorTimer.start();
    }

    public void stop() {
        this.animatorTimer.stop();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = true;
        for (PercentTask percentTask : this.tasks) {
            if (percentTask.isCompleted()) continue;
            bl = false;
            percentTask.execute();
        }
        this.container.invalidate();
        this.container.doLayout();
        this.container.repaint();
        if (bl) {
            this.stop();
        }
    }

    class PercentTask {
        Component component;
        float targetPercent;
        float currentPercent;
        boolean completed;
        boolean incrementing;
        float delta;

        public PercentTask(Component component, float f, float f2) {
            this.component = component;
            this.currentPercent = f;
            this.targetPercent = f2;
            float f3 = f2 - f;
            this.incrementing = f3 > 0.0f;
            this.delta = f3 / 10.0f;
        }

        public void execute() {
            this.currentPercent += this.delta;
            if (this.incrementing) {
                if (this.currentPercent > this.targetPercent) {
                    this.currentPercent = this.targetPercent;
                    this.completed = true;
                }
            } else if (this.currentPercent < this.targetPercent) {
                this.currentPercent = this.targetPercent;
                this.completed = true;
            }
            PercentLayoutAnimator.this.layout.setConstraint(this.component, new PercentLayout.PercentConstraint(this.currentPercent));
        }

        public boolean isCompleted() {
            return this.completed;
        }
    }
}

