/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing;

import com.l2fprod.common.util.converter.ConverterRegistry;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JSplitPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class UserPreferences {
    private static ComponentListener windowDimension = new ComponentAdapter(){

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            this.store((Window)componentEvent.getComponent());
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            this.store((Window)componentEvent.getComponent());
        }

        private void store(Window window) {
            String string = (String)ConverterRegistry.instance().convert(String.class, window.getBounds());
            UserPreferences.node().node("Windows").put(String.valueOf(window.getName()) + ".bounds", string);
        }
    };
    private static PropertyChangeListener splitPaneListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JSplitPane jSplitPane = (JSplitPane)propertyChangeEvent.getSource();
            UserPreferences.node().node("JSplitPane").put(String.valueOf(jSplitPane.getName()) + ".dividerLocation", String.valueOf(jSplitPane.getDividerLocation()));
        }
    };

    public static JFileChooser getDefaultFileChooser() {
        return UserPreferences.getFileChooser("default");
    }

    public static JFileChooser getDefaultDirectoryChooser() {
        return UserPreferences.getDirectoryChooser("default");
    }

    public static JFileChooser getFileChooser(String string) {
        JFileChooser jFileChooser = new JFileChooser();
        UserPreferences.track(jFileChooser, "FileChooser." + string + ".path");
        return jFileChooser;
    }

    public static JFileChooser getDirectoryChooser(String string) {
        JFileChooser jFileChooser;
        try {
            Class<?> clazz = Class.forName("com.l2fprod.common.swing.JDirectoryChooser");
            jFileChooser = (JFileChooser)clazz.newInstance();
        }
        catch (Exception exception) {
            jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(1);
        }
        UserPreferences.track(jFileChooser, "DirectoryChooser." + string + ".path");
        return jFileChooser;
    }

    private static void track(JFileChooser jFileChooser, final String string) {
        Object object;
        String string2 = UserPreferences.node().get(string, null);
        if (string2 != null && ((File)(object = new File(string2))).exists()) {
            jFileChooser.setCurrentDirectory((File)object);
        }
        object = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getNewValue() instanceof File) {
                    UserPreferences.node().put(string, ((File)propertyChangeEvent.getNewValue()).getAbsolutePath());
                }
            }
        };
        jFileChooser.addPropertyChangeListener("directoryChanged", (PropertyChangeListener)object);
    }

    public static void track(Window window) {
        Preferences preferences = UserPreferences.node().node("Windows");
        String string = preferences.get(String.valueOf(window.getName()) + ".bounds", null);
        if (string != null) {
            Rectangle rectangle = (Rectangle)ConverterRegistry.instance().convert(Rectangle.class, string);
            window.setBounds(rectangle);
        }
        window.addComponentListener(windowDimension);
    }

    public static void track(JTextComponent jTextComponent) {
        new TextListener(jTextComponent);
    }

    public static void track(JSplitPane jSplitPane) {
        Preferences preferences = UserPreferences.node().node("JSplitPane");
        int n = preferences.getInt(String.valueOf(jSplitPane.getName()) + ".dividerLocation", -1);
        if (n >= 0) {
            jSplitPane.setDividerLocation(n);
        }
        jSplitPane.addPropertyChangeListener("dividerLocation", splitPaneListener);
    }

    private static Preferences node() {
        return Preferences.userNodeForPackage(UserPreferences.class).node("UserPreferences");
    }

    private static class TextListener
    implements DocumentListener {
        private JTextComponent text;

        public TextListener(JTextComponent jTextComponent) {
            this.text = jTextComponent;
            this.restore();
            jTextComponent.getDocument().addDocumentListener(this);
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.store();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.store();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.store();
        }

        void restore() {
            Preferences preferences = UserPreferences.node().node("JTextComponent");
            this.text.setText(preferences.get(this.text.getName(), ""));
        }

        void store() {
            Preferences preferences = UserPreferences.node().node("JTextComponent");
            preferences.put(this.text.getName(), this.text.getText());
        }
    }
}

