/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing.plaf;

import com.l2fprod.common.swing.plaf.ComponentAddon;
import com.l2fprod.common.swing.plaf.LookAndFeelAddons;
import com.l2fprod.common.swing.plaf.aqua.AquaLookAndFeelAddons;
import com.l2fprod.common.swing.plaf.metal.MetalLookAndFeelAddons;
import com.l2fprod.common.swing.plaf.motif.MotifLookAndFeelAddons;
import com.l2fprod.common.swing.plaf.windows.WindowsLookAndFeelAddons;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.UIManager;

public abstract class AbstractComponentAddon
implements ComponentAddon {
    private String name;

    protected AbstractComponentAddon(String string) {
        this.name = string;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public void initialize(LookAndFeelAddons lookAndFeelAddons) {
        lookAndFeelAddons.loadDefaults(this.getDefaults(lookAndFeelAddons));
    }

    @Override
    public void uninitialize(LookAndFeelAddons lookAndFeelAddons) {
        lookAndFeelAddons.unloadDefaults(this.getDefaults(lookAndFeelAddons));
    }

    protected void addBasicDefaults(LookAndFeelAddons lookAndFeelAddons, List list) {
    }

    protected void addMacDefaults(LookAndFeelAddons lookAndFeelAddons, List list) {
        this.addBasicDefaults(lookAndFeelAddons, list);
    }

    protected void addMetalDefaults(LookAndFeelAddons lookAndFeelAddons, List list) {
        this.addBasicDefaults(lookAndFeelAddons, list);
    }

    protected void addMotifDefaults(LookAndFeelAddons lookAndFeelAddons, List list) {
        this.addBasicDefaults(lookAndFeelAddons, list);
    }

    protected void addWindowsDefaults(LookAndFeelAddons lookAndFeelAddons, List list) {
        this.addBasicDefaults(lookAndFeelAddons, list);
    }

    private Object[] getDefaults(LookAndFeelAddons lookAndFeelAddons) {
        ArrayList arrayList = new ArrayList();
        if (this.isWindows(lookAndFeelAddons)) {
            this.addWindowsDefaults(lookAndFeelAddons, arrayList);
        } else if (this.isMetal(lookAndFeelAddons)) {
            this.addMetalDefaults(lookAndFeelAddons, arrayList);
        } else if (this.isMac(lookAndFeelAddons)) {
            this.addMacDefaults(lookAndFeelAddons, arrayList);
        } else if (this.isMotif(lookAndFeelAddons)) {
            this.addMotifDefaults(lookAndFeelAddons, arrayList);
        } else {
            this.addBasicDefaults(lookAndFeelAddons, arrayList);
        }
        return arrayList.toArray();
    }

    protected void addResource(List list, String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string);
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            list.add(string2);
            list.add(resourceBundle.getObject(string2));
        }
    }

    protected boolean isWindows(LookAndFeelAddons lookAndFeelAddons) {
        return lookAndFeelAddons instanceof WindowsLookAndFeelAddons;
    }

    protected boolean isMetal(LookAndFeelAddons lookAndFeelAddons) {
        return lookAndFeelAddons instanceof MetalLookAndFeelAddons;
    }

    protected boolean isMac(LookAndFeelAddons lookAndFeelAddons) {
        return lookAndFeelAddons instanceof AquaLookAndFeelAddons;
    }

    protected boolean isMotif(LookAndFeelAddons lookAndFeelAddons) {
        return lookAndFeelAddons instanceof MotifLookAndFeelAddons;
    }

    protected boolean isPlastic() {
        return UIManager.getLookAndFeel().getClass().getName().indexOf("Plastic") != -1;
    }

    protected boolean isSynth() {
        return UIManager.getLookAndFeel().getClass().getName().indexOf("ynth") != -1;
    }
}

