/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing.plaf;

import com.l2fprod.common.swing.plaf.ComponentAddon;
import com.l2fprod.common.swing.plaf.aqua.AquaLookAndFeelAddons;
import com.l2fprod.common.swing.plaf.metal.MetalLookAndFeelAddons;
import com.l2fprod.common.swing.plaf.windows.WindowsClassicLookAndFeelAddons;
import com.l2fprod.common.swing.plaf.windows.WindowsLookAndFeelAddons;
import com.l2fprod.common.util.OS;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class LookAndFeelAddons {
    private static List contributedComponents = new ArrayList();
    private static final Object APPCONTEXT_INITIALIZED = new Object();
    private static LookAndFeelAddons currentAddon;
    private static boolean trackingChanges;
    private static PropertyChangeListener changeListener;

    static {
        String string = LookAndFeelAddons.getBestMatchAddonClassName();
        try {
            string = System.getProperty("swing.addon", string);
        }
        catch (SecurityException securityException) {}
        try {
            LookAndFeelAddons.setAddon(string);
            LookAndFeelAddons.setTrackingLookAndFeelChanges(true);
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        trackingChanges = false;
    }

    public void initialize() {
        for (ComponentAddon componentAddon : contributedComponents) {
            componentAddon.initialize(this);
        }
    }

    public void uninitialize() {
        for (ComponentAddon componentAddon : contributedComponents) {
            componentAddon.uninitialize(this);
        }
    }

    public void loadDefaults(Object[] objectArray) {
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            UIManager.getLookAndFeelDefaults().put(objectArray[n], objectArray[n + 1]);
            n += 2;
        }
    }

    public void unloadDefaults(Object[] objectArray) {
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            UIManager.getLookAndFeelDefaults().put(objectArray[n], (Object)null);
            n += 2;
        }
    }

    public static void setAddon(String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        LookAndFeelAddons.setAddon(Class.forName(string));
    }

    public static void setAddon(Class clazz) throws InstantiationException, IllegalAccessException {
        LookAndFeelAddons lookAndFeelAddons = (LookAndFeelAddons)clazz.newInstance();
        LookAndFeelAddons.setAddon(lookAndFeelAddons);
    }

    public static void setAddon(LookAndFeelAddons lookAndFeelAddons) {
        if (currentAddon != null) {
            currentAddon.uninitialize();
        }
        lookAndFeelAddons.initialize();
        currentAddon = lookAndFeelAddons;
        UIManager.put(APPCONTEXT_INITIALIZED, Boolean.TRUE);
    }

    public static LookAndFeelAddons getAddon() {
        return currentAddon;
    }

    public static String getBestMatchAddonClassName() {
        String string = UIManager.getLookAndFeel().getClass().getName();
        String string2 = UIManager.getCrossPlatformLookAndFeelClassName().equals(string) ? MetalLookAndFeelAddons.class.getName() : (UIManager.getSystemLookAndFeelClassName().equals(string) ? LookAndFeelAddons.getSystemAddonClassName() : ("com.sun.java.swing.plaf.windows.WindowsLookAndFeel".equals(string) || "com.jgoodies.looks.windows.WindowsLookAndFeel".equals(string) ? (OS.isUsingWindowsVisualStyles() ? WindowsLookAndFeelAddons.class.getName() : WindowsClassicLookAndFeelAddons.class.getName()) : ("com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel".equals(string) ? WindowsClassicLookAndFeelAddons.class.getName() : (UIManager.getLookAndFeel() instanceof MetalLookAndFeel ? MetalLookAndFeelAddons.class.getName() : LookAndFeelAddons.getSystemAddonClassName()))));
        return string2;
    }

    public static String getSystemAddonClassName() {
        String string = WindowsClassicLookAndFeelAddons.class.getName();
        if (OS.isMacOSX()) {
            string = AquaLookAndFeelAddons.class.getName();
        } else if (OS.isWindows()) {
            string = OS.isUsingWindowsVisualStyles() ? WindowsLookAndFeelAddons.class.getName() : WindowsClassicLookAndFeelAddons.class.getName();
        }
        return string;
    }

    public static void contribute(ComponentAddon componentAddon) {
        contributedComponents.add(componentAddon);
        if (currentAddon != null) {
            componentAddon.initialize(currentAddon);
        }
    }

    public static void uncontribute(ComponentAddon componentAddon) {
        contributedComponents.remove(componentAddon);
        if (currentAddon != null) {
            componentAddon.uninitialize(currentAddon);
        }
    }

    public static ComponentUI getUI(JComponent jComponent, Class clazz) {
        Class<?> clazz2;
        Object object;
        LookAndFeelAddons.maybeInitialize();
        String string = (String)UIManager.get(jComponent.getUIClassID());
        try {
            object = Class.forName(string);
            UIManager.put(string, object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object = UIManager.getUI(jComponent);
        if (clazz.isInstance(object)) {
            return object;
        }
        String string2 = object.getClass().getName();
        try {
            clazz2 = clazz.getClassLoader().loadClass(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Failed to load class " + string2, classNotFoundException);
        }
        Method method = null;
        try {
            method = clazz2.getMethod("createUI", JComponent.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException("Class " + string2 + " has no method createUI(JComponent)");
        }
        try {
            return (ComponentUI)method.invoke(null, jComponent);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to invoke " + string2 + "#createUI(JComponent)");
        }
    }

    private static synchronized void maybeInitialize() {
        if (currentAddon != null) {
            UIManager.getLookAndFeelDefaults();
            if (!UIManager.getBoolean(APPCONTEXT_INITIALIZED)) {
                LookAndFeelAddons.setAddon(currentAddon);
            }
        }
    }

    public static synchronized void setTrackingLookAndFeelChanges(boolean bl) {
        if (trackingChanges != bl) {
            if (bl) {
                if (changeListener == null) {
                    changeListener = new UpdateAddon();
                }
                UIManager.addPropertyChangeListener(changeListener);
            } else {
                if (changeListener != null) {
                    UIManager.removePropertyChangeListener(changeListener);
                }
                changeListener = null;
            }
            trackingChanges = bl;
        }
    }

    public static synchronized boolean isTrackingLookAndFeelChanges() {
        return trackingChanges;
    }

    private static class UpdateAddon
    implements PropertyChangeListener {
        private UpdateAddon() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            try {
                LookAndFeelAddons.setAddon(LookAndFeelAddons.getBestMatchAddonClassName());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

