/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing.plaf.basic;

import com.l2fprod.common.swing.JButtonBar;
import com.l2fprod.common.swing.PercentLayout;
import com.l2fprod.common.swing.plaf.ButtonBarUI;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class BasicButtonBarUI
extends ButtonBarUI {
    protected JButtonBar bar;
    protected PropertyChangeListener propertyListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicButtonBarUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.bar = (JButtonBar)jComponent;
        this.installDefaults();
        this.installListeners();
        this.updateLayout();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        super.uninstallUI(jComponent);
    }

    protected void installDefaults() {
    }

    protected void uninstallDefaults() {
    }

    protected void installListeners() {
        this.propertyListener = this.createPropertyChangeListener();
        this.bar.addPropertyChangeListener(this.propertyListener);
    }

    protected void uninstallListeners() {
        this.bar.removePropertyChangeListener(this.propertyListener);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new ChangeListener();
    }

    protected void updateLayout() {
        if (this.bar.getOrientation() == 0) {
            this.bar.setLayout(new PercentLayout(0, 2));
        } else {
            this.bar.setLayout(new PercentLayout(1, 2));
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        JButtonBar jButtonBar = (JButtonBar)jComponent;
        Dimension dimension = jButtonBar.getLayout().preferredLayoutSize(jComponent);
        if (jButtonBar.getOrientation() == 0) {
            return new Dimension(dimension.width, 53);
        }
        return new Dimension(74, dimension.height);
    }

    private class ChangeListener
    implements PropertyChangeListener {
        private ChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("orientation")) {
                BasicButtonBarUI.this.updateLayout();
                BasicButtonBarUI.this.bar.revalidate();
                BasicButtonBarUI.this.bar.repaint();
            }
        }
    }
}

