/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing.plaf.basic;

import com.l2fprod.common.swing.JFontChooser;
import com.l2fprod.common.swing.LookAndFeelTweaks;
import com.l2fprod.common.swing.PercentLayout;
import com.l2fprod.common.swing.plaf.FontChooserUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.TextAttribute;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComponentUI;

public class BasicFontChooserUI
extends FontChooserUI {
    private JFontChooser chooser;
    private JPanel fontPanel;
    private JTextField fontField;
    private JList fontList;
    private JPanel fontSizePanel;
    private JTextField fontSizeField;
    private JList fontSizeList;
    private JCheckBox boldCheck;
    private JCheckBox italicCheck;
    private JTextArea previewPanel;
    private PropertyChangeListener propertyListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicFontChooserUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.chooser = (JFontChooser)jComponent;
        this.installComponents();
        this.installListeners();
    }

    protected void installComponents() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(String.valueOf(FontChooserUI.class.getName()) + "RB");
        this.fontPanel = new JPanel(new PercentLayout(1, 2));
        JLabel jLabel = new JLabel(resourceBundle.getString("FontChooserUI.fontLabel"));
        this.fontPanel.add(jLabel);
        this.fontField = new JTextField(25);
        this.fontPanel.add(this.fontField);
        this.fontField.setEditable(false);
        this.fontList = new JList();
        this.fontPanel.add((Component)new JScrollPane(this.fontList), "*");
        jLabel.setLabelFor(this.fontList);
        jLabel.setDisplayedMnemonic(resourceBundle.getString("FontChooserUI.fontLabel.mnemonic").charAt(0));
        this.fontList.setVisibleRowCount(7);
        this.fontList.setSelectionMode(0);
        String[] stringArray = this.chooser.getModel().getFontFamilies(null);
        this.fontList.setListData(stringArray);
        this.fontSizePanel = new JPanel(new PercentLayout(1, 2));
        jLabel = new JLabel(resourceBundle.getString("FontChooserUI.styleLabel"));
        this.fontSizePanel.add(jLabel);
        this.boldCheck = new JCheckBox(resourceBundle.getString("FontChooserUI.style.bold"));
        this.fontSizePanel.add(this.boldCheck);
        this.italicCheck = new JCheckBox(resourceBundle.getString("FontChooserUI.style.italic"));
        this.fontSizePanel.add(this.italicCheck);
        this.boldCheck.setMnemonic(resourceBundle.getString("FontChooserUI.style.bold.mnemonic").charAt(0));
        this.italicCheck.setMnemonic(resourceBundle.getString("FontChooserUI.style.italic.mnemonic").charAt(0));
        jLabel = new JLabel(resourceBundle.getString("FontChooserUI.sizeLabel"));
        this.fontSizePanel.add(jLabel);
        jLabel.setDisplayedMnemonic(resourceBundle.getString("FontChooserUI.sizeLabel.mnemonic").charAt(0));
        this.fontSizeField = new JTextField();
        this.fontSizePanel.add(this.fontSizeField);
        jLabel.setLabelFor(this.fontSizeField);
        this.fontSizeList = new JList();
        this.fontSizePanel.add((Component)new JScrollPane(this.fontSizeList), "*");
        int[] nArray = this.chooser.getModel().getDefaultSizes();
        String[] stringArray2 = new String[nArray.length];
        int n = 0;
        int n2 = stringArray2.length;
        while (n < n2) {
            stringArray2[n] = String.valueOf(nArray[n]);
            ++n;
        }
        this.fontSizeList.setListData(stringArray2);
        this.fontSizeList.setSelectionMode(0);
        this.fontSizeList.setVisibleRowCount(2);
        this.chooser.setLayout(LookAndFeelTweaks.createBorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(LookAndFeelTweaks.createHorizontalPercentLayout());
        jPanel.add((Component)this.fontPanel, "*");
        jPanel.add(this.fontSizePanel);
        this.chooser.add("Center", jPanel);
        this.previewPanel = new JTextArea();
        this.previewPanel.setPreferredSize(new Dimension(100, 40));
        this.previewPanel.setText(this.chooser.getModel().getPreviewMessage(null));
        JScrollPane jScrollPane = new JScrollPane(this.previewPanel);
        this.chooser.add("South", jScrollPane);
    }

    protected void installListeners() {
        SelectedFontUpdater selectedFontUpdater = new SelectedFontUpdater();
        this.fontList.addListSelectionListener(selectedFontUpdater);
        this.fontSizeList.addListSelectionListener(selectedFontUpdater);
        this.fontSizeField.getDocument().addDocumentListener(selectedFontUpdater);
        this.boldCheck.addActionListener(selectedFontUpdater);
        this.italicCheck.addActionListener(selectedFontUpdater);
        this.propertyListener = this.createPropertyChangeListener();
        this.chooser.addPropertyChangeListener("selectedFont", this.propertyListener);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.chooser.remove(this.fontPanel);
        this.chooser.remove(this.fontSizePanel);
        super.uninstallUI(jComponent);
    }

    public void uninstallListeners() {
        this.chooser.removePropertyChangeListener(this.propertyListener);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                BasicFontChooserUI.this.updateDisplay();
            }
        };
    }

    private void updateDisplay() {
        Font font = this.chooser.getSelectedFont();
        if (font != null) {
            this.previewPanel.setFont(font);
            this.fontList.setSelectedValue(font.getName(), true);
            this.fontSizeField.setText(String.valueOf(font.getSize()));
            this.fontSizeList.setSelectedValue(String.valueOf(font.getSize()), true);
            this.boldCheck.setSelected(font.isBold());
            this.italicCheck.setSelected(font.isItalic());
        }
    }

    private void updateSelectedFont() {
        Font font;
        int n;
        Font font2 = this.chooser.getSelectedFont();
        String string = font2 == null ? "SansSerif" : font2.getName();
        int n2 = n = font2 == null ? 11 : font2.getSize();
        if (this.fontList.getSelectedIndex() >= 0) {
            string = (String)this.fontList.getSelectedValue();
        }
        if (this.fontSizeField.getText().trim().length() > 0) {
            try {
                n = Integer.parseInt(this.fontSizeField.getText().trim());
            }
            catch (Exception exception) {}
        }
        HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>();
        hashMap.put(TextAttribute.SIZE, new Float(n));
        hashMap.put(TextAttribute.FAMILY, string);
        if (this.boldCheck.isSelected()) {
            hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if (this.italicCheck.isSelected()) {
            hashMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        if (!(font = Font.getFont(hashMap)).equals(font2)) {
            this.chooser.setSelectedFont(font);
            this.previewPanel.setFont(font);
        }
    }

    private class SelectedFontUpdater
    implements ListSelectionListener,
    DocumentListener,
    ActionListener {
        private SelectedFontUpdater() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (BasicFontChooserUI.this.fontList == listSelectionEvent.getSource() && BasicFontChooserUI.this.fontList.getSelectedValue() != null) {
                BasicFontChooserUI.this.fontField.setText((String)BasicFontChooserUI.this.fontList.getSelectedValue());
            }
            if (BasicFontChooserUI.this.fontSizeList == listSelectionEvent.getSource() && BasicFontChooserUI.this.fontSizeList.getSelectedValue() != null) {
                BasicFontChooserUI.this.fontSizeField.setText((String)BasicFontChooserUI.this.fontSizeList.getSelectedValue());
            }
            BasicFontChooserUI.this.updateSelectedFont();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.updateLater();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateLater();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateLater();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.updateLater();
        }

        void updateLater() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BasicFontChooserUI.this.updateSelectedFont();
                }
            });
        }
    }
}

