/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing.plaf.basic;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;

public class BasicLinkButtonUI
extends BasicButtonUI {
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();
    private static MouseListener handCursorListener = new HandCursor();
    protected int dashedRectGapX;
    protected int dashedRectGapY;
    protected int dashedRectGapWidth;
    protected int dashedRectGapHeight;
    private Color focusColor;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicLinkButtonUI();
    }

    @Override
    protected void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        abstractButton.setOpaque(false);
        abstractButton.setBorderPainted(false);
        abstractButton.setRolloverEnabled(true);
        this.dashedRectGapX = UIManager.getInt("ButtonUI.dashedRectGapX");
        this.dashedRectGapY = UIManager.getInt("ButtonUI.dashedRectGapY");
        this.dashedRectGapWidth = UIManager.getInt("ButtonUI.dashedRectGapWidth");
        this.dashedRectGapHeight = UIManager.getInt("ButtonUI.dashedRectGapHeight");
        this.focusColor = UIManager.getColor("ButtonUI.focus");
        abstractButton.setHorizontalAlignment(2);
    }

    @Override
    protected void installListeners(AbstractButton abstractButton) {
        super.installListeners(abstractButton);
        abstractButton.addMouseListener(handCursorListener);
    }

    @Override
    protected void uninstallListeners(AbstractButton abstractButton) {
        super.uninstallListeners(abstractButton);
        abstractButton.removeMouseListener(handCursorListener);
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Insets insets = jComponent.getInsets();
        BasicLinkButtonUI.viewRect.x = insets.left;
        BasicLinkButtonUI.viewRect.y = insets.top;
        BasicLinkButtonUI.viewRect.width = abstractButton.getWidth() - (insets.right + BasicLinkButtonUI.viewRect.x);
        BasicLinkButtonUI.viewRect.height = abstractButton.getHeight() - (insets.bottom + BasicLinkButtonUI.viewRect.y);
        BasicLinkButtonUI.textRect.height = 0;
        BasicLinkButtonUI.textRect.width = 0;
        BasicLinkButtonUI.textRect.y = 0;
        BasicLinkButtonUI.textRect.x = 0;
        BasicLinkButtonUI.iconRect.height = 0;
        BasicLinkButtonUI.iconRect.width = 0;
        BasicLinkButtonUI.iconRect.y = 0;
        BasicLinkButtonUI.iconRect.x = 0;
        Font font = jComponent.getFont();
        graphics.setFont(font);
        String string = SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, abstractButton.getText(), abstractButton.getIcon(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), viewRect, iconRect, textRect, abstractButton.getText() == null ? 0 : abstractButton.getIconTextGap());
        this.clearTextShiftOffset();
        if (buttonModel.isArmed() && buttonModel.isPressed()) {
            this.paintButtonPressed(graphics, abstractButton);
        }
        if (abstractButton.getIcon() != null) {
            this.paintIcon(graphics, jComponent, iconRect);
        }
        Composite composite = ((Graphics2D)graphics).getComposite();
        if (buttonModel.isRollover()) {
            ((Graphics2D)graphics).setComposite(AlphaComposite.getInstance(3, 0.5f));
        }
        if (string != null && !string.equals("")) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                BasicLinkButtonUI.textRect.x += this.getTextShiftOffset();
                BasicLinkButtonUI.textRect.y += this.getTextShiftOffset();
                view.paint(graphics, textRect);
                BasicLinkButtonUI.textRect.x -= this.getTextShiftOffset();
                BasicLinkButtonUI.textRect.y -= this.getTextShiftOffset();
            } else {
                this.paintText(graphics, abstractButton, textRect, string);
            }
        }
        if (abstractButton.isFocusPainted() && abstractButton.hasFocus()) {
            this.paintFocus(graphics, abstractButton, viewRect, textRect, iconRect);
        }
        ((Graphics2D)graphics).setComposite(composite);
    }

    @Override
    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        if (abstractButton.getParent() instanceof JToolBar) {
            return;
        }
        int n = abstractButton.getWidth();
        int n2 = abstractButton.getHeight();
        graphics.setColor(this.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(graphics, this.dashedRectGapX, this.dashedRectGapY, n - this.dashedRectGapWidth, n2 - this.dashedRectGapHeight);
    }

    @Override
    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        this.setTextShiftOffset();
    }

    static class HandCursor
    extends MouseAdapter {
        HandCursor() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            mouseEvent.getComponent().setCursor(Cursor.getDefaultCursor());
        }
    }
}

