/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing.plaf.basic;

import com.l2fprod.common.swing.JOutlookBar;
import com.l2fprod.common.swing.PercentLayout;
import com.l2fprod.common.swing.PercentLayoutAnimator;
import com.l2fprod.common.swing.plaf.OutlookBarUI;
import com.l2fprod.common.util.JVM;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.LookAndFeel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class BasicOutlookBarUI
extends BasicTabbedPaneUI
implements OutlookBarUI {
    private ContainerListener tabListener;
    private Map buttonToTab;
    private Map tabToButton;
    private Component nextVisibleComponent;
    private PercentLayoutAnimator animator;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicOutlookBarUI();
    }

    @Override
    public JScrollPane makeScrollPane(Component component) {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        if (component instanceof Scrollable) {
            jScrollPane.getViewport().setView(component);
        } else {
            jScrollPane.getViewport().setView(new ScrollableJPanel(component));
        }
        jScrollPane.setOpaque(false);
        jScrollPane.getViewport().setOpaque(false);
        return jScrollPane;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        TabLayout tabLayout = new TabLayout();
        this.tabPane.setLayout(tabLayout);
        tabLayout.setLayoutConstraints(this.tabPane);
        this.updateTabLayoutOrientation();
        this.buttonToTab = new HashMap();
        this.tabToButton = new HashMap();
        LookAndFeel.installBorder(this.tabPane, "OutlookBar.border");
        LookAndFeel.installColors(this.tabPane, "OutlookBar.background", "OutlookBar.foreground");
        this.tabPane.setOpaque(true);
        Component[] componentArray = this.tabPane.getComponents();
        int n = 0;
        int n2 = componentArray.length;
        while (n < n2) {
            this.tabAdded(componentArray[n]);
            ++n;
        }
    }

    @Override
    protected void uninstallDefaults() {
        ArrayList arrayList = new ArrayList(this.buttonToTab.values());
        for (Component component : arrayList) {
            this.tabRemoved(component);
        }
        super.uninstallDefaults();
    }

    @Override
    protected void installListeners() {
        this.tabListener = this.createTabListener();
        this.tabPane.addContainerListener(this.tabListener);
        super.installListeners();
    }

    protected ContainerListener createTabListener() {
        return new ContainerTabHandler();
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.tabPane.removeContainerListener(this.tabListener);
    }

    @Override
    public Rectangle getTabBounds(JTabbedPane jTabbedPane, int n) {
        Component component = jTabbedPane.getComponentAt(n);
        return component.getBounds();
    }

    @Override
    public int getTabRunCount(JTabbedPane jTabbedPane) {
        return 0;
    }

    @Override
    public int tabForCoordinate(JTabbedPane jTabbedPane, int n, int n2) {
        int n3 = -1;
        int n4 = 0;
        int n5 = jTabbedPane.getTabCount();
        while (n4 < n5) {
            if (jTabbedPane.getComponentAt(n4).contains(n, n2)) {
                n3 = n4;
                break;
            }
            ++n4;
        }
        return n3;
    }

    protected int indexOfComponent(Component component) {
        int n = -1;
        Component[] componentArray = this.tabPane.getComponents();
        int n2 = 0;
        while (n2 < componentArray.length) {
            if (componentArray[n2] == component) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    protected TabButton createTabButton() {
        TabButton tabButton = new TabButton();
        tabButton.setOpaque(true);
        return tabButton;
    }

    protected void tabAdded(final Component component) {
        TabButton tabButton = (TabButton)this.tabToButton.get(component);
        if (tabButton == null) {
            tabButton = this.createTabButton();
            this.buttonToTab.put(tabButton, component);
            this.tabToButton.put(component, tabButton);
            tabButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Component component3 = BasicOutlookBarUI.this.getVisibleComponent();
                    Component component2 = component;
                    if (((JOutlookBar)BasicOutlookBarUI.this.tabPane).isAnimated() && component3 != component2 && component3 != null && component2 != null) {
                        if (BasicOutlookBarUI.this.animator != null) {
                            BasicOutlookBarUI.this.animator.stop();
                        }
                        BasicOutlookBarUI.this.animator = new PercentLayoutAnimator(BasicOutlookBarUI.this.tabPane, (PercentLayout)BasicOutlookBarUI.this.tabPane.getLayout()){

                            @Override
                            public void stop() {
                                super.stop();
                                BasicOutlookBarUI.this.tabPane.setSelectedComponent(component);
                                BasicOutlookBarUI.this.nextVisibleComponent = null;
                            }
                        };
                        BasicOutlookBarUI.this.nextVisibleComponent = component;
                        BasicOutlookBarUI.this.animator.setTargetPercent(component3, 1.0f, 0.0f);
                        BasicOutlookBarUI.this.animator.setTargetPercent(component, 0.0f, 1.0f);
                        BasicOutlookBarUI.this.animator.start();
                    } else {
                        BasicOutlookBarUI.this.nextVisibleComponent = null;
                        BasicOutlookBarUI.this.tabPane.setSelectedComponent(component);
                    }
                }
            });
        } else {
            this.tabPane.remove(tabButton);
        }
        this.updateTabButtonAt(this.tabPane.indexOfComponent(component));
        int n = this.indexOfComponent(component);
        this.tabPane.add((Component)tabButton, n);
        if (JVM.current().isOneDotFive()) {
            this.assureRectsCreated(this.tabPane.getTabCount());
        }
    }

    protected void tabRemoved(Component component) {
        TabButton tabButton = (TabButton)this.tabToButton.get(component);
        this.tabPane.remove(tabButton);
        this.buttonToTab.remove(tabButton);
        this.tabToButton.remove(component);
    }

    protected void updateTabButtonAt(int n) {
        TabButton tabButton = this.buttonForTab(n);
        tabButton.setText(this.tabPane.getTitleAt(n));
        tabButton.setIcon(this.tabPane.getIconAt(n));
        tabButton.setDisabledIcon(this.tabPane.getDisabledIconAt(n));
        tabButton.setToolTipText(this.tabPane.getToolTipTextAt(n));
        tabButton.setDisplayedMnemonicIndex(this.tabPane.getDisplayedMnemonicIndexAt(n));
        tabButton.setMnemonic(this.tabPane.getMnemonicAt(n));
        tabButton.setEnabled(this.tabPane.isEnabledAt(n));
        tabButton.setHorizontalAlignment(((JOutlookBar)this.tabPane).getAlignmentAt(n));
    }

    protected TabButton buttonForTab(int n) {
        Component component = this.tabPane.getComponentAt(n);
        return (TabButton)this.tabToButton.get(component);
    }

    protected void updateTabLayoutOrientation() {
        TabLayout tabLayout = (TabLayout)this.tabPane.getLayout();
        int n = this.tabPane.getTabPlacement();
        if (n == 1 || n == 3) {
            tabLayout.setOrientation(0);
        } else {
            tabLayout.setOrientation(1);
        }
    }

    protected boolean requestFocusForVisibleComponent0() {
        Component component = this.getVisibleComponent();
        if (component.isFocusTraversable()) {
            component.requestFocus();
            return true;
        }
        return component instanceof JComponent && ((JComponent)component).requestDefaultFocus();
    }

    @Override
    protected MouseListener createMouseListener() {
        return new MouseAdapter(){};
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
    }

    @Override
    protected void paintContentBorder(Graphics graphics, int n, int n2) {
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
    }

    @Override
    protected void paintContentBorderLeftEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
    }

    @Override
    protected void paintFocusIndicator(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
    }

    @Override
    protected void paintIcon(Graphics graphics, int n, int n2, Icon icon, Rectangle rectangle, boolean bl) {
    }

    @Override
    protected void paintTab(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2) {
    }

    @Override
    protected void paintTabArea(Graphics graphics, int n, int n2) {
    }

    @Override
    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
    }

    @Override
    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
    }

    @Override
    protected void paintText(Graphics graphics, int n, Font font, FontMetrics fontMetrics, int n2, String string, Rectangle rectangle, boolean bl) {
    }

    class ContainerTabHandler
    extends ContainerAdapter {
        ContainerTabHandler() {
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            if (!(containerEvent.getChild() instanceof UIResource)) {
                Component component = containerEvent.getChild();
                BasicOutlookBarUI.this.tabAdded(component);
            }
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            if (!(containerEvent.getChild() instanceof UIResource)) {
                Component component = containerEvent.getChild();
                BasicOutlookBarUI.this.tabRemoved(component);
            }
        }
    }

    class PropertyChangeHandler
    implements PropertyChangeListener {
        PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("tabPropertyChangedAtIndex".equals(string)) {
                int n = (Integer)propertyChangeEvent.getNewValue();
                BasicOutlookBarUI.this.updateTabButtonAt(n);
            } else if ("tabPlacement".equals(string)) {
                BasicOutlookBarUI.this.updateTabLayoutOrientation();
            }
        }
    }

    private static class ScrollableJPanel
    extends JPanel
    implements Scrollable {
        public ScrollableJPanel(Component component) {
            this.setLayout(new BorderLayout(0, 0));
            this.add("Center", component);
            this.setOpaque(false);
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            return 16;
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return super.getPreferredSize();
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return 16;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }

    protected static class TabButton
    extends JButton
    implements UIResource {
        public TabButton() {
        }

        public TabButton(ButtonUI buttonUI) {
            this.setUI(buttonUI);
        }
    }

    protected class TabLayout
    extends PercentLayout {
        protected TabLayout() {
        }

        @Override
        public void addLayoutComponent(Component component, Object object) {
            if (object == null) {
                if (component instanceof TabButton) {
                    super.addLayoutComponent(component, "");
                } else {
                    super.addLayoutComponent(component, "100%");
                }
            } else {
                super.addLayoutComponent(component, object);
            }
        }

        public void setLayoutConstraints(Container container) {
            Component[] componentArray = container.getComponents();
            int n = 0;
            int n2 = componentArray.length;
            while (n < n2) {
                if (!(componentArray[n] instanceof TabButton)) {
                    super.addLayoutComponent(componentArray[n], "100%");
                }
                ++n;
            }
        }

        @Override
        public void layoutContainer(Container container) {
            int n = BasicOutlookBarUI.this.tabPane.getSelectedIndex();
            Component component = BasicOutlookBarUI.this.getVisibleComponent();
            if (n < 0) {
                if (component != null) {
                    BasicOutlookBarUI.this.setVisibleComponent(null);
                }
            } else {
                Component component2 = BasicOutlookBarUI.this.tabPane.getComponentAt(n);
                boolean bl = false;
                if (component2 != null) {
                    if (component2 != component && component != null && SwingUtilities.findFocusOwner(component) != null) {
                        bl = true;
                    }
                    BasicOutlookBarUI.this.setVisibleComponent(component2);
                    Component[] componentArray = container.getComponents();
                    int n2 = 0;
                    while (n2 < componentArray.length) {
                        if (!(componentArray[n2] instanceof UIResource) && componentArray[n2].isVisible() && componentArray[n2] != component2) {
                            componentArray[n2].setVisible(false);
                        }
                        ++n2;
                    }
                    if (BasicOutlookBarUI.this.nextVisibleComponent != null) {
                        BasicOutlookBarUI.this.nextVisibleComponent.setVisible(true);
                    }
                }
                super.layoutContainer(container);
                if (bl && !BasicOutlookBarUI.this.requestFocusForVisibleComponent0()) {
                    BasicOutlookBarUI.this.tabPane.requestFocus();
                }
            }
        }
    }
}

