/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing.plaf.basic;

import com.l2fprod.common.swing.border.ButtonBorder;
import com.l2fprod.common.swing.border.FourLineBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;

public class BasicOutlookButtonUI
extends BasicButtonUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicOutlookButtonUI();
    }

    @Override
    protected void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        abstractButton.setRolloverEnabled(true);
        abstractButton.setOpaque(false);
        abstractButton.setHorizontalTextPosition(0);
        abstractButton.setVerticalTextPosition(3);
        LookAndFeel.installBorder(abstractButton, "OutlookButton.border");
    }

    @Override
    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        this.setTextShiftOffset();
    }

    public static class OutlookButtonBorder
    extends ButtonBorder {
        FourLineBorder rolloverBorder;
        FourLineBorder pressedBorder;

        public OutlookButtonBorder(Color color, Color color2) {
            this.rolloverBorder = new FourLineBorder(color, color, color2, color2);
            this.pressedBorder = new FourLineBorder(color2, color2, color, color);
        }

        @Override
        protected void paintRollover(AbstractButton abstractButton, Graphics graphics, int n, int n2, int n3, int n4) {
            this.rolloverBorder.paintBorder(abstractButton, graphics, n, n2, n3, n4);
        }

        @Override
        protected void paintPressed(AbstractButton abstractButton, Graphics graphics, int n, int n2, int n3, int n4) {
            this.pressedBorder.paintBorder(abstractButton, graphics, n, n2, n3, n4);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return this.rolloverBorder.getBorderInsets(component);
        }
    }
}

