/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing.plaf.basic;

import com.l2fprod.common.swing.JCollapsiblePane;
import com.l2fprod.common.swing.JLinkButton;
import com.l2fprod.common.swing.JTaskPaneGroup;
import com.l2fprod.common.swing.icons.EmptyIcon;
import com.l2fprod.common.swing.plaf.TaskPaneGroupUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class BasicTaskPaneGroupUI
extends TaskPaneGroupUI {
    private static FocusListener focusListener = new RepaintOnFocus();
    protected static int TITLE_HEIGHT = 25;
    protected static int ROUND_HEIGHT = 5;
    protected JTaskPaneGroup group;
    protected boolean mouseOver;
    protected MouseInputListener mouseListener;
    protected PropertyChangeListener propertyListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTaskPaneGroupUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.group = (JTaskPaneGroup)jComponent;
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        this.group.setOpaque(true);
        this.group.setBorder(this.createPaneBorder());
        ((JComponent)this.group.getContentPane()).setBorder(this.createContentPaneBorder());
        LookAndFeel.installColorsAndFont(this.group, "TaskPaneGroup.background", "TaskPaneGroup.foreground", "TaskPaneGroup.font");
        LookAndFeel.installColorsAndFont((JComponent)this.group.getContentPane(), "TaskPaneGroup.background", "TaskPaneGroup.foreground", "TaskPaneGroup.font");
    }

    protected void installListeners() {
        this.mouseListener = this.createMouseInputListener();
        this.group.addMouseMotionListener(this.mouseListener);
        this.group.addMouseListener(this.mouseListener);
        this.group.addFocusListener(focusListener);
        this.propertyListener = this.createPropertyListener();
        this.group.addPropertyChangeListener(this.propertyListener);
    }

    protected void installKeyboardActions() {
        ActionMap actionMap;
        InputMap inputMap = (InputMap)UIManager.get("TaskPaneGroup.focusInputMap");
        if (inputMap != null) {
            SwingUtilities.replaceUIInputMap(this.group, 0, inputMap);
        }
        if ((actionMap = this.getActionMap()) != null) {
            SwingUtilities.replaceUIActionMap(this.group, actionMap);
        }
    }

    ActionMap getActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("toggleExpanded", new ToggleExpandedAction());
        return actionMapUIResource;
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners();
        super.uninstallUI(jComponent);
    }

    protected void uninstallListeners() {
        this.group.removeMouseListener(this.mouseListener);
        this.group.removeMouseMotionListener(this.mouseListener);
        this.group.removeFocusListener(focusListener);
        this.group.removePropertyChangeListener(this.propertyListener);
    }

    protected MouseInputListener createMouseInputListener() {
        return new ToggleListener();
    }

    protected PropertyChangeListener createPropertyListener() {
        return new ChangeListener();
    }

    protected boolean isInBorder(MouseEvent mouseEvent) {
        return mouseEvent.getY() < this.getTitleHeight();
    }

    protected final int getTitleHeight() {
        return TITLE_HEIGHT;
    }

    protected Border createPaneBorder() {
        return new PaneBorder();
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Component component = this.group.getComponent(0);
        if (!(component instanceof JCollapsiblePane)) {
            return super.getPreferredSize(jComponent);
        }
        JCollapsiblePane jCollapsiblePane = (JCollapsiblePane)component;
        Dimension dimension = jCollapsiblePane.getPreferredSize();
        Border border = this.group.getBorder();
        if (border instanceof PaneBorder) {
            Dimension dimension2 = ((PaneBorder)border).getPreferredSize(this.group);
            dimension.width = Math.max(dimension.width, dimension2.width);
            dimension.height += dimension2.height;
        } else {
            dimension.height += this.getTitleHeight();
        }
        return dimension;
    }

    protected Border createContentPaneBorder() {
        Color color = UIManager.getColor("TaskPaneGroup.borderColor");
        return new CompoundBorder(new ContentPaneBorder(color), BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    @Override
    public Component createAction(Action action) {
        JLinkButton jLinkButton = new JLinkButton(action);
        jLinkButton.setOpaque(false);
        jLinkButton.setBorder(null);
        jLinkButton.setBorderPainted(false);
        jLinkButton.setFocusPainted(true);
        jLinkButton.setForeground(UIManager.getColor("TaskPaneGroup.titleForeground"));
        return jLinkButton;
    }

    protected void ensureVisible() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BasicTaskPaneGroupUI.this.group.scrollRectToVisible(new Rectangle(BasicTaskPaneGroupUI.this.group.getWidth(), BasicTaskPaneGroupUI.this.group.getHeight()));
            }
        });
    }

    class ChangeListener
    implements PropertyChangeListener {
        ChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (("expanded".equals(propertyChangeEvent.getPropertyName()) && Boolean.TRUE.equals(propertyChangeEvent.getNewValue()) && !BasicTaskPaneGroupUI.this.group.isAnimated() || "animationState".equals(propertyChangeEvent.getPropertyName()) && "expanded".equals(propertyChangeEvent.getNewValue())) && BasicTaskPaneGroupUI.this.group.isScrollOnExpand()) {
                BasicTaskPaneGroupUI.this.ensureVisible();
            }
        }
    }

    protected static class ChevronIcon
    implements Icon {
        boolean up = true;

        public ChevronIcon(boolean bl) {
            this.up = bl;
        }

        @Override
        public int getIconHeight() {
            return 3;
        }

        @Override
        public int getIconWidth() {
            return 6;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.up) {
                graphics.drawLine(n + 3, n2, n, n2 + 3);
                graphics.drawLine(n + 3, n2, n + 6, n2 + 3);
            } else {
                graphics.drawLine(n, n2, n + 3, n2 + 3);
                graphics.drawLine(n + 3, n2 + 3, n + 6, n2);
            }
        }
    }

    protected static class ContentPaneBorder
    implements Border {
        Color color;

        public ContentPaneBorder(Color color) {
            this.color = color;
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(0, 1, 1, 1);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(this.color);
            graphics.drawLine(n, n2, n, n2 + n4 - 1);
            graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
            graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
        }
    }

    protected class PaneBorder
    implements Border {
        protected Color borderColor = UIManager.getColor("TaskPaneGroup.borderColor");
        protected Color titleForeground = UIManager.getColor("TaskPaneGroup.titleForeground");
        protected Color specialTitleBackground = UIManager.getColor("TaskPaneGroup.specialTitleBackground");
        protected Color specialTitleForeground = UIManager.getColor("TaskPaneGroup.specialTitleForeground");
        protected Color titleBackgroundGradientStart = UIManager.getColor("TaskPaneGroup.titleBackgroundGradientStart");
        protected Color titleBackgroundGradientEnd = UIManager.getColor("TaskPaneGroup.titleBackgroundGradientEnd");
        protected Color titleOver = UIManager.getColor("TaskPaneGroup.titleOver");
        protected Color specialTitleOver;
        protected JLabel label;

        public PaneBorder() {
            if (this.titleOver == null) {
                this.titleOver = this.specialTitleBackground.brighter();
            }
            this.specialTitleOver = UIManager.getColor("TaskPaneGroup.specialTitleOver");
            if (this.specialTitleOver == null) {
                this.specialTitleOver = this.specialTitleBackground.brighter();
            }
            this.label = new JLabel();
            this.label.setOpaque(false);
            this.label.setIconTextGap(8);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(BasicTaskPaneGroupUI.this.getTitleHeight(), 0, 0, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        public Dimension getPreferredSize(JTaskPaneGroup jTaskPaneGroup) {
            this.configureLabel(jTaskPaneGroup);
            Dimension dimension = this.label.getPreferredSize();
            dimension.width += 3;
            dimension.width += TITLE_HEIGHT;
            dimension.width += 3;
            dimension.height = BasicTaskPaneGroupUI.this.getTitleHeight();
            return dimension;
        }

        protected void paintTitleBackground(JTaskPaneGroup jTaskPaneGroup, Graphics graphics) {
            if (jTaskPaneGroup.isSpecial()) {
                graphics.setColor(this.specialTitleBackground);
            } else {
                graphics.setColor(this.titleBackgroundGradientStart);
            }
            graphics.fillRect(0, 0, jTaskPaneGroup.getWidth(), BasicTaskPaneGroupUI.this.getTitleHeight() - 1);
        }

        protected void paintTitle(JTaskPaneGroup jTaskPaneGroup, Graphics graphics, Color color, int n, int n2, int n3, int n4) {
            this.configureLabel(jTaskPaneGroup);
            this.label.setForeground(color);
            graphics.translate(n, n2);
            this.label.setBounds(0, 0, n3, n4);
            this.label.paint(graphics);
            graphics.translate(-n, -n2);
        }

        protected void configureLabel(JTaskPaneGroup jTaskPaneGroup) {
            this.label.applyComponentOrientation(jTaskPaneGroup.getComponentOrientation());
            this.label.setFont(jTaskPaneGroup.getFont());
            this.label.setText(jTaskPaneGroup.getTitle());
            this.label.setIcon(jTaskPaneGroup.getIcon() == null ? new EmptyIcon() : jTaskPaneGroup.getIcon());
        }

        protected void paintExpandedControls(JTaskPaneGroup jTaskPaneGroup, Graphics graphics, int n, int n2, int n3, int n4) {
        }

        protected Color getPaintColor(JTaskPaneGroup jTaskPaneGroup) {
            Color color = this.isMouseOverBorder() ? (BasicTaskPaneGroupUI.this.mouseOver ? (jTaskPaneGroup.isSpecial() ? this.specialTitleOver : this.titleOver) : (jTaskPaneGroup.isSpecial() ? this.specialTitleForeground : this.titleForeground)) : (jTaskPaneGroup.isSpecial() ? this.specialTitleForeground : this.titleForeground);
            return color;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JTaskPaneGroup jTaskPaneGroup = (JTaskPaneGroup)component;
            int n5 = TITLE_HEIGHT - 2 * ROUND_HEIGHT;
            int n6 = jTaskPaneGroup.getWidth() - TITLE_HEIGHT;
            int n7 = ROUND_HEIGHT - 1;
            int n8 = 3;
            int n9 = 0;
            int n10 = jTaskPaneGroup.getWidth() - BasicTaskPaneGroupUI.this.getTitleHeight() - 3;
            int n11 = BasicTaskPaneGroupUI.this.getTitleHeight();
            if (!jTaskPaneGroup.getComponentOrientation().isLeftToRight()) {
                n6 = jTaskPaneGroup.getWidth() - n6 - n5;
                n8 = jTaskPaneGroup.getWidth() - n8 - n10;
            }
            this.paintTitleBackground(jTaskPaneGroup, graphics);
            this.paintExpandedControls(jTaskPaneGroup, graphics, n6, n7, n5, n5);
            Color color = this.getPaintColor(jTaskPaneGroup);
            if (jTaskPaneGroup.hasFocus()) {
                graphics.setColor(color);
                BasicGraphicsUtils.drawDashedRect(graphics, 3, 3, n3 - 6, BasicTaskPaneGroupUI.this.getTitleHeight() - 6);
            }
            this.paintTitle(jTaskPaneGroup, graphics, color, n8, n9, n10, n11);
        }

        protected void paintRectAroundControls(JTaskPaneGroup jTaskPaneGroup, Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2) {
            if (BasicTaskPaneGroupUI.this.mouseOver) {
                int n5 = n + n3;
                int n6 = n2 + n4;
                graphics.setColor(color);
                graphics.drawLine(n, n2, n5, n2);
                graphics.drawLine(n, n2, n, n6);
                graphics.setColor(color2);
                graphics.drawLine(n5, n2, n5, n6);
                graphics.drawLine(n, n6, n5, n6);
            }
        }

        protected void paintOvalAroundControls(JTaskPaneGroup jTaskPaneGroup, Graphics graphics, int n, int n2, int n3, int n4) {
            if (jTaskPaneGroup.isSpecial()) {
                graphics.setColor(this.specialTitleBackground.brighter());
                graphics.drawOval(n, n2, n3, n4);
            } else {
                graphics.setColor(this.titleBackgroundGradientStart);
                graphics.fillOval(n, n2, n3, n4);
                graphics.setColor(this.titleBackgroundGradientEnd.darker());
                graphics.drawOval(n, n2, n3, n3);
            }
        }

        protected void paintChevronControls(JTaskPaneGroup jTaskPaneGroup, Graphics graphics, int n, int n2, int n3, int n4) {
            ChevronIcon chevronIcon = jTaskPaneGroup.isExpanded() ? new ChevronIcon(true) : new ChevronIcon(false);
            int n5 = n + n3 / 2 - chevronIcon.getIconWidth() / 2;
            int n6 = n2 + (n4 / 2 - chevronIcon.getIconHeight());
            chevronIcon.paintIcon(jTaskPaneGroup, graphics, n5, n6);
            chevronIcon.paintIcon(jTaskPaneGroup, graphics, n5, n6 + chevronIcon.getIconHeight() + 1);
        }

        protected boolean isMouseOverBorder() {
            return false;
        }
    }

    static class RepaintOnFocus
    implements FocusListener {
        RepaintOnFocus() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            focusEvent.getComponent().repaint();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            focusEvent.getComponent().repaint();
        }
    }

    class ToggleExpandedAction
    extends AbstractAction {
        public ToggleExpandedAction() {
            super("toggleExpanded");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicTaskPaneGroupUI.this.group.setExpanded(!BasicTaskPaneGroupUI.this.group.isExpanded());
        }

        @Override
        public boolean isEnabled() {
            return BasicTaskPaneGroupUI.this.group.isVisible();
        }
    }

    class ToggleListener
    extends MouseInputAdapter {
        ToggleListener() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (BasicTaskPaneGroupUI.this.isInBorder(mouseEvent)) {
                mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
            } else {
                BasicTaskPaneGroupUI.this.mouseOver = false;
                BasicTaskPaneGroupUI.this.group.repaint();
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            mouseEvent.getComponent().setCursor(Cursor.getDefaultCursor());
            BasicTaskPaneGroupUI.this.mouseOver = false;
            BasicTaskPaneGroupUI.this.group.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (BasicTaskPaneGroupUI.this.isInBorder(mouseEvent)) {
                mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                BasicTaskPaneGroupUI.this.mouseOver = true;
                BasicTaskPaneGroupUI.this.group.repaint();
            } else {
                mouseEvent.getComponent().setCursor(Cursor.getDefaultCursor());
                BasicTaskPaneGroupUI.this.mouseOver = false;
                BasicTaskPaneGroupUI.this.group.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (BasicTaskPaneGroupUI.this.isInBorder(mouseEvent)) {
                BasicTaskPaneGroupUI.this.group.setExpanded(!BasicTaskPaneGroupUI.this.group.isExpanded());
            }
        }
    }
}

