/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing.plaf.basic;

import com.l2fprod.common.swing.JTaskPane;
import com.l2fprod.common.swing.PercentLayout;
import com.l2fprod.common.swing.plaf.TaskPaneUI;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;

public class BasicTaskPaneUI
extends TaskPaneUI {
    protected JTaskPane taskPane;
    protected boolean useGradient;
    protected Color gradientStart;
    protected Color gradientEnd;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTaskPaneUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.taskPane = (JTaskPane)jComponent;
        this.taskPane.setLayout(new PercentLayout(1, 14));
        this.taskPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.taskPane.setOpaque(true);
        if (this.taskPane.getBackground() == null || this.taskPane.getBackground() instanceof ColorUIResource) {
            this.taskPane.setBackground(UIManager.getColor("TaskPane.background"));
        }
        this.useGradient = UIManager.getBoolean("TaskPane.useGradient");
        if (this.useGradient) {
            this.gradientStart = UIManager.getColor("TaskPane.backgroundGradientStart");
            this.gradientEnd = UIManager.getColor("TaskPane.backgroundGradientEnd");
        }
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.useGradient) {
            Paint paint = graphics2D.getPaint();
            GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, this.gradientStart, 0.0f, jComponent.getHeight(), this.gradientEnd);
            graphics2D.setPaint(gradientPaint);
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
            graphics2D.setPaint(paint);
        }
    }
}

