/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing.plaf.misc;

import com.l2fprod.common.swing.JTaskPaneGroup;
import com.l2fprod.common.swing.plaf.basic.BasicTaskPaneGroupUI;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;

public class GlossyTaskPaneGroupUI
extends BasicTaskPaneGroupUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new GlossyTaskPaneGroupUI();
    }

    @Override
    protected Border createPaneBorder() {
        return new GlossyPaneBorder();
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            graphics.setColor(jComponent.getParent().getBackground());
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
            graphics.setColor(jComponent.getBackground());
            graphics.fillRect(0, ROUND_HEIGHT, jComponent.getWidth(), jComponent.getHeight() - ROUND_HEIGHT);
        }
        this.paint(graphics, jComponent);
    }

    class GlossyPaneBorder
    extends BasicTaskPaneGroupUI.PaneBorder {
        GlossyPaneBorder() {
        }

        @Override
        protected void paintTitleBackground(JTaskPaneGroup jTaskPaneGroup, Graphics graphics) {
            Object object;
            if (jTaskPaneGroup.isSpecial()) {
                graphics.setColor(this.specialTitleBackground);
                graphics.fillRoundRect(0, 0, jTaskPaneGroup.getWidth(), ROUND_HEIGHT * 2, ROUND_HEIGHT, ROUND_HEIGHT);
                graphics.fillRect(0, ROUND_HEIGHT, jTaskPaneGroup.getWidth(), TITLE_HEIGHT - ROUND_HEIGHT);
            } else {
                object = ((Graphics2D)graphics).getPaint();
                GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, this.titleBackgroundGradientStart, 0.0f, TITLE_HEIGHT, this.titleBackgroundGradientEnd);
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                ((Graphics2D)graphics).setPaint(gradientPaint);
                graphics.fillRoundRect(0, 0, jTaskPaneGroup.getWidth(), ROUND_HEIGHT * 2, ROUND_HEIGHT, ROUND_HEIGHT);
                graphics.fillRect(0, ROUND_HEIGHT, jTaskPaneGroup.getWidth(), TITLE_HEIGHT - ROUND_HEIGHT);
                ((Graphics2D)graphics).setPaint((Paint)object);
            }
            object = graphics.getClipBounds();
            graphics.setClip(0, 0, jTaskPaneGroup.getWidth(), TITLE_HEIGHT);
            graphics.setColor(this.borderColor);
            graphics.drawRoundRect(0, 0, jTaskPaneGroup.getWidth() - 1, TITLE_HEIGHT + ROUND_HEIGHT, ROUND_HEIGHT, ROUND_HEIGHT);
            graphics.drawLine(0, TITLE_HEIGHT - 1, jTaskPaneGroup.getWidth(), TITLE_HEIGHT - 1);
            graphics.setClip((Shape)object);
        }

        @Override
        protected void paintExpandedControls(JTaskPaneGroup jTaskPaneGroup, Graphics graphics, int n, int n2, int n3, int n4) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.paintOvalAroundControls(jTaskPaneGroup, graphics, n, n2, n3, n4);
            graphics.setColor(this.getPaintColor(jTaskPaneGroup));
            this.paintChevronControls(jTaskPaneGroup, graphics, n, n2, n3, n4);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }

        @Override
        protected boolean isMouseOverBorder() {
            return true;
        }
    }
}

