/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing.plaf.misc;

import com.l2fprod.common.swing.plaf.ButtonBarButtonUI;
import com.l2fprod.common.swing.plaf.basic.BasicButtonBarUI;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class IconPackagerButtonBarUI
extends BasicButtonBarUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new IconPackagerButtonBarUI();
    }

    @Override
    protected void installDefaults() {
        Border border = this.bar.getBorder();
        if (border == null || border instanceof UIResource) {
            this.bar.setBorder(new BorderUIResource(new CompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2))));
        }
        if (this.bar.getBackground() == null || this.bar.getBackground() instanceof UIResource) {
            this.bar.setBackground(new ColorUIResource(128, 128, 128));
            this.bar.setOpaque(true);
        }
    }

    @Override
    public void installButtonBarUI(AbstractButton abstractButton) {
        abstractButton.setUI(new ButtonUI());
        abstractButton.setHorizontalTextPosition(0);
        abstractButton.setVerticalTextPosition(3);
    }

    static class ButtonUI
    extends BasicButtonUI
    implements ButtonBarButtonUI {
        private static Color selectedBackground = Color.white;
        private static Color selectedBorder = Color.black;
        private static Color selectedForeground = Color.black;
        private static Color unselectedForeground = Color.white;

        ButtonUI() {
        }

        @Override
        public void installUI(JComponent jComponent) {
            super.installUI(jComponent);
            AbstractButton abstractButton = (AbstractButton)jComponent;
            abstractButton.setOpaque(false);
            abstractButton.setRolloverEnabled(true);
            abstractButton.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        }

        @Override
        public void paint(Graphics graphics, JComponent jComponent) {
            Object object;
            AbstractButton abstractButton = (AbstractButton)jComponent;
            if (abstractButton.getModel().isSelected()) {
                object = graphics.getColor();
                graphics.setColor(selectedBackground);
                graphics.fillRoundRect(0, 0, jComponent.getWidth() - 1, jComponent.getHeight() - 1, 5, 5);
                graphics.setColor(selectedBorder);
                graphics.drawRoundRect(0, 0, jComponent.getWidth() - 1, jComponent.getHeight() - 1, 5, 5);
                graphics.setColor((Color)object);
            }
            if (jComponent.getClientProperty("html") != null) {
                object = abstractButton.getModel();
                if (object.isEnabled()) {
                    if (object.isSelected()) {
                        abstractButton.setForeground(selectedForeground);
                    } else {
                        abstractButton.setForeground(unselectedForeground);
                    }
                } else {
                    abstractButton.setForeground(unselectedForeground.darker());
                }
            }
            super.paint(graphics, jComponent);
        }

        @Override
        protected void paintText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string) {
            ButtonModel buttonModel = abstractButton.getModel();
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = abstractButton.getDisplayedMnemonicIndex();
            Color color = graphics.getColor();
            if (buttonModel.isEnabled()) {
                if (buttonModel.isSelected()) {
                    graphics.setColor(selectedForeground);
                } else {
                    graphics.setColor(unselectedForeground);
                }
            } else {
                graphics.setColor(unselectedForeground.darker());
            }
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n, rectangle.x + this.getTextShiftOffset(), rectangle.y + fontMetrics.getAscent() + this.getTextShiftOffset());
            graphics.setColor(color);
        }
    }
}

