/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing.plaf.windows;

import com.l2fprod.common.swing.JDirectoryChooser;
import com.l2fprod.common.swing.LookAndFeelTweaks;
import com.l2fprod.common.swing.plaf.DirectoryChooserUI;
import com.l2fprod.common.swing.tree.LazyMutableTreeNode;
import com.l2fprod.common.util.OS;
import com.l2fprod.common.util.ResourceManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class WindowsDirectoryChooserUI
extends BasicFileChooserUI
implements DirectoryChooserUI {
    private static Queue nodeQueue;
    private JDirectoryChooser chooser;
    private JTextComponent message;
    private JTree tree;
    private JScrollPane treeScroll;
    private JButton approveButton;
    private JButton cancelButton;
    private JPanel buttonPanel;
    private BasicFileChooserUI.BasicFileView fileView = new WindowsFileView();
    private Action approveSelectionAction = new ApproveSelectionAction();
    private boolean useNodeQueue;

    public WindowsDirectoryChooserUI(JDirectoryChooser jDirectoryChooser) {
        super(jDirectoryChooser);
    }

    @Override
    public void rescanCurrentDirectory(JFileChooser jFileChooser) {
        super.rescanCurrentDirectory(jFileChooser);
        this.findFile(this.chooser.getSelectedFile() == null ? this.chooser.getCurrentDirectory() : this.chooser.getSelectedFile(), true, true);
    }

    @Override
    public void ensureFileIsVisible(JFileChooser jFileChooser, File file) {
        super.ensureFileIsVisible(jFileChooser, file);
        this.findFile(file, false, false);
    }

    protected String getToolTipText(MouseEvent mouseEvent) {
        TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath != null && treePath.getLastPathComponent() instanceof FileTreeNode) {
            FileTreeNode fileTreeNode = (FileTreeNode)treePath.getLastPathComponent();
            String string = this.getFileView(this.chooser).getTypeDescription(fileTreeNode.getFile());
            if (string == null || string.length() == 0) {
                return fileTreeNode.toString();
            }
            return String.valueOf(fileTreeNode.toString()) + " - " + string;
        }
        return null;
    }

    @Override
    public void installComponents(JFileChooser jFileChooser) {
        this.chooser = (JDirectoryChooser)jFileChooser;
        jFileChooser.setLayout(LookAndFeelTweaks.createBorderLayout());
        jFileChooser.setFileSelectionMode(1);
        JComponent jComponent = jFileChooser.getAccessory();
        if (jComponent != null) {
            jFileChooser.add("North", jFileChooser.getAccessory());
        }
        this.tree = new JTree(){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                String string = WindowsDirectoryChooserUI.this.getToolTipText(mouseEvent);
                if (string == null) {
                    return super.getToolTipText(mouseEvent);
                }
                return string;
            }
        };
        this.tree.addTreeExpansionListener(new TreeExpansion());
        this.tree.setModel(new FileSystemTreeModel(jFileChooser.getFileSystemView()));
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(false);
        this.tree.setCellRenderer(new FileSystemTreeRenderer());
        this.tree.setToolTipText("");
        this.treeScroll = new JScrollPane(this.tree);
        jFileChooser.add("Center", this.treeScroll);
        this.treeScroll.setPreferredSize(new Dimension(300, 300));
        this.approveButton = new JButton();
        this.approveButton.setAction(this.getApproveSelectionAction());
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        this.buttonPanel = new JPanel(LookAndFeelTweaks.createButtonAreaLayout());
        this.buttonPanel.add(this.approveButton);
        this.buttonPanel.add(this.cancelButton);
        jFileChooser.add("South", this.buttonPanel);
        this.updateView(jFileChooser);
    }

    @Override
    protected void installStrings(JFileChooser jFileChooser) {
        super.installStrings(jFileChooser);
        this.saveButtonToolTipText = ResourceManager.get(DirectoryChooserUI.class).getString("DirectoryChooser.saveButtonToolTipText");
        this.openButtonToolTipText = ResourceManager.get(DirectoryChooserUI.class).getString("DirectoryChooser.openButtonToolTipText");
        this.cancelButtonToolTipText = ResourceManager.get(DirectoryChooserUI.class).getString("DirectoryChooser.cancelButtonToolTipText");
    }

    @Override
    public void uninstallComponents(JFileChooser jFileChooser) {
        jFileChooser.remove(this.message);
        jFileChooser.remove(this.treeScroll);
        jFileChooser.remove(this.buttonPanel);
    }

    @Override
    public FileView getFileView(JFileChooser jFileChooser) {
        return this.fileView;
    }

    @Override
    protected void installListeners(JFileChooser jFileChooser) {
        super.installListeners(jFileChooser);
        this.tree.addTreeSelectionListener(new SelectionListener());
    }

    @Override
    protected void uninstallListeners(JFileChooser jFileChooser) {
        super.uninstallListeners(jFileChooser);
    }

    @Override
    public PropertyChangeListener createPropertyChangeListener(JFileChooser jFileChooser) {
        return new ChangeListener();
    }

    private void updateView(JFileChooser jFileChooser) {
        if (jFileChooser.getApproveButtonText() != null) {
            this.approveButton.setText(jFileChooser.getApproveButtonText());
            this.approveButton.setMnemonic(jFileChooser.getApproveButtonMnemonic());
        } else if (jFileChooser.getDialogType() == 0) {
            this.approveButton.setText(this.openButtonText);
            this.approveButton.setToolTipText(this.openButtonToolTipText);
            this.approveButton.setMnemonic(this.openButtonMnemonic);
        } else {
            this.approveButton.setText(this.saveButtonText);
            this.approveButton.setToolTipText(this.saveButtonToolTipText);
            this.approveButton.setMnemonic(this.saveButtonMnemonic);
        }
        this.cancelButton.setText(this.cancelButtonText);
        this.cancelButton.setMnemonic(this.cancelButtonMnemonic);
        this.buttonPanel.setVisible(jFileChooser.getControlButtonsAreShown());
    }

    private void findFile(File file, boolean bl, boolean bl2) {
        if (file == null || !file.isDirectory()) {
            return;
        }
        File file2 = null;
        try {
            file2 = file.getCanonicalFile();
        }
        catch (Exception exception) {
            return;
        }
        this.useNodeQueue = false;
        try {
            ArrayList<File> arrayList = new ArrayList<File>();
            arrayList.add(file2);
            while ((file2 = this.chooser.getFileSystemView().getParentDirectory(file2)) != null) {
                arrayList.add(0, file2);
            }
            ArrayList<DefaultMutableTreeNode> arrayList2 = new ArrayList<DefaultMutableTreeNode>();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
            arrayList2.add(defaultMutableTreeNode);
            boolean bl3 = true;
            block6: while (arrayList.size() > 0 && bl3) {
                bl3 = false;
                int n = 0;
                int n2 = defaultMutableTreeNode.getChildCount();
                while (n < n2) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
                    File file3 = ((FileTreeNode)defaultMutableTreeNode2).getFile();
                    if (arrayList.get(0).equals(file3)) {
                        arrayList2.add(defaultMutableTreeNode2);
                        arrayList.remove(0);
                        defaultMutableTreeNode = defaultMutableTreeNode2;
                        bl3 = true;
                        continue block6;
                    }
                    ++n;
                }
            }
            TreePath treePath = new TreePath(arrayList2.toArray());
            if (treePath.getLastPathComponent() instanceof FileTreeNode && bl2) {
                ((FileTreeNode)treePath.getLastPathComponent()).clear();
            }
            if (bl) {
                this.tree.expandPath(treePath);
                this.tree.setSelectionPath(treePath);
            }
            this.tree.scrollPathToVisible(treePath);
        }
        finally {
            this.useNodeQueue = true;
        }
    }

    @Override
    public Action getApproveSelectionAction() {
        return this.approveSelectionAction;
    }

    private void setSelectedFiles() {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            this.chooser.setSelectedFile(null);
            return;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        int n = 0;
        int n2 = treePathArray.length;
        while (n < n2) {
            File file = ((FileTreeNode)treePathArray[n].getLastPathComponent()).getFile();
            arrayList.add(file);
            ++n;
        }
        this.chooser.setSelectedFiles(arrayList.toArray(new File[0]));
    }

    private static synchronized void addToQueue(FileTreeNode fileTreeNode, JTree jTree) {
        if (nodeQueue == null || !nodeQueue.isAlive()) {
            nodeQueue = new Queue();
            nodeQueue.start();
        }
        if (fileTreeNode.canEnqueue()) {
            nodeQueue.add(fileTreeNode, jTree);
        }
    }

    private class ApproveSelectionAction
    extends AbstractAction {
        public ApproveSelectionAction() {
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            WindowsDirectoryChooserUI.this.setSelectedFiles();
            WindowsDirectoryChooserUI.this.chooser.approveSelection();
        }
    }

    private class ChangeListener
    implements PropertyChangeListener {
        private ChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("ApproveButtonTextChangedProperty".equals(propertyChangeEvent.getPropertyName())) {
                WindowsDirectoryChooserUI.this.updateView(WindowsDirectoryChooserUI.this.chooser);
            }
            if ("MultiSelectionEnabledChangedProperty".equals(propertyChangeEvent.getPropertyName())) {
                if (WindowsDirectoryChooserUI.this.chooser.isMultiSelectionEnabled()) {
                    WindowsDirectoryChooserUI.this.tree.getSelectionModel().setSelectionMode(4);
                } else {
                    WindowsDirectoryChooserUI.this.tree.getSelectionModel().setSelectionMode(1);
                }
            }
            if ("directoryChanged".equals(propertyChangeEvent.getPropertyName())) {
                WindowsDirectoryChooserUI.this.findFile(WindowsDirectoryChooserUI.this.chooser.getCurrentDirectory(), false, false);
            }
            if ("AccessoryChangedProperty".equals(propertyChangeEvent.getPropertyName())) {
                Component component = (Component)propertyChangeEvent.getOldValue();
                Component component2 = (Component)propertyChangeEvent.getNewValue();
                if (component != null) {
                    WindowsDirectoryChooserUI.this.chooser.remove(component);
                }
                if (component2 != null) {
                    WindowsDirectoryChooserUI.this.chooser.add("North", component2);
                }
                WindowsDirectoryChooserUI.this.chooser.revalidate();
                WindowsDirectoryChooserUI.this.chooser.repaint();
            }
            if ("ControlButtonsAreShownChangedProperty".equals(propertyChangeEvent.getPropertyName())) {
                WindowsDirectoryChooserUI.this.updateView(WindowsDirectoryChooserUI.this.chooser);
            }
        }
    }

    private class FileSystemTreeModel
    extends DefaultTreeModel {
        public FileSystemTreeModel(FileSystemView fileSystemView) {
            super(new MyComputerTreeNode(fileSystemView), false);
        }
    }

    private class FileSystemTreeRenderer
    extends DefaultTreeCellRenderer {
        private FileSystemTreeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, false, n, bl4);
            if (object instanceof FileTreeNode) {
                FileTreeNode fileTreeNode = (FileTreeNode)object;
                this.setText(WindowsDirectoryChooserUI.this.getFileView(WindowsDirectoryChooserUI.this.chooser).getName(fileTreeNode.getFile()));
                if (!OS.isMacOSX() || !UIManager.getLookAndFeel().isNativeLookAndFeel()) {
                    this.setIcon(WindowsDirectoryChooserUI.this.getFileView(WindowsDirectoryChooserUI.this.chooser).getIcon(fileTreeNode.getFile()));
                }
            }
            return this;
        }
    }

    private class FileTreeNode
    extends LazyMutableTreeNode
    implements Comparable {
        public FileTreeNode(File file) {
            super(file);
        }

        public boolean canEnqueue() {
            return !this.isLoaded() && !WindowsDirectoryChooserUI.this.chooser.getFileSystemView().isFloppyDrive(this.getFile()) && !WindowsDirectoryChooserUI.this.chooser.getFileSystemView().isFileSystemRoot(this.getFile());
        }

        @Override
        public boolean isLeaf() {
            if (!this.isLoaded()) {
                return false;
            }
            return super.isLeaf();
        }

        @Override
        protected void loadChildren() {
            FileTreeNode[] fileTreeNodeArray = this.getChildren();
            int n = 0;
            int n2 = fileTreeNodeArray.length;
            while (n < n2) {
                this.add(fileTreeNodeArray[n]);
                ++n;
            }
        }

        private FileTreeNode[] getChildren() {
            File[] fileArray = WindowsDirectoryChooserUI.this.chooser.getFileSystemView().getFiles(this.getFile(), WindowsDirectoryChooserUI.this.chooser.isFileHidingEnabled());
            ArrayList<FileTreeNode> arrayList = new ArrayList<FileTreeNode>();
            if (fileArray != null) {
                int n = 0;
                int n2 = fileArray.length;
                while (n < n2) {
                    if (fileArray[n].isDirectory()) {
                        arrayList.add(new FileTreeNode(fileArray[n]));
                    }
                    ++n;
                }
            }
            Object[] objectArray = arrayList.toArray(new FileTreeNode[0]);
            Arrays.sort(objectArray);
            return objectArray;
        }

        public File getFile() {
            return (File)this.getUserObject();
        }

        @Override
        public String toString() {
            return WindowsDirectoryChooserUI.this.chooser.getFileSystemView().getSystemDisplayName((File)this.getUserObject());
        }

        public int compareTo(Object object) {
            if (!(object instanceof FileTreeNode)) {
                return 1;
            }
            return this.getFile().compareTo(((FileTreeNode)object).getFile());
        }

        @Override
        public void clear() {
            super.clear();
            ((DefaultTreeModel)WindowsDirectoryChooserUI.this.tree.getModel()).nodeStructureChanged(this);
        }
    }

    private class MyComputerTreeNode
    extends LazyMutableTreeNode {
        public MyComputerTreeNode(FileSystemView fileSystemView) {
            super(fileSystemView);
        }

        @Override
        protected void loadChildren() {
            FileSystemView fileSystemView = (FileSystemView)this.getUserObject();
            Object[] objectArray = fileSystemView.getRoots();
            if (objectArray != null) {
                Arrays.sort(objectArray);
                int n = 0;
                int n2 = objectArray.length;
                while (n < n2) {
                    this.add(new FileTreeNode((File)objectArray[n]));
                    ++n;
                }
            }
        }

        @Override
        public String toString() {
            return "/";
        }
    }

    private static final class Queue
    extends Thread {
        private volatile Stack nodes = new Stack();
        private Object lock = new Object();
        private volatile boolean running = true;

        public Queue() {
            super("DirectoryChooser-BackgroundLoader");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(FileTreeNode fileTreeNode, JTree jTree) {
            if (!this.isAlive()) {
                throw new IllegalArgumentException("Queue is no longer alive");
            }
            Object object = this.lock;
            synchronized (object) {
                if (this.running) {
                    this.nodes.addElement(new QueueItem(fileTreeNode, jTree));
                    this.lock.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            ** GOTO lbl31
            {
                var1_1 = (QueueItem)this.nodes.pop();
                var2_3 = var1_1.node;
                var3_4 = var1_1.tree;
                var2_3.getChildCount();
                var4_5 = new Runnable(){

                    @Override
                    public void run() {
                        ((DefaultTreeModel)var3_4.getModel()).nodeChanged(var2_3);
                        var3_4.repaint();
                    }
                };
                try {
                    SwingUtilities.invokeAndWait(var4_5);
                }
                catch (InterruptedException var5_7) {
                    var5_7.printStackTrace();
                }
                catch (InvocationTargetException var5_8) {
                    var5_8.printStackTrace();
                }
                do {
                    if (this.nodes.size() > 0) continue block8;
                    try {
                        var1_1 = this.lock;
                        synchronized (var1_1) {
                            this.lock.wait(5000L);
                        }
                        if (this.nodes.size() != 0) continue;
                        this.running = false;
                    }
                    catch (InterruptedException var1_2) {
                        var1_2.printStackTrace();
                    }
lbl31:
                    // 4 sources

                } while (this.running);
            }
        }
    }

    private static final class QueueItem {
        FileTreeNode node;
        JTree tree;

        public QueueItem(FileTreeNode fileTreeNode, JTree jTree) {
            this.node = fileTreeNode;
            this.tree = jTree;
        }
    }

    private class SelectionListener
    implements TreeSelectionListener {
        private SelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            WindowsDirectoryChooserUI.this.getApproveSelectionAction().setEnabled(WindowsDirectoryChooserUI.this.tree.getSelectionCount() > 0);
            WindowsDirectoryChooserUI.this.setSelectedFiles();
        }
    }

    private class TreeExpansion
    implements TreeExpansionListener {
        private TreeExpansion() {
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            Object object;
            if (treeExpansionEvent.getPath() != null && (object = treeExpansionEvent.getPath().getLastPathComponent()) instanceof FileTreeNode && WindowsDirectoryChooserUI.this.useNodeQueue && ((FileTreeNode)object).isLoaded()) {
                Enumeration<TreeNode> enumeration = ((FileTreeNode)object).children();
                while (enumeration.hasMoreElements()) {
                    WindowsDirectoryChooserUI.addToQueue((FileTreeNode)enumeration.nextElement(), WindowsDirectoryChooserUI.this.tree);
                }
            }
        }
    }

    protected class WindowsFileView
    extends BasicFileChooserUI.BasicFileView {
        protected WindowsFileView() {
            super(WindowsDirectoryChooserUI.this);
        }

        @Override
        public Icon getIcon(File file) {
            Icon icon = this.getCachedIcon(file);
            if (icon != null) {
                return icon;
            }
            if (file != null) {
                icon = WindowsDirectoryChooserUI.this.getFileChooser().getFileSystemView().getSystemIcon(file);
            }
            if (icon == null) {
                icon = super.getIcon(file);
            }
            this.cacheIcon(file, icon);
            return icon;
        }
    }
}

