/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing.plaf.windows;

import com.l2fprod.common.swing.JFontChooser;
import com.l2fprod.common.swing.LookAndFeelTweaks;
import com.l2fprod.common.swing.PercentLayout;
import com.l2fprod.common.swing.plaf.FontChooserUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.TextAttribute;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComponentUI;

public class WindowsFontChooserUI
extends FontChooserUI {
    private JFontChooser chooser;
    private JPanel fontPanel;
    private JTextField fontField;
    private JList fontList;
    private JTextField fontEffectField;
    private JList fontEffectList;
    private JPanel fontSizePanel;
    private JTextField fontSizeField;
    private JList fontSizeList;
    private JTextArea previewPanel;
    private JComboBox charSetCombo;
    private PropertyChangeListener propertyListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsFontChooserUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.chooser = (JFontChooser)jComponent;
        this.installComponents();
        this.installListeners();
    }

    protected void installComponents() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(String.valueOf(FontChooserUI.class.getName()) + "RB");
        this.fontPanel = new JPanel(new PercentLayout(1, 2));
        JLabel jLabel = new JLabel(resourceBundle.getString("FontChooserUI.fontLabel"));
        this.fontPanel.add(jLabel);
        this.fontField = new JTextField(25);
        this.fontPanel.add(this.fontField);
        this.fontField.setEditable(false);
        this.fontList = new JList();
        this.fontPanel.add((Component)new JScrollPane(this.fontList), "*");
        jLabel.setLabelFor(this.fontList);
        jLabel.setDisplayedMnemonic(resourceBundle.getString("FontChooserUI.fontLabel.mnemonic").charAt(0));
        this.fontList.setSelectionMode(0);
        String[] stringArray = this.chooser.getModel().getFontFamilies(null);
        this.fontList.setListData(stringArray);
        JPanel jPanel = new JPanel(new PercentLayout(1, 2));
        jLabel = new JLabel(resourceBundle.getString("FontChooserUI.styleLabel"));
        jPanel.add(jLabel);
        this.fontEffectField = new JTextField(10);
        jPanel.add(this.fontEffectField);
        this.fontEffectField.setEditable(false);
        this.fontEffectList = new JList();
        jPanel.add((Component)new JScrollPane(this.fontEffectList), "*");
        jLabel.setLabelFor(this.fontEffectList);
        jLabel.setDisplayedMnemonic(resourceBundle.getString("FontChooserUI.styleLabel.mnemonic").charAt(0));
        this.fontEffectList.setSelectionMode(0);
        FontStyle[] fontStyleArray = new FontStyle[]{new FontStyle(0, resourceBundle.getString("FontChooserUI.style.plain")), new FontStyle(1, resourceBundle.getString("FontChooserUI.style.bold")), new FontStyle(2, resourceBundle.getString("FontChooserUI.style.italic")), new FontStyle(3, resourceBundle.getString("FontChooserUI.style.bolditalic"))};
        this.fontEffectList.setListData(fontStyleArray);
        this.fontSizePanel = new JPanel(new PercentLayout(1, 2));
        jLabel = new JLabel(resourceBundle.getString("FontChooserUI.sizeLabel"));
        this.fontSizePanel.add(jLabel);
        jLabel.setDisplayedMnemonic(resourceBundle.getString("FontChooserUI.sizeLabel.mnemonic").charAt(0));
        this.fontSizeField = new JTextField(5);
        this.fontSizePanel.add(this.fontSizeField);
        jLabel.setLabelFor(this.fontSizeField);
        this.fontSizeList = new JList();
        this.fontSizePanel.add((Component)new JScrollPane(this.fontSizeList), "*");
        int[] nArray = this.chooser.getModel().getDefaultSizes();
        String[] stringArray2 = new String[nArray.length];
        int n = 0;
        int n2 = stringArray2.length;
        while (n < n2) {
            stringArray2[n] = String.valueOf(nArray[n]);
            ++n;
        }
        this.fontSizeList.setPrototypeCellValue("012345");
        this.fontSizeList.setListData(stringArray2);
        this.fontSizeList.setSelectionMode(0);
        this.fontSizeList.setVisibleRowCount(2);
        this.chooser.setLayout(LookAndFeelTweaks.createBorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(LookAndFeelTweaks.createHorizontalPercentLayout());
        jPanel2.add((Component)this.fontPanel, "*");
        jPanel2.add(jPanel);
        jPanel2.add(this.fontSizePanel);
        this.previewPanel = new JTextArea();
        this.previewPanel.setText(this.chooser.getModel().getPreviewMessage(null));
        JScrollPane jScrollPane = new JScrollPane(this.previewPanel);
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setBorder(null);
        jSplitPane.setTopComponent(jPanel2);
        jSplitPane.setBottomComponent(jScrollPane);
        jSplitPane.setDividerLocation(0.5);
        jSplitPane.setOneTouchExpandable(true);
        this.chooser.add("Center", jSplitPane);
        jPanel2.setMinimumSize(new Dimension(0, 0));
        JPanel jPanel3 = new JPanel(new PercentLayout(0, 2));
        jLabel = new JLabel("CHARSET");
        jLabel.setHorizontalAlignment(4);
        jPanel3.add((Component)jLabel, "*");
        this.charSetCombo = new JComboBox<String>(this.chooser.getModel().getCharSets());
        jPanel3.add(this.charSetCombo);
    }

    protected void installListeners() {
        SelectedFontUpdater selectedFontUpdater = new SelectedFontUpdater();
        this.fontList.addListSelectionListener(selectedFontUpdater);
        this.fontEffectList.addListSelectionListener(selectedFontUpdater);
        this.fontSizeList.addListSelectionListener(selectedFontUpdater);
        this.fontSizeField.getDocument().addDocumentListener(selectedFontUpdater);
        this.propertyListener = this.createPropertyChangeListener();
        this.chooser.addPropertyChangeListener("selectedFont", this.propertyListener);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.chooser.remove(this.fontPanel);
        this.chooser.remove(this.fontSizePanel);
        super.uninstallUI(jComponent);
    }

    public void uninstallListeners() {
        this.chooser.removePropertyChangeListener(this.propertyListener);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WindowsFontChooserUI.this.updateDisplay();
            }
        };
    }

    private void updateDisplay() {
        Font font = this.chooser.getSelectedFont();
        if (font != null) {
            this.previewPanel.setFont(font);
            this.fontList.setSelectedValue(font.getName(), true);
            this.fontSizeField.setText(String.valueOf(font.getSize()));
            this.fontSizeList.setSelectedValue(String.valueOf(font.getSize()), true);
            FontStyle fontStyle = new FontStyle(font.getStyle(), null);
            this.fontEffectList.setSelectedValue(fontStyle, true);
            fontStyle = (FontStyle)this.fontEffectList.getSelectedValue();
            this.fontEffectField.setText(fontStyle.toString());
        }
    }

    private void updateSelectedFont() {
        Font font;
        int n;
        Font font2 = this.chooser.getSelectedFont();
        String string = font2 == null ? "SansSerif" : font2.getName();
        int n2 = n = font2 == null ? 11 : font2.getSize();
        if (this.fontList.getSelectedIndex() >= 0) {
            string = (String)this.fontList.getSelectedValue();
        }
        if (this.fontSizeField.getText().trim().length() > 0) {
            try {
                n = Integer.parseInt(this.fontSizeField.getText().trim());
            }
            catch (Exception exception) {}
        }
        HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>();
        hashMap.put(TextAttribute.SIZE, new Float(n));
        hashMap.put(TextAttribute.FAMILY, string);
        FontStyle fontStyle = (FontStyle)this.fontEffectList.getSelectedValue();
        if (fontStyle != null) {
            if (fontStyle.isBold()) {
                hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            }
            if (fontStyle.isItalic()) {
                hashMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            }
        }
        if (!(font = Font.getFont(hashMap)).equals(font2)) {
            this.chooser.setSelectedFont(font);
            this.previewPanel.setFont(font);
        }
    }

    private static class FontStyle {
        String display;
        int value;

        public FontStyle(int n, String string) {
            this.value = n;
            this.display = string;
        }

        public int value() {
            return this.value;
        }

        public String toString() {
            return this.display;
        }

        public boolean isBold() {
            return (this.value & 1) != 0;
        }

        public boolean isItalic() {
            return (this.value & 2) != 0;
        }

        public int hashCode() {
            return this.value;
        }

        public boolean equals(Object object) {
            return object instanceof FontStyle && ((FontStyle)object).value == this.value;
        }
    }

    private class SelectedFontUpdater
    implements ListSelectionListener,
    DocumentListener,
    ActionListener {
        private SelectedFontUpdater() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (WindowsFontChooserUI.this.fontList == listSelectionEvent.getSource() && WindowsFontChooserUI.this.fontList.getSelectedValue() != null) {
                WindowsFontChooserUI.this.fontField.setText((String)WindowsFontChooserUI.this.fontList.getSelectedValue());
            }
            if (WindowsFontChooserUI.this.fontSizeList == listSelectionEvent.getSource() && WindowsFontChooserUI.this.fontSizeList.getSelectedValue() != null) {
                WindowsFontChooserUI.this.fontSizeField.setText((String)WindowsFontChooserUI.this.fontSizeList.getSelectedValue());
            }
            WindowsFontChooserUI.this.updateSelectedFont();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.updateLater();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateLater();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateLater();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.updateLater();
        }

        void updateLater() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WindowsFontChooserUI.this.updateSelectedFont();
                }
            });
        }
    }
}

