/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing.plaf.windows;

import com.l2fprod.common.swing.border.ButtonBorder;
import com.l2fprod.common.swing.border.FourLineBorder;
import com.l2fprod.common.swing.plaf.basic.BasicOutlookBarUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class WindowsOutlookBarUI
extends BasicOutlookBarUI {
    private Border tabButtonBorder;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsOutlookBarUI();
    }

    @Override
    public JScrollPane makeScrollPane(Component component) {
        JScrollPane jScrollPane = super.makeScrollPane(component);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.getVerticalScrollBar().setUI(new ThinScrollBarUI());
        return jScrollPane;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.tabButtonBorder = UIManager.getBorder("OutlookBar.tabButtonBorder");
    }

    @Override
    protected BasicOutlookBarUI.TabButton createTabButton() {
        BasicOutlookBarUI.TabButton tabButton = new BasicOutlookBarUI.TabButton();
        tabButton.setUI(new BasicButtonUI());
        tabButton.setBorder(this.tabButtonBorder);
        return tabButton;
    }

    public static class ThinScrollBarUI
    extends BasicScrollBarUI {
        @Override
        public Dimension getPreferredSize(JComponent jComponent) {
            return this.scrollbar.getOrientation() == 1 ? new Dimension(8, 48) : new Dimension(48, 8);
        }
    }

    public static class WindowsTabButtonBorder
    extends ButtonBorder {
        FourLineBorder normalBorder;
        FourLineBorder pressedBorder;

        public WindowsTabButtonBorder(Color color, Color color2) {
            this.normalBorder = new FourLineBorder(color, color, color2, color2);
            this.pressedBorder = new FourLineBorder(color2, color2, color, color);
        }

        @Override
        protected void paintNormal(AbstractButton abstractButton, Graphics graphics, int n, int n2, int n3, int n4) {
            this.normalBorder.paintBorder(abstractButton, graphics, n, n2, n3, n4);
        }

        @Override
        protected void paintDisabled(AbstractButton abstractButton, Graphics graphics, int n, int n2, int n3, int n4) {
            this.normalBorder.paintBorder(abstractButton, graphics, n, n2, n3, n4);
        }

        @Override
        protected void paintRollover(AbstractButton abstractButton, Graphics graphics, int n, int n2, int n3, int n4) {
            this.normalBorder.paintBorder(abstractButton, graphics, n, n2, n3, n4);
        }

        @Override
        protected void paintPressed(AbstractButton abstractButton, Graphics graphics, int n, int n2, int n3, int n4) {
            this.pressedBorder.paintBorder(abstractButton, graphics, n, n2, n3, n4);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return this.normalBorder.getBorderInsets(component);
        }
    }
}

