/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing.plaf.windows;

import com.l2fprod.common.swing.JTaskPaneGroup;
import com.l2fprod.common.swing.plaf.basic.BasicTaskPaneGroupUI;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;

public class WindowsTaskPaneGroupUI
extends BasicTaskPaneGroupUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsTaskPaneGroupUI();
    }

    @Override
    protected Border createPaneBorder() {
        return new XPPaneBorder();
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            graphics.setColor(jComponent.getParent().getBackground());
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
            graphics.setColor(jComponent.getBackground());
            graphics.fillRect(0, ROUND_HEIGHT, jComponent.getWidth(), jComponent.getHeight() - ROUND_HEIGHT);
        }
        this.paint(graphics, jComponent);
    }

    class XPPaneBorder
    extends BasicTaskPaneGroupUI.PaneBorder {
        XPPaneBorder() {
        }

        @Override
        protected void paintTitleBackground(JTaskPaneGroup jTaskPaneGroup, Graphics graphics) {
            if (jTaskPaneGroup.isSpecial()) {
                graphics.setColor(this.specialTitleBackground);
                graphics.fillRoundRect(0, 0, jTaskPaneGroup.getWidth(), ROUND_HEIGHT * 2, ROUND_HEIGHT, ROUND_HEIGHT);
                graphics.fillRect(0, ROUND_HEIGHT, jTaskPaneGroup.getWidth(), TITLE_HEIGHT - ROUND_HEIGHT);
            } else {
                Paint paint = ((Graphics2D)graphics).getPaint();
                GradientPaint gradientPaint = new GradientPaint(0.0f, jTaskPaneGroup.getWidth() / 2, jTaskPaneGroup.getComponentOrientation().isLeftToRight() ? this.titleBackgroundGradientStart : this.titleBackgroundGradientEnd, jTaskPaneGroup.getWidth(), TITLE_HEIGHT, jTaskPaneGroup.getComponentOrientation().isLeftToRight() ? this.titleBackgroundGradientEnd : this.titleBackgroundGradientStart);
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                ((Graphics2D)graphics).setPaint(gradientPaint);
                graphics.fillRoundRect(0, 0, jTaskPaneGroup.getWidth(), ROUND_HEIGHT * 2, ROUND_HEIGHT, ROUND_HEIGHT);
                graphics.fillRect(0, ROUND_HEIGHT, jTaskPaneGroup.getWidth(), TITLE_HEIGHT - ROUND_HEIGHT);
                ((Graphics2D)graphics).setPaint(paint);
            }
        }

        @Override
        protected void paintExpandedControls(JTaskPaneGroup jTaskPaneGroup, Graphics graphics, int n, int n2, int n3, int n4) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.paintOvalAroundControls(jTaskPaneGroup, graphics, n, n2, n3, n4);
            graphics.setColor(this.getPaintColor(jTaskPaneGroup));
            this.paintChevronControls(jTaskPaneGroup, graphics, n, n2, n3, n4);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }

        @Override
        protected boolean isMouseOverBorder() {
            return true;
        }
    }
}

