/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing.renderer;

import com.l2fprod.common.swing.renderer.DefaultCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.UIManager;

public class ColorCellRenderer
extends DefaultCellRenderer {
    public static String toHex(Color color) {
        String string = Integer.toHexString(color.getRed());
        String string2 = Integer.toHexString(color.getGreen());
        String string3 = Integer.toHexString(color.getBlue());
        if (string.length() == 1) {
            string = "0" + string;
        }
        if (string2.length() == 1) {
            string2 = "0" + string2;
        }
        if (string3.length() == 1) {
            string3 = "0" + string3;
        }
        return ("#" + string + string2 + string3).toUpperCase();
    }

    @Override
    protected String convertToString(Object object) {
        if (object == null) {
            return null;
        }
        Color color = (Color)object;
        return "R:" + color.getRed() + " G:" + color.getGreen() + " B:" + color.getBlue() + " - " + ColorCellRenderer.toHex(color);
    }

    @Override
    protected Icon convertToIcon(Object object) {
        if (object == null) {
            return null;
        }
        return new ColorIcon((Color)object);
    }

    private static class ColorIcon
    implements Icon {
        private Color color;

        public ColorIcon(Color color) {
            this.color = color;
        }

        @Override
        public int getIconHeight() {
            return 10;
        }

        @Override
        public int getIconWidth() {
            return 20;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            if (this.color != null) {
                graphics.setColor(this.color);
                graphics.fillRect(n, n2, this.getIconWidth(), this.getIconHeight());
            }
            graphics.setColor(UIManager.getColor("controlDkShadow"));
            graphics.drawRect(n, n2, this.getIconWidth(), this.getIconHeight());
            graphics.setColor(color);
        }
    }
}

