/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing.renderer;

import com.l2fprod.common.model.DefaultObjectRenderer;
import com.l2fprod.common.model.ObjectRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.SystemColor;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableCellRenderer;

public class DefaultCellRenderer
extends DefaultTableCellRenderer
implements ListCellRenderer {
    private ObjectRenderer objectRenderer = new DefaultObjectRenderer();
    private Color oddBackgroundColor = SystemColor.window;
    private Color evenBackgroundColor = SystemColor.window;
    private boolean showOddAndEvenRows = true;

    public void setOddBackgroundColor(Color color) {
        this.oddBackgroundColor = color;
    }

    public void setEvenBackgroundColor(Color color) {
        this.evenBackgroundColor = color;
    }

    public void setShowOddAndEvenRows(boolean bl) {
        this.showOddAndEvenRows = bl;
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        this.setBorder(null);
        if (bl) {
            this.setBackground(jList.getSelectionBackground());
            this.setForeground(jList.getSelectionForeground());
        } else {
            this.setBackground(jList.getBackground());
            this.setForeground(jList.getForeground());
        }
        this.setValue(object);
        return this;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (this.showOddAndEvenRows && !bl) {
            if (n % 2 == 0) {
                this.setBackground(this.oddBackgroundColor);
            } else {
                this.setBackground(this.evenBackgroundColor);
            }
        }
        this.setValue(object);
        return this;
    }

    @Override
    public void setValue(Object object) {
        String string = this.convertToString(object);
        Icon icon = this.convertToIcon(object);
        this.setText(string == null ? "" : string);
        this.setIcon(icon);
    }

    protected String convertToString(Object object) {
        return this.objectRenderer.getText(object);
    }

    protected Icon convertToIcon(Object object) {
        return null;
    }
}

