/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.util.converter;

import com.l2fprod.common.util.converter.Converter;
import com.l2fprod.common.util.converter.ConverterRegistry;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.StringTokenizer;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;

public class AWTConverters
implements Converter {
    public void register(ConverterRegistry converterRegistry) {
        converterRegistry.addConverter(Dimension.class, String.class, this);
        converterRegistry.addConverter(String.class, Dimension.class, this);
        converterRegistry.addConverter(DimensionUIResource.class, String.class, this);
        converterRegistry.addConverter(Insets.class, String.class, this);
        converterRegistry.addConverter(String.class, Insets.class, this);
        converterRegistry.addConverter(InsetsUIResource.class, String.class, this);
        converterRegistry.addConverter(Point.class, String.class, this);
        converterRegistry.addConverter(String.class, Point.class, this);
        converterRegistry.addConverter(Rectangle.class, String.class, this);
        converterRegistry.addConverter(String.class, Rectangle.class, this);
        converterRegistry.addConverter(Font.class, String.class, this);
        converterRegistry.addConverter(FontUIResource.class, String.class, this);
    }

    @Override
    public Object convert(Class clazz, Object object) {
        if (String.class.equals((Object)clazz)) {
            if (object instanceof Rectangle) {
                return String.valueOf(((Rectangle)object).getX()) + " " + ((Rectangle)object).getY() + " " + ((Rectangle)object).getWidth() + " " + ((Rectangle)object).getHeight();
            }
            if (object instanceof Insets) {
                return String.valueOf(((Insets)object).top) + " " + ((Insets)object).left + " " + ((Insets)object).bottom + " " + ((Insets)object).right;
            }
            if (object instanceof Dimension) {
                return String.valueOf(((Dimension)object).getWidth()) + " x " + ((Dimension)object).getHeight();
            }
            if (Point.class.equals(object.getClass())) {
                return String.valueOf(((Point)object).getX()) + " " + ((Point)object).getY();
            }
            if (object instanceof Font) {
                return String.valueOf(((Font)object).getFontName()) + ", " + ((Font)object).getStyle() + ", " + ((Font)object).getSize();
            }
        }
        if (object instanceof String) {
            if (Rectangle.class.equals((Object)clazz)) {
                double[] dArray = this.convert((String)object, 4, " ");
                if (dArray == null) {
                    throw new IllegalArgumentException("Invalid format");
                }
                Rectangle rectangle = new Rectangle();
                rectangle.setFrame(dArray[0], dArray[1], dArray[2], dArray[3]);
                return rectangle;
            }
            if (Insets.class.equals((Object)clazz)) {
                double[] dArray = this.convert((String)object, 4, " ");
                if (dArray == null) {
                    throw new IllegalArgumentException("Invalid format");
                }
                return new Insets((int)dArray[0], (int)dArray[1], (int)dArray[2], (int)dArray[3]);
            }
            if (Dimension.class.equals((Object)clazz)) {
                double[] dArray = this.convert((String)object, 2, "x");
                if (dArray == null) {
                    throw new IllegalArgumentException("Invalid format");
                }
                Dimension dimension = new Dimension();
                dimension.setSize(dArray[0], dArray[1]);
                return dimension;
            }
            if (Point.class.equals((Object)clazz)) {
                double[] dArray = this.convert((String)object, 2, " ");
                if (dArray == null) {
                    throw new IllegalArgumentException("Invalid format");
                }
                Point point = new Point();
                point.setLocation(dArray[0], dArray[1]);
                return point;
            }
        }
        return null;
    }

    private double[] convert(String string, int n, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        if (stringTokenizer.countTokens() != n) {
            return null;
        }
        try {
            double[] dArray = new double[n];
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                dArray[n2] = Double.parseDouble(stringTokenizer.nextToken());
                ++n2;
            }
            return dArray;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

