/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.util.converter;

import com.l2fprod.common.util.converter.AWTConverters;
import com.l2fprod.common.util.converter.BooleanConverter;
import com.l2fprod.common.util.converter.Converter;
import com.l2fprod.common.util.converter.NumberConverters;
import java.util.HashMap;
import java.util.Map;

public class ConverterRegistry
implements Converter {
    private static ConverterRegistry sharedInstance = new ConverterRegistry();
    private Map fromMap = new HashMap();

    public ConverterRegistry() {
        new BooleanConverter().register(this);
        new AWTConverters().register(this);
        new NumberConverters().register(this);
    }

    public void addConverter(Class clazz, Class clazz2, Converter converter) {
        HashMap<Class, Converter> hashMap = (HashMap<Class, Converter>)this.fromMap.get(clazz);
        if (hashMap == null) {
            hashMap = new HashMap<Class, Converter>();
            this.fromMap.put(clazz, hashMap);
        }
        hashMap.put(clazz2, converter);
    }

    public Converter getConverter(Class clazz, Class clazz2) {
        Map map = (Map)this.fromMap.get(clazz);
        if (map != null) {
            return (Converter)map.get(clazz2);
        }
        return null;
    }

    @Override
    public Object convert(Class clazz, Object object) {
        if (object == null) {
            return null;
        }
        Converter converter = this.getConverter(object.getClass(), clazz);
        if (converter == null) {
            throw new IllegalArgumentException("No converter from " + object.getClass() + " to " + clazz.getName());
        }
        return converter.convert(clazz, object);
    }

    public static ConverterRegistry instance() {
        return sharedInstance;
    }
}

