/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.util.converter;

import com.l2fprod.common.util.converter.Converter;
import com.l2fprod.common.util.converter.ConverterRegistry;
import java.text.NumberFormat;

public class NumberConverters
implements Converter {
    private static NumberFormat defaultFormat;
    private NumberFormat format;

    public NumberConverters() {
        this(NumberConverters.getDefaultFormat());
    }

    public NumberConverters(NumberFormat numberFormat) {
        this.format = numberFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NumberFormat getDefaultFormat() {
        Class<NumberConverters> clazz = NumberConverters.class;
        synchronized (NumberConverters.class) {
            if (defaultFormat == null) {
                defaultFormat = NumberFormat.getNumberInstance();
                defaultFormat.setMinimumIntegerDigits(1);
                defaultFormat.setMaximumIntegerDigits(64);
                defaultFormat.setMinimumFractionDigits(0);
                defaultFormat.setMaximumFractionDigits(64);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultFormat;
        }
    }

    public void register(ConverterRegistry converterRegistry) {
        converterRegistry.addConverter(Number.class, Double.class, this);
        converterRegistry.addConverter(Number.class, Float.class, this);
        converterRegistry.addConverter(Number.class, Integer.class, this);
        converterRegistry.addConverter(Number.class, Long.class, this);
        converterRegistry.addConverter(Number.class, Short.class, this);
        converterRegistry.addConverter(Double.class, Double.class, this);
        converterRegistry.addConverter(Double.class, Float.class, this);
        converterRegistry.addConverter(Double.class, Integer.class, this);
        converterRegistry.addConverter(Double.class, Long.class, this);
        converterRegistry.addConverter(Double.class, Short.class, this);
        converterRegistry.addConverter(Double.class, String.class, this);
        converterRegistry.addConverter(Float.class, Double.class, this);
        converterRegistry.addConverter(Float.class, Float.class, this);
        converterRegistry.addConverter(Float.class, Integer.class, this);
        converterRegistry.addConverter(Float.class, Long.class, this);
        converterRegistry.addConverter(Float.class, Short.class, this);
        converterRegistry.addConverter(Float.class, String.class, this);
        converterRegistry.addConverter(Integer.class, Double.class, this);
        converterRegistry.addConverter(Integer.class, Float.class, this);
        converterRegistry.addConverter(Integer.class, Integer.class, this);
        converterRegistry.addConverter(Integer.class, Long.class, this);
        converterRegistry.addConverter(Integer.class, Short.class, this);
        converterRegistry.addConverter(Integer.class, String.class, this);
        converterRegistry.addConverter(Long.class, Double.class, this);
        converterRegistry.addConverter(Long.class, Float.class, this);
        converterRegistry.addConverter(Long.class, Integer.class, this);
        converterRegistry.addConverter(Long.class, Long.class, this);
        converterRegistry.addConverter(Long.class, Short.class, this);
        converterRegistry.addConverter(Long.class, String.class, this);
        converterRegistry.addConverter(Short.class, Double.class, this);
        converterRegistry.addConverter(Short.class, Float.class, this);
        converterRegistry.addConverter(Short.class, Integer.class, this);
        converterRegistry.addConverter(Short.class, Long.class, this);
        converterRegistry.addConverter(Short.class, Short.class, this);
        converterRegistry.addConverter(Short.class, String.class, this);
        converterRegistry.addConverter(String.class, Double.class, this);
        converterRegistry.addConverter(String.class, Float.class, this);
        converterRegistry.addConverter(String.class, Integer.class, this);
        converterRegistry.addConverter(String.class, Long.class, this);
        converterRegistry.addConverter(String.class, Short.class, this);
    }

    @Override
    public Object convert(Class clazz, Object object) {
        if (object instanceof Number && Number.class.isAssignableFrom(clazz)) {
            if (Double.class.equals((Object)clazz)) {
                return new Double(((Number)object).doubleValue());
            }
            if (Float.class.equals((Object)clazz)) {
                return new Float(((Number)object).floatValue());
            }
            if (Integer.class.equals((Object)clazz)) {
                return new Integer(((Number)object).intValue());
            }
            if (Long.class.equals((Object)clazz)) {
                return new Long(((Number)object).longValue());
            }
            if (Short.class.equals((Object)clazz)) {
                return new Short(((Number)object).shortValue());
            }
            throw new IllegalArgumentException("this code must not be reached");
        }
        if (object instanceof Number && String.class.equals((Object)clazz)) {
            if (object instanceof Double || object instanceof Float) {
                return this.format.format(((Number)object).doubleValue());
            }
            return this.format.format(((Number)object).longValue());
        }
        if (object instanceof String && Number.class.isAssignableFrom(clazz)) {
            if (Double.class.equals((Object)clazz)) {
                return new Double((String)object);
            }
            if (Float.class.equals((Object)clazz)) {
                return new Float((String)object);
            }
            if (Integer.class.equals((Object)clazz)) {
                return new Integer((String)object);
            }
            if (Long.class.equals((Object)clazz)) {
                return new Long((String)object);
            }
            if (Short.class.equals((Object)clazz)) {
                return new Short((String)object);
            }
            throw new IllegalArgumentException("this code must not be reached");
        }
        throw new IllegalArgumentException("no conversion supported");
    }
}

