/*
 * Decompiled with CFR 0.152.
 */
package topo;

import com.zhtelecom.common.snmp.SNMPFactory;
import com.zhtelecom.common.snmp.SNMPSysConfig;
import com.zhtelecom.common.topograph.TopoDataSource;
import com.zhtelecom.common.topograph.TopoGraphView;
import com.zhtelecom.common.topograph.TopoTreeView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import topo.action.SystemExitAction;
import topo.console.ConsoleTextArea;
import topo.frame.CompanyDescriptionPane;
import topo.menu.MenuBarManager;
import topo.menu.TopoViewMouseHandle;
import topo.service.TopoDataBackRestore;
import topo.sourcecode.LineNumber;
import topo.sourcecode.SourceCodeList;
import topo.sourcecode.SourceCodeTextArea;
import topo.trap.TrapAnalyticsServer;
import topo.trap.TrapPrintTextArea;

public class MainFrame
extends JApplet {
    public static Frame frame;
    public static TopoDataSource source;
    public static TopoGraphView topoView;
    public TopoTreeView treeView;
    private JSplitPane rootSplitPane = null;
    private JSplitPane rightSplitPane = null;
    private JScrollPane treeScrollPane = null;
    private JScrollPane consoleScrollPane = null;
    private JScrollPane topoScrollPane = null;
    private JPanel sourceCodePanel = null;
    private JScrollPane sourceCodeScrollPane = null;
    private JScrollPane sourceCodeListScrollPane = null;
    public static JList sourceCodeList;
    private JTabbedPane rootTabbedPane = null;
    private JTabbedPane consoleTabbedPane = null;
    private static JTextArea consoleArea;
    private static JTextArea sourceCodeArea;
    public static MainFrame mainFrame;
    private static JMenuBar menuBar;
    private TrapPrintTextArea trapPrintArea = null;

    static {
        sourceCodeList = null;
        consoleArea = null;
        sourceCodeArea = null;
        mainFrame = null;
        menuBar = new JMenuBar();
    }

    @Override
    public void init() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        SNMPSysConfig.isUseWindowsPing = true;
        mainFrame = this;
        this.topoInit();
        try {
            this.mainFrameInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            SNMPFactory.init(1, null, 0);
            TrapAnalyticsServer.startTrapAnalyticsServer(this.trapPrintArea);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        frame = new Frame();
        frame.setBounds(this.getBounds());
        new Thread(){

            @Override
            public void run() {
                try {
                    TopoDataBackRestore.initBackupTopo();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }.start();
    }

    public void mainFrameInit() throws Exception {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(dimension.width, dimension.height);
        this.treeScrollPane = new JScrollPane(this.treeView);
        this.topoScrollPane = new JScrollPane(topoView);
        sourceCodeList = new SourceCodeList();
        sourceCodeList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                String string = sourceCodeList.getSelectedValue().toString();
                try {
                    sourceCodeArea.setText(SourceCodeList.readSourceCodeFromFile(string));
                }
                catch (Exception exception) {
                    sourceCodeArea.setText("\"" + string + "\"\u7684\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728");
                    exception.printStackTrace();
                }
                sourceCodeArea.setCaretPosition(0);
            }
        });
        this.sourceCodeListScrollPane = new JScrollPane(sourceCodeList);
        sourceCodeArea = new SourceCodeTextArea();
        this.sourceCodeScrollPane = new JScrollPane(sourceCodeArea);
        LineNumber lineNumber = new LineNumber(sourceCodeArea);
        this.sourceCodeScrollPane.setRowHeaderView(lineNumber);
        this.sourceCodePanel = new JPanel();
        this.sourceCodePanel.setLayout(new BorderLayout());
        this.sourceCodePanel.add((Component)this.sourceCodeListScrollPane, "West");
        this.sourceCodePanel.add((Component)this.sourceCodeScrollPane, "Center");
        this.trapPrintArea = new TrapPrintTextArea();
        this.rootTabbedPane = new JTabbedPane();
        this.rootTabbedPane.add("\u8bbe\u5907\u89c6\u56fe", this.topoScrollPane);
        this.rootTabbedPane.add("TRAP\u4fe1\u606f", new JScrollPane(this.trapPrintArea));
        this.rootTabbedPane.add("\u6838\u5fc3\u6e90\u7801", this.sourceCodePanel);
        this.rootTabbedPane.add("\u516c\u53f8\u4ea7\u54c1\u4ecb\u7ecd", new JScrollPane(new CompanyDescriptionPane()));
        consoleArea = new ConsoleTextArea();
        this.consoleScrollPane = new JScrollPane(consoleArea);
        this.consoleTabbedPane = new JTabbedPane();
        this.consoleTabbedPane.add("\u63a7\u5236\u53f0", this.consoleScrollPane);
        this.rightSplitPane = new JSplitPane(0);
        this.rightSplitPane.setDividerLocation(dimension.height / 2);
        this.rightSplitPane.setOneTouchExpandable(true);
        this.rightSplitPane.add((Component)this.rootTabbedPane, "top");
        this.rightSplitPane.add((Component)this.consoleTabbedPane, "bottom");
        this.rootSplitPane = new JSplitPane(1);
        this.rootSplitPane.setDividerLocation(dimension.width / 5);
        this.rootSplitPane.setOneTouchExpandable(true);
        this.rootSplitPane.add((Component)this.treeScrollPane, "left");
        this.rootSplitPane.add((Component)this.rightSplitPane, "right");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.rootSplitPane, "Center");
    }

    public void topoInit() {
        try {
            source = new TopoDataSource();
            source.beginChange();
            topoView = new TopoGraphView(source);
            topoView.getStatusLabel().setText("\u72b6\u6001\u680f");
            TopoViewMouseHandle topoViewMouseHandle = new TopoViewMouseHandle();
            topoView.setMouseHandle(topoViewMouseHandle);
            this.treeView = new TopoTreeView(source);
            this.treeView.syncTopoview(topoView);
            source.commitChange();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void destroy() {
        new SystemExitAction().actionPerformed(null);
    }

    public static void main(String[] stringArray) {
        System.setProperty("sun.net.client.socketTime", "3000");
        SNMPSysConfig.isUseWindowsPing = false;
        MainFrame mainFrame = new MainFrame();
        mainFrame.init();
        JFrame jFrame = new JFrame("SugarNMSTool\uff08\u5317\u4eac\u667a\u548c\u4fe1\u901a\u6280\u672f\u6709\u9650\u516c\u53f8 \u8363\u8a89\u51fa\u54c1\uff09 ");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        jFrame.setSize(dimension.width, dimension.height);
        jFrame.setDefaultCloseOperation(0);
        jFrame.setContentPane(MainFrame.mainFrame.getContentPane());
        jFrame.setJMenuBar(menuBar);
        MenuBarManager.initMenu(menuBar, topoView);
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                new SystemExitAction().actionPerformed(null);
            }
        });
        jFrame.setVisible(true);
    }
}

