/*
 * Decompiled with CFR 0.152.
 */
package topo.action.snmp;

import com.zhtelecom.common.snmp.SNMPTarget;
import com.zhtelecom.nms.framework.discover.DeviceInfo;
import com.zhtelecom.nms.framework.discover.DiscoverAPI;
import com.zhtelecom.nms.framework.discover.LinkInfo;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JPanel;
import topo.MainFrame;
import topo.data.NodeDevice;
import topo.service.SNMPBaseObjectService;
import topo.table.ObjectTable;
import topo.table.ObjectTableDesc;
import topo.table.ObjectTableModel;
import topo.table.ScrollTablePane;
import topo.utils.DialogTools;

public class SNMPDiscoverSwitchPC
extends AbstractAction {
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Serializable serializable;
        MainFrame.sourceCodeList.setSelectedValue(this.getValue("Name"), true);
        NodeDevice nodeDevice = (NodeDevice)this.getValue("ActionDataKeyName");
        ObjectTableDesc objectTableDesc = new ObjectTableDesc(){

            @Override
            public Object[] getcolumnNames() {
                Object[] objectArray = new String[]{"\u672c\u5730\u7aef\u53e3", "\u672c\u5730IP", "\u672c\u5730MAC", "\u5bf9\u7aef\u7aef\u53e3", "\u5bf9\u7aef\u8bbe\u5907IP", "\u5bf9\u7aef\u8bbe\u5907MAC"};
                return objectArray;
            }

            @Override
            public Object[] getRowDatas(Object object) {
                LinkInfo linkInfo = (LinkInfo)object;
                Object[] objectArray = new Object[]{linkInfo.startPort, linkInfo.startDevice.getDeviceIP(), linkInfo.startDevice.getDeviceMAC(), linkInfo.endPort, linkInfo.endDevice.getDeviceIP(), linkInfo.endDevice.getDeviceMAC()};
                return objectArray;
            }

            @Override
            public Class getTableObjectClass() {
                return LinkInfo.class;
            }
        };
        ObjectTableModel objectTableModel = new ObjectTableModel(objectTableDesc);
        try {
            serializable = SNMPBaseObjectService.nodeToSNMPConnInfo(nodeDevice);
            Vector<SNMPTarget> vector = new Vector<SNMPTarget>();
            vector.add((SNMPTarget)serializable);
            DeviceInfo deviceInfo = DiscoverAPI.getDiscoverAPI().getDeviceBasicInfo(nodeDevice.getIpAddress(), vector, false);
            Vector<DeviceInfo> vector2 = new Vector<DeviceInfo>();
            vector2.add(deviceInfo);
            List<LinkInfo> list = DiscoverAPI.getDiscoverAPI().searchLinkInfo(vector2);
            objectTableModel.addRowObject(list);
            if (list.size() <= 0) {
                DialogTools.showOkMsg(MainFrame.mainFrame, "\u6d88\u606f\u63d0\u793a", "\u672a\u53d1\u73b0\u4e0b\u6302\u76f4\u8fde\u8bbe\u5907");
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            DialogTools.showErroMsg(MainFrame.mainFrame, "\u67e5\u8be2\u51fa\u9519!");
        }
        serializable = new TableDialog(MainFrame.frame, objectTableModel);
        ((Dialog)serializable).setTitle("\u76f4\u8fde\u4e0b\u6302\u8bbe\u5907\u4fe1\u606f");
        ((Window)serializable).setSize(800, 500);
        DialogTools.dialogPack(MainFrame.frame, (JDialog)serializable);
    }

    public SNMPDiscoverSwitchPC() {
        super("\u641c\u7d22\u76f4\u8fde\u4e0b\u6302\u8bbe\u5907");
    }

    public static void main(String[] stringArray) {
        try {
            SNMPDiscoverSwitchPC sNMPDiscoverSwitchPC = new SNMPDiscoverSwitchPC();
            sNMPDiscoverSwitchPC.actionPerformed(null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class TableDialog
    extends JDialog {
        public ObjectTableModel mod;
        public ObjectTable table;
        ScrollTablePane jScrollPaneCenter;
        JPanel jPanelSouth;

        public TableDialog(Frame frame, ObjectTableModel objectTableModel) {
            super(frame);
            this.jPanelSouth = new JPanel();
            this.mod = objectTableModel;
            this.table = new ObjectTable(this.mod);
            this.jScrollPaneCenter = new ScrollTablePane(this.table);
            try {
                this.getContentPane().add((Component)this.jScrollPaneCenter, "Center");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.setDefaultCloseOperation(2);
        }
    }
}

