/*
 * Decompiled with CFR 0.152.
 */
package topo.autosearch;

import com.zhtelecom.common.snmp.mib.MibIfEntry;
import com.zhtelecom.common.topograph.TopoNode;
import com.zhtelecom.nms.framework.discover.DeviceInfo;
import com.zhtelecom.nms.framework.discover.LinkInfo;
import com.zhtelecom.nms.framework.discover.PortInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import topo.MainFrame;
import topo.data.NodeDevice;
import topo.data.NodeLink;
import topo.data.NodeType;
import topo.service.TopoDataManager;
import topo.utils.NodeByIPComparator;

public class InitTopo {
    static final int X_NUM = 10;
    static final int Local_X_W = 100;
    static final int Local_y_H = 100;

    public static void initTopoNode(List<DeviceInfo> list) {
        MainFrame.source.beginChange();
        for (DeviceInfo deviceInfo : list) {
            if (!NodeType.nodeTypeMap.containsKey(deviceInfo.getDeviceType().getDeviceProductType())) continue;
            NodeDevice nodeDevice = InitTopo.deviceToNode(deviceInfo);
            TopoNode topoNode = new TopoNode(nodeDevice);
            String string = nodeDevice.getNodeType();
            NodeType nodeType = NodeType.getNodeTypeByKey(string);
            if (nodeType != null) {
                topoNode.setImageIcon(nodeType.getTypeImage());
            } else {
                topoNode.setImageIcon(TopoNode.defaultIcon);
            }
            topoNode.setDisplayName(deviceInfo.getDeviceIP());
            MainFrame.source.addTopoData(topoNode);
        }
        if (list.size() > 0) {
            InitTopo.arrangeDevices();
        }
        MainFrame.source.commitChange();
    }

    private static void arrangeDevices() {
        Vector<TopoNode> vector = MainFrame.source.getAllTopoNode();
        ArrayList<NodeDevice> arrayList = new ArrayList<NodeDevice>();
        for (TopoNode topoNode : vector) {
            if (!(topoNode.getUserID() instanceof NodeDevice)) continue;
            arrayList.add((NodeDevice)topoNode.getUserID());
        }
        Collections.sort(arrayList, new NodeByIPComparator());
        int n = 0;
        for (NodeDevice nodeDevice : arrayList) {
            int n2 = n + 1;
            int n3 = n2 % 10;
            if (n3 == 0) {
                n3 = 10;
            }
            int n4 = (n3 - 1) * 100 + 30;
            int n5 = n2 / 10;
            if (n2 % 10 != 0) {
                ++n5;
            }
            int n6 = (n5 - 1) * 100 + 30;
            TopoNode topoNode = TopoDataManager.getInstance().getTopoNodeByName(nodeDevice.getNodeName());
            if (topoNode == null) continue;
            topoNode.setX(n4);
            topoNode.setY(n6);
            ++n;
        }
    }

    public static void initTopoLink(List<LinkInfo> list) {
        MainFrame.source.beginChange();
        for (LinkInfo linkInfo : list) {
            if (!linkInfo.linkType.equals(LinkInfo.LinkTypeInbound)) continue;
            NodeLink nodeLink = InitTopo.linkToNodeLink(linkInfo);
            TopoDataManager.getInstance().addLink(nodeLink);
        }
        MainFrame.source.commitChange();
    }

    private static NodeDevice deviceToNode(DeviceInfo deviceInfo) {
        NodeDevice nodeDevice = new NodeDevice();
        nodeDevice.setDeviceLogicType(deviceInfo.getDeviceType().getLogicType());
        nodeDevice.setDeviceMainMAC(deviceInfo.getDeviceMAC());
        nodeDevice.setDeviceSystemDesc(deviceInfo.getDeviceDesc());
        nodeDevice.setDeviceSystemOID(deviceInfo.getDeviceSysOID());
        nodeDevice.setDisplayName(deviceInfo.getDeviceName());
        nodeDevice.setIpAddress(deviceInfo.getDeviceIP());
        if (deviceInfo.getSnmpTarget() != null) {
            nodeDevice.setManagerProtocol("SNMP");
            nodeDevice.setSnmpPort(deviceInfo.getSnmpTarget().port);
            nodeDevice.setSnmpVersion(deviceInfo.getSnmpTarget().snmpVersion);
            nodeDevice.setReadCommit(deviceInfo.getSnmpTarget().readCommunity);
            nodeDevice.setWriteCommit(deviceInfo.getSnmpTarget().writeCommunity);
        } else {
            nodeDevice.setManagerProtocol("\u975eSNMP");
        }
        nodeDevice.setNodeDesc(deviceInfo.getDeviceDesc());
        nodeDevice.setNodeType(deviceInfo.getDeviceType().getDeviceProductType());
        nodeDevice.setNodeName(nodeDevice.genKey());
        return nodeDevice;
    }

    private static NodeLink linkToNodeLink(LinkInfo linkInfo) {
        Object object;
        NodeLink nodeLink = new NodeLink();
        NodeDevice nodeDevice = InitTopo.deviceToNode(linkInfo.startDevice);
        NodeDevice nodeDevice2 = InitTopo.deviceToNode(linkInfo.endDevice);
        nodeLink.setFromNode(nodeDevice.getNodeName());
        nodeLink.setFromNodeIfIndex(linkInfo.startPort);
        nodeLink.setFromPhysicalPort(linkInfo.startPort);
        PortInfo portInfo = linkInfo.startPortInfo;
        PortInfo portInfo2 = linkInfo.endPortInfo;
        long l = 0L;
        MibIfEntry mibIfEntry = portInfo.getPortMibIfEntry();
        if (mibIfEntry != null) {
            if (portInfo.isUseIfIndexPort) {
                int n = mibIfEntry.getIfIndex();
                nodeLink.setFromNodeIfIndex(n);
            } else {
                nodeLink.setFromNodeIfIndex(linkInfo.startPort);
            }
            object = mibIfEntry.getIfDescr();
            nodeLink.setFromNodeIfName((String)object);
            l = mibIfEntry.getIfSpeed();
        } else {
            nodeLink.setFromNodeIfIndex(linkInfo.startPort);
        }
        object = portInfo2.getPortMibIfEntry();
        if (object != null) {
            if (portInfo2.isUseIfIndexPort) {
                int n = ((MibIfEntry)object).getIfIndex();
                nodeLink.setToNodeIfIndex(n);
            } else {
                nodeLink.setToNodeIfIndex(linkInfo.endPort);
            }
            String string = ((MibIfEntry)object).getIfDescr();
            nodeLink.setToNodeIfName(string);
            if (nodeLink.getLinkBandwidth() <= 0L) {
                l = ((MibIfEntry)object).getIfSpeed();
            }
        } else {
            nodeLink.setToNodeIfIndex(linkInfo.endPort);
        }
        nodeLink.setLinkBandwidth(l /= 1000000L);
        nodeLink.setLinkType(linkInfo.linkType);
        nodeLink.setToNodeIfIndex(linkInfo.endPort);
        nodeLink.setToNode(nodeDevice2.getNodeName());
        nodeLink.setToPhysicalPort(linkInfo.endPort);
        nodeLink.setLinkName(nodeLink.genKey());
        return nodeLink;
    }
}

