/*
 * Decompiled with CFR 0.152.
 */
package topo.autosearch;

import com.zhtelecom.common.base.MyException;
import com.zhtelecom.common.snmp.SNMPTarget;
import com.zhtelecom.nms.framework.discover.DeviceInfo;
import com.zhtelecom.nms.framework.discover.DiscoverAPI;
import com.zhtelecom.nms.framework.discover.DiscoverConfig;
import com.zhtelecom.nms.framework.discover.ResourceInfo;
import com.zhtelecom.nms.framework.discover.ResourceSearchMothType;
import java.util.List;
import topo.autosearch.RsSearchMethodManager;
import topo.data.NodeDevice;
import topo.data.ResourceType;
import topo.utils.SNMPTargetTool;

public class NodeResourceSearch {
    public List<ResourceInfo> getResourceOfNode(NodeDevice nodeDevice) throws MyException {
        try {
            this.initResourceTypeConfig();
            DeviceInfo deviceInfo = new DeviceInfo();
            SNMPTarget sNMPTarget = SNMPTargetTool.nodeToSNMPConnInfo(nodeDevice);
            deviceInfo.setSnmpTarget(sNMPTarget);
            List<ResourceInfo> list = DiscoverAPI.getDiscoverAPI().searchDeviceResource(deviceInfo);
            return list;
        }
        catch (Exception exception) {
            throw new MyException(exception);
        }
    }

    private void initResourceTypeConfig() throws MyException {
        try {
            List<ResourceType> list = ResourceType.getRsTypeList();
            DiscoverConfig.clearAllResourceSearchMoth();
            for (ResourceType resourceType : list) {
                String string = resourceType.getSearchResourceClassName();
                ResourceSearchMothType resourceSearchMothType = RsSearchMethodManager.getNewInstanceProcess(string);
                if (resourceSearchMothType == null) continue;
                resourceSearchMothType.setResoureTypeName(resourceType.getResoureTypeName());
                resourceSearchMothType.setResouceBaseType(resourceType.getResouceBaseTechType());
                resourceSearchMothType.setResourceRSID(resourceType.getResourceRSID());
                resourceSearchMothType.setTypeDesc(resourceType.getTypeDesc());
                resourceSearchMothType.setDisplayNameCode(resourceType.getTypeDesc());
                resourceSearchMothType.setParamCode(resourceType.getTypeParam());
                DiscoverConfig.addResourceType(resourceSearchMothType);
            }
        }
        catch (Exception exception) {
            throw new MyException(exception);
        }
    }
}

