/*
 * Decompiled with CFR 0.152.
 */
package topo.console;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import topo.console.LoopedStreams;

public class ConsoleTextArea
extends JTextArea
implements ActionListener {
    private JPopupMenu consoleMenu;
    private JMenuItem copyItem;
    private JMenuItem selectAllItem;
    private JMenuItem clearSelectItem;
    private JMenuItem clearAllItem;
    private JMenuItem lockRollItem;
    private boolean lockRollBoolean = false;
    private final String LOCKROLL_YES = "\u6eda\u52a8\u9501\u5b9a";
    private final String LOCKROLL_NO = "\u6eda\u52a8\u89e3\u9501";
    Font font = new Font("Courier", 0, 14);

    public ConsoleTextArea(InputStream[] inputStreamArray) {
        int n = 0;
        while (n < inputStreamArray.length) {
            this.startConsoleReaderThread(inputStreamArray[n]);
            ++n;
        }
    }

    public ConsoleTextArea() throws IOException {
        this.initConsoleArea();
        LoopedStreams loopedStreams = new LoopedStreams();
        PrintStream printStream = new PrintStream(loopedStreams.getOutputStream());
        System.setOut(printStream);
        System.setErr(printStream);
        this.startConsoleReaderThread(loopedStreams.getInputStream());
    }

    private void initConsoleArea() {
        this.consoleMenu = new JPopupMenu();
        this.copyItem = new JMenuItem("\u590d\u5236");
        this.selectAllItem = new JMenuItem("\u5168\u90e8\u9009\u4e2d");
        this.clearSelectItem = new JMenuItem("\u6e05\u9664\u9009\u4e2d");
        this.clearAllItem = new JMenuItem("\u6e05\u9664\u5168\u90e8");
        this.lockRollItem = new JMenuItem("\u6eda\u52a8\u9501\u5b9a");
        this.consoleMenu.add(this.copyItem);
        this.consoleMenu.addSeparator();
        this.consoleMenu.add(this.selectAllItem);
        this.consoleMenu.add(this.clearSelectItem);
        this.consoleMenu.add(this.clearAllItem);
        this.consoleMenu.addSeparator();
        this.consoleMenu.add(this.lockRollItem);
        this.copyItem.addActionListener(this);
        this.selectAllItem.addActionListener(this);
        this.clearSelectItem.addActionListener(this);
        this.clearAllItem.addActionListener(this);
        this.lockRollItem.addActionListener(this);
        this.add(this.consoleMenu);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 3) {
                    ConsoleTextArea.this.copyItem.setEnabled(ConsoleTextArea.this.isCanCopy());
                    ConsoleTextArea.this.clearSelectItem.setEnabled(ConsoleTextArea.this.isCanCopy());
                    ConsoleTextArea.this.consoleMenu.show(ConsoleTextArea.this, mouseEvent.getX(), mouseEvent.getY());
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                ConsoleTextArea.this.setCursor(new Cursor(2));
            }
        });
        this.getCaret().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ConsoleTextArea.this.getCaret().setVisible(true);
            }
        });
        this.setEditable(false);
        this.setFont(this.font);
        this.setCaretColor(Color.RED);
        this.setTabSize(4);
    }

    public boolean isCanCopy() {
        int n;
        boolean bl = false;
        int n2 = this.getSelectionStart();
        if (n2 != (n = this.getSelectionEnd())) {
            bl = true;
        }
        return bl;
    }

    private void startConsoleReaderThread(InputStream inputStream) {
        final BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        new Thread(new Runnable(){

            @Override
            public void run() {
                StringBuffer stringBuffer = new StringBuffer();
                try {
                    String string;
                    while ((string = bufferedReader.readLine()) != null) {
                        stringBuffer.setLength(0);
                        ConsoleTextArea.this.append(stringBuffer.append(string).append('\n').toString());
                        if (ConsoleTextArea.this.lockRollBoolean) continue;
                        ConsoleTextArea.this.setCaretPosition(ConsoleTextArea.this.getDocument().getLength());
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }).start();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("ConsoleTextArea\u6d4b\u8bd5");
        ConsoleTextArea consoleTextArea = null;
        try {
            consoleTextArea = new ConsoleTextArea();
        }
        catch (IOException iOException) {
            System.err.println("\u4e0d\u80fd\u521b\u5efaLoopedStreams\uff1a" + iOException);
        }
        consoleTextArea.setFont(Font.decode("monospaced"));
        jFrame.getContentPane().add((Component)new JScrollPane(consoleTextArea), "Center");
        jFrame.setBounds(50, 50, 300, 300);
        jFrame.setVisible(true);
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        ConsoleTextArea.startWriterTestThread("\u5199\u64cd\u4f5c\u7ebf\u7a0b #1", System.err, 920, 50);
        ConsoleTextArea.startWriterTestThread("\u5199\u64cd\u4f5c\u7ebf\u7a0b #2", System.out, 500, 50);
        ConsoleTextArea.startWriterTestThread("\u5199\u64cd\u4f5c\u7ebf\u7a0b #3", System.out, 200, 50);
        ConsoleTextArea.startWriterTestThread("\u5199\u64cd\u4f5c\u7ebf\u7a0b #4", System.out, 1000, 50);
        ConsoleTextArea.startWriterTestThread("\u5199\u64cd\u4f5c\u7ebf\u7a0b #5", System.err, 850, 50);
    }

    private static void startWriterTestThread(final String string, final PrintStream printStream, final int n, final int n2) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                int n3 = 1;
                while (n3 <= n2) {
                    printStream.println("***" + string + ", hello !, i=" + n3);
                    try {
                        Thread.sleep(n);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    ++n3;
                }
            }
        }).start();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(this.copyItem.getText())) {
            this.copy();
        } else if (string.equals(this.selectAllItem.getText())) {
            this.selectAll();
        } else if (string.equals(this.clearSelectItem.getText())) {
            this.replaceSelection(null);
        } else if (string.equals(this.clearAllItem.getText())) {
            this.setText("");
        } else if (string.equals("\u6eda\u52a8\u9501\u5b9a")) {
            this.lockRollBoolean = true;
            this.lockRollItem.setText("\u6eda\u52a8\u89e3\u9501");
        } else if (string.equals("\u6eda\u52a8\u89e3\u9501")) {
            this.lockRollBoolean = false;
            this.lockRollItem.setText("\u6eda\u52a8\u9501\u5b9a");
        }
    }
}

