/*
 * Decompiled with CFR 0.152.
 */
package topo.console;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public class LoopedStreams {
    private PipedOutputStream pipedOS = new PipedOutputStream();
    private boolean keepRunning = true;
    private ByteArrayOutputStream byteArrayOS = new ByteArrayOutputStream(){

        @Override
        public void close() {
            LoopedStreams.this.keepRunning = false;
            try {
                super.close();
                LoopedStreams.this.pipedOS.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    };
    private PipedInputStream pipedIS = new PipedInputStream(){

        @Override
        public void close() {
            LoopedStreams.this.keepRunning = false;
            try {
                super.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    };

    public LoopedStreams() throws IOException {
        this.pipedOS.connect(this.pipedIS);
        this.startByteArrayReaderThread();
    }

    public InputStream getInputStream() {
        return this.pipedIS;
    }

    public OutputStream getOutputStream() {
        return this.byteArrayOS;
    }

    private void startByteArrayReaderThread() {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (LoopedStreams.this.keepRunning) {
                    if (LoopedStreams.this.byteArrayOS.size() > 0) {
                        byte[] byArray = null;
                        ByteArrayOutputStream byteArrayOutputStream = LoopedStreams.this.byteArrayOS;
                        synchronized (byteArrayOutputStream) {
                            byArray = LoopedStreams.this.byteArrayOS.toByteArray();
                            LoopedStreams.this.byteArrayOS.reset();
                        }
                        try {
                            LoopedStreams.this.pipedOS.write(byArray, 0, byArray.length);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        continue;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
        }).start();
    }
}

