/*
 * Decompiled with CFR 0.152.
 */
package topo.dataview;

import com.l2fprod.common.DefaultSheetPanel;
import com.zhtelecom.common.snmp.SNMPAPI;
import com.zhtelecom.common.snmp.SNMPFactory;
import com.zhtelecom.common.snmp.SNMPTarget;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanInfo;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import topo.table.ObjectTableModel;
import topo.utils.DialogTools;

public class SNMPSheetDialog
extends JDialog {
    public static ResourceBundle res = ResourceBundle.getBundle("topo.dataview.DefaultSheetSNMPDialogRes");
    JPanel jPanel2 = new JPanel();
    public JButton jButtonFresh = new JButton();
    public JButton jButtonAdd = new JButton();
    public JButton jButtonUpdate = new JButton();
    public JButton jButtonClose = new JButton();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    public DefaultSheetPanel sheetPanel = null;
    private boolean isAdd = false;
    private boolean isUpdate = false;
    boolean showFresh;
    public ObjectTableModel mod;
    BeanInfo beanInfo;
    SNMPTarget target;

    public Object getData() {
        return this.sheetPanel.getData();
    }

    public String dataInputCheck(boolean bl) {
        return null;
    }

    protected void initObject(SNMPTarget sNMPTarget, Object object, ObjectTableModel objectTableModel) {
        this.mod = objectTableModel;
        this.initObject(sNMPTarget, object);
    }

    public void initObject(SNMPTarget sNMPTarget, Object object) {
        this.target = sNMPTarget;
        this.sheetPanel.resetObject(object);
    }

    void init(boolean bl, boolean bl2, boolean bl3, BeanInfo beanInfo) {
        this.isAdd = bl;
        this.beanInfo = beanInfo;
        this.showFresh = bl3;
        this.isUpdate = bl2;
        try {
            this.jbInit();
            this.sheetPanel = new DefaultSheetPanel(beanInfo, null);
            this.getContentPane().add((Component)this.sheetPanel, "Center");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public SNMPSheetDialog(Frame frame, boolean bl, boolean bl2, boolean bl3, BeanInfo beanInfo) {
        super(frame, true);
        this.init(bl, bl2, bl3, beanInfo);
    }

    public SNMPSheetDialog(Dialog dialog, boolean bl, boolean bl2, boolean bl3, BeanInfo beanInfo) {
        super(dialog, true);
        this.init(bl, bl2, bl3, beanInfo);
    }

    private void jbInit() throws Exception {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SNMPSheetDialog.this.processAdd();
            }
        };
        ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SNMPSheetDialog.this.processUpdate();
            }
        };
        ActionListener actionListener3 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SNMPSheetDialog.this.processFresh();
            }
        };
        ActionListener actionListener4 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SNMPSheetDialog.this.processClose();
            }
        };
        this.jButtonFresh.setText(res.getString("String_2"));
        this.jButtonFresh.addActionListener(actionListener3);
        this.jButtonUpdate.setText(res.getString("String_3"));
        this.jButtonUpdate.addActionListener(actionListener2);
        this.jButtonClose.setText(res.getString("String_4"));
        this.jButtonClose.addActionListener(actionListener4);
        this.jLabel1.setText("        ");
        this.jLabel2.setText("        ");
        this.jButtonAdd.setText(res.getString("String_7"));
        this.jButtonAdd.addActionListener(actionListener);
        this.getContentPane().add((Component)this.jPanel2, "South");
        if (this.isAdd) {
            this.jPanel2.add((Component)this.jButtonAdd, null);
        }
        if (this.isUpdate) {
            this.jPanel2.add((Component)this.jButtonUpdate, null);
        }
        this.jPanel2.add((Component)this.jLabel1, null);
        if (this.showFresh) {
            this.jPanel2.add((Component)this.jButtonFresh, null);
        }
        this.jPanel2.add((Component)this.jLabel2, null);
        this.jPanel2.add((Component)this.jButtonClose, null);
        this.setDefaultCloseOperation(2);
    }

    public void processFresh() {
        try {
            SNMPAPI sNMPAPI = SNMPFactory.getSNMPAPI();
            Object object = this.sheetPanel.getData();
            Object object2 = sNMPAPI.getMibObject(object, this.target);
            this.sheetPanel.resetObject(object2);
            if (this.mod != null) {
                this.mod.updateRowObject(object);
            }
        }
        catch (Exception exception) {
            DialogTools.showErroMsg(this, res.getString("String_1"));
            exception.printStackTrace();
        }
    }

    public void processUpdate() {
        this.sheetPanel.writeToObject();
        String string = this.dataInputCheck(false);
        if (string != null && string.length() > 0) {
            DialogTools.showErroMsg(this, String.valueOf(res.getString("String_8")) + string);
            return;
        }
        try {
            SNMPAPI sNMPAPI = SNMPFactory.getSNMPAPI();
            Object object = this.sheetPanel.getData();
            sNMPAPI.update(object, this.target);
            if (this.mod != null) {
                this.mod.updateRowObject(object);
            }
            DialogTools.showOkMsg(this, res.getString("String_9"), res.getString("String_10"));
        }
        catch (Exception exception) {
            DialogTools.showErroMsg(this, res.getString("String_11"));
            exception.printStackTrace();
        }
    }

    public void processClose() {
        this.dispose();
    }

    public void processAdd() {
        this.sheetPanel.writeToObject();
        String string = this.dataInputCheck(true);
        if (string != null && string.length() > 0) {
            DialogTools.showErroMsg(this, String.valueOf(res.getString("String_12")) + string);
            return;
        }
        try {
            SNMPAPI sNMPAPI = SNMPFactory.getSNMPAPI();
            Object object = this.sheetPanel.getData();
            sNMPAPI.addTableRow(object, this.target);
            if (this.mod != null) {
                this.mod.addRowObject(object);
            }
            DialogTools.showOkMsg(this, res.getString("String_13"), res.getString("String_14"));
            this.dispose();
        }
        catch (Exception exception) {
            DialogTools.showErroMsg(this, res.getString("String_15"));
            exception.printStackTrace();
        }
    }
}

