/*
 * Decompiled with CFR 0.152.
 */
package topo.dataview;

import com.zhtelecom.common.snmp.SNMPAPI;
import com.zhtelecom.common.snmp.SNMPFactory;
import com.zhtelecom.common.snmp.SNMPTarget;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import topo.dataview.SNMPSheetDialog;
import topo.table.ObjectTable;
import topo.table.ObjectTableDesc;
import topo.table.ObjectTableModel;
import topo.table.ScrollTablePane;
import topo.table.TableMouseHandle;
import topo.utils.DialogTools;

public class SNMPTableDialog
extends JDialog {
    public static ResourceBundle res = ResourceBundle.getBundle("topo.dataview.DefaultSNMPTableDialogRes");
    public ObjectTableModel mod;
    public ObjectTable table;
    ScrollTablePane jScrollPaneCenter;
    JPanel jPanelSouth = new JPanel();
    public JButton jButtonAdd = new JButton();
    public JButton jButtonDel = new JButton();
    public JButton jButtonQuery = new JButton();
    public JButton jButtonClose = new JButton();
    public JButton jButtonDetails = new JButton();
    boolean showAdd;
    boolean showDel;
    boolean showDetail;
    boolean showQueryAll;
    public ObjectTableDesc tableDesc;
    public SNMPSheetDialog sheetAddDialog;
    public SNMPSheetDialog sheetViewDialog;
    SNMPTarget target;

    public void processAdd() {
        Object object = this.getNewAddObject();
        if (this.sheetAddDialog != null) {
            this.sheetAddDialog.initObject(this.target, object, this.mod);
            DialogTools.WindowPack(this, this.sheetAddDialog);
        }
    }

    public void processDel() {
        Object object = this.table.getSelectRowObject();
        try {
            SNMPAPI sNMPAPI = SNMPFactory.getSNMPAPI();
            sNMPAPI.delTableRow(object, this.target);
            this.mod.delRowObject(object);
            DialogTools.showOkMsg(this, res.getString("String_8"), res.getString("String_9"));
        }
        catch (Exception exception) {
            DialogTools.showErroMsg(this, res.getString("String_10"));
            exception.printStackTrace();
        }
    }

    public void processQueryall() {
        try {
            SNMPAPI sNMPAPI = SNMPFactory.getSNMPAPI();
            List list = sNMPAPI.getAllTableData(this.tableDesc.getTableObjectClass(), this.target);
            this.mod.clearAllObject();
            this.mod.addRowObject(list);
            if (list.size() > 0) {
                this.table.setRowSelectionInterval(0, 0);
            }
        }
        catch (Exception exception) {
            DialogTools.showErroMsg(this, res.getString("String_2"));
            exception.printStackTrace();
        }
    }

    public void processClose() {
        this.dispose();
    }

    public void processView() {
        if (!this.showDetail) {
            return;
        }
        if (this.sheetViewDialog != null) {
            Object object = this.table.getSelectRowObject();
            this.sheetViewDialog.initObject(this.target, object, this.mod);
            DialogTools.WindowPack(this, this.sheetViewDialog);
        }
    }

    public SNMPTableDialog(Frame frame, ObjectTableDesc objectTableDesc, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(frame);
        this.tableDesc = objectTableDesc;
        this.showAdd = bl;
        this.showDel = bl2;
        this.showDetail = bl3;
        this.showQueryAll = bl4;
        this.mod = new ObjectTableModel(objectTableDesc);
        this.table = new ObjectTable(this.mod);
        this.jScrollPaneCenter = new ScrollTablePane(this.table);
        try {
            this.jbInit();
            this.initTableView();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setDefaultCloseOperation(2);
    }

    public void myInit(SNMPTarget sNMPTarget, SNMPSheetDialog sNMPSheetDialog, SNMPSheetDialog sNMPSheetDialog2) {
        this.target = sNMPTarget;
        this.sheetAddDialog = sNMPSheetDialog;
        this.sheetViewDialog = sNMPSheetDialog2;
    }

    Object getNewAddObject() {
        try {
            return this.tableDesc.getTableObjectClass().newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void initTableView() {
        try {
            this.getContentPane().add((Component)this.jScrollPaneCenter, "Center");
            this.jScrollPaneCenter.setMouseHandle(new Hand());
            ListSelectionListener listSelectionListener = new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    Object object = SNMPTableDialog.this.table.getSelectRowObject();
                    if (object != null) {
                        SNMPTableDialog.this.jButtonDel.setEnabled(true);
                        SNMPTableDialog.this.jButtonDetails.setEnabled(true);
                    } else {
                        SNMPTableDialog.this.jButtonDel.setEnabled(false);
                        SNMPTableDialog.this.jButtonDetails.setEnabled(false);
                    }
                }
            };
            this.table.getSelectionModel().addListSelectionListener(listSelectionListener);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.jButtonAdd.setText(res.getString("String_3"));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SNMPTableDialog.this.processAdd();
            }
        };
        ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SNMPTableDialog.this.processDel();
            }
        };
        ActionListener actionListener3 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SNMPTableDialog.this.processView();
            }
        };
        ActionListener actionListener4 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SNMPTableDialog.this.processQueryall();
            }
        };
        ActionListener actionListener5 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SNMPTableDialog.this.processClose();
            }
        };
        this.jButtonAdd.addActionListener(actionListener);
        this.jButtonDel.setEnabled(false);
        this.jButtonDel.setText(res.getString("String_4"));
        this.jButtonDel.addActionListener(actionListener2);
        this.jButtonQuery.setText(res.getString("String_5"));
        this.jButtonQuery.addActionListener(actionListener4);
        this.jButtonClose.setText(res.getString("String_6"));
        this.jButtonClose.addActionListener(actionListener5);
        this.jPanelSouth.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelSouth.setDebugGraphicsOptions(0);
        this.jButtonDetails.setEnabled(false);
        this.jButtonDetails.setText(res.getString("String_7"));
        this.jButtonDetails.addActionListener(actionListener3);
        this.getContentPane().add((Component)this.jPanelSouth, "South");
        if (this.showAdd) {
            this.jPanelSouth.add((Component)this.jButtonAdd, null);
        }
        if (this.showDel) {
            this.jPanelSouth.add((Component)this.jButtonDel, null);
        }
        if (this.showDetail) {
            this.jPanelSouth.add((Component)this.jButtonDetails, null);
        }
        if (this.showQueryAll) {
            this.jPanelSouth.add((Component)this.jButtonQuery, null);
        }
        this.jPanelSouth.add((Component)this.jButtonClose, null);
    }

    class AddAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SNMPTableDialog.this.processAdd();
        }

        public AddAction() {
            super("\u6dfb\u52a0");
        }
    }

    class DelAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SNMPTableDialog.this.processDel();
        }

        public DelAction() {
            super("\u5220\u9664");
        }
    }

    class Hand
    implements TableMouseHandle {
        Hand() {
        }

        @Override
        public JPopupMenu createObjectMenu(MouseEvent mouseEvent) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            if (SNMPTableDialog.this.showAdd) {
                jPopupMenu.add(new AddAction());
                jPopupMenu.addSeparator();
            }
            if (SNMPTableDialog.this.showDetail) {
                jPopupMenu.add(new ViewAction());
            }
            if (SNMPTableDialog.this.showDel) {
                jPopupMenu.add(new DelAction());
            }
            if (SNMPTableDialog.this.showQueryAll) {
                jPopupMenu.addSeparator();
                jPopupMenu.add(new QueryAllAction());
            }
            return jPopupMenu;
        }

        @Override
        public JPopupMenu createBlankMenu(MouseEvent mouseEvent) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            if (SNMPTableDialog.this.showAdd) {
                jPopupMenu.add(new AddAction());
            }
            if (SNMPTableDialog.this.showQueryAll) {
                jPopupMenu.addSeparator();
                jPopupMenu.add(new QueryAllAction());
            }
            return jPopupMenu;
        }

        @Override
        public void doubleClickAction(MouseEvent mouseEvent) {
            SNMPTableDialog.this.processView();
        }
    }

    class QueryAllAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SNMPTableDialog.this.processQueryall();
        }

        public QueryAllAction() {
            super("\u83b7\u53d6\u5168\u90e8\u6570\u636e");
        }
    }

    class ViewAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SNMPTableDialog.this.processView();
        }

        public ViewAction() {
            super("\u5c5e\u6027");
        }
    }
}

