/*
 * Decompiled with CFR 0.152.
 */
package topo.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Frame;
import java.net.URI;
import java.net.URL;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import topo.utils.DialogTools;

public class CompanyDescDialog
extends JDialog {
    private JEditorPane descEditor;

    public CompanyDescDialog(Frame frame) {
        super(frame);
        this.initDialog();
    }

    private void initDialog() {
        this.setSize(700, 600);
        this.setTitle("\u516c\u53f8\u4ea7\u54c1\u7b80\u4ecb");
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(2);
        this.descEditor = new JEditorPane();
        this.descEditor.setEditable(false);
        this.descEditor.setContentType("text/html");
        this.descEditor.setCursor(Cursor.getPredefinedCursor(2));
        this.initDescEditorContent();
        JScrollPane jScrollPane = new JScrollPane(this.descEditor);
        this.add((Component)jScrollPane, "Center");
        this.descEditor.addHyperlinkListener(new LinkListener());
    }

    private void initDescEditorContent() {
        try {
            URL uRL = CompanyDescDialog.class.getClassLoader().getResource("res/productIntroduction.html");
            this.descEditor.setPage(uRL);
        }
        catch (Exception exception) {
            System.out.println("\u83b7\u53d6\u516c\u53f8\u4ea7\u54c1\u7b80\u4ecbhtml\u6587\u4ef6\u51fa\u9519");
            exception.printStackTrace();
        }
    }

    class LinkListener
    implements HyperlinkListener {
        LinkListener() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    URI uRI = new URI(hyperlinkEvent.getURL().toString());
                    Desktop.getDesktop().browse(uRI);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    DialogTools.showErroMsg(CompanyDescDialog.this, "\u6253\u5f00\u94fe\u63a5\u5931\u8d25");
                }
            }
        }
    }
}

