/*
 * Decompiled with CFR 0.152.
 */
package topo.dialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import topo.data.NodeDevice;
import topo.data.NodeType;
import topo.dialog.CommNodeAddDialog_jButtonAdd_actionAdapter;
import topo.dialog.CommNodeAddDialog_jButtonClose_actionAdapter;
import topo.service.TopoDataManager;
import topo.utils.CheckIPUtil;
import topo.utils.DialogTools;

public class NodeAddDialog
extends JDialog {
    static ResourceBundle res = ResourceBundle.getBundle(String.valueOf(NodeAddDialog.class.getPackage().getName()) + ".Res");
    JPanel panel1 = new JPanel();
    JLabel jLabel1 = new JLabel();
    JTextField jTextFieldName = new JTextField();
    JLabel jLabel3 = new JLabel();
    JTextField jTextFieldIP = new JTextField();
    JLabel jLabel4 = new JLabel();
    JTextField jTextFieldRead = new JTextField();
    JLabel jLabel5 = new JLabel();
    JTextField jTextFieldWrite = new JTextField();
    JTextField jTextFieldproxyIp = new JTextField();
    JLabel jLabel7 = new JLabel();
    JLabel jLabel8 = new JLabel();
    JLabel jLabel9 = new JLabel();
    JLabel jLabel10 = new JLabel();
    JLabel portLabel = new JLabel();
    JLabel jLabelPort = new JLabel();
    JTextField jTextFieldPort = new JTextField();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JButton jButtonAdd = new JButton();
    JButton jButtonClose = new JButton();
    JLabel jLabel11 = new JLabel();
    private Border border3 = BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140));
    private Border border4 = new TitledBorder(this.border3, res.getString("String_132"));
    JLabel jLabel2 = new JLabel();
    JLabel jLabeSnmpProxy = new JLabel();
    JLabel jLabeProxyIp = new JLabel();
    JLabel jLabeSnmpV = new JLabel();
    JComboBox jComboBoxType = new JComboBox();
    JComboBox jComboBoxSnmpProxy = new JComboBox();
    JComboBox jComboBoxSnmpV = new JComboBox();

    public void myInit() {
        List<NodeType> list = NodeType.getNodeTypeList();
        int n = 0;
        while (n < list.size()) {
            NodeType nodeType = list.get(n);
            this.jComboBoxType.addItem(nodeType.getNodeType());
            ++n;
        }
        this.jComboBoxType.setEditable(false);
        this.jTextFieldproxyIp.setEnabled(false);
    }

    public NodeAddDialog(Frame frame) {
        super(frame, res.getString("String_133"), true);
        try {
            this.setSize(347, 430);
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setDefaultCloseOperation(2);
        this.setTitle(res.getString("String_150"));
        this.getContentPane().setLayout(this.borderLayout1);
        this.panel1.setLayout(null);
        this.jLabel1.setText(res.getString("String_138"));
        this.jLabel1.setBounds(new Rectangle(34, 21, 114, 20));
        this.jTextFieldName.setText(res.getString("String_140"));
        this.jTextFieldName.setBounds(new Rectangle(155, 21, 105, 25));
        this.jLabel3.setText(res.getString("String_141"));
        this.jLabel3.setBounds(new Rectangle(34, 66, 114, 20));
        this.jTextFieldIP.setText("192.1.1.1");
        this.jTextFieldIP.setBounds(new Rectangle(155, 66, 105, 25));
        this.jLabel11.setText("          ");
        this.jLabel2.setText(res.getString("String_166"));
        this.jLabel2.setBounds(new Rectangle(34, 111, 114, 16));
        this.jComboBoxType.setBounds(new Rectangle(156, 111, 105, 25));
        this.jLabel4.setText("SNMP\u8bfb\u5bc6\u7801\uff1a");
        this.jLabel4.setBounds(new Rectangle(34, 156, 114, 20));
        this.jTextFieldRead.setText("public");
        this.jTextFieldRead.setBounds(new Rectangle(155, 156, 105, 25));
        this.jLabel5.setRequestFocusEnabled(true);
        this.jLabel5.setText("SNMP\u5199\u5bc6\u7801\uff1a");
        this.jLabel5.setBounds(new Rectangle(34, 201, 114, 20));
        this.jTextFieldWrite.setText("public");
        this.jTextFieldWrite.setBounds(new Rectangle(155, 201, 105, 25));
        this.jLabelPort.setText("SNMP\u7aef\u53e3\uff1a");
        this.jLabelPort.setBounds(new Rectangle(34, 246, 105, 25));
        this.jTextFieldPort.setEnabled(true);
        this.jTextFieldPort.setText("161");
        this.jTextFieldPort.setBounds(new Rectangle(155, 246, 105, 25));
        this.portLabel.setForeground(Color.red);
        this.portLabel.setHorizontalAlignment(0);
        this.portLabel.setHorizontalTextPosition(0);
        this.portLabel.setText("*");
        this.portLabel.setBounds(new Rectangle(267, 246, 9, 19));
        this.jLabeSnmpV.setText("SNMP\u7248\u672c\uff1a");
        this.jLabeSnmpV.setBounds(new Rectangle(34, 291, 89, 16));
        this.jComboBoxSnmpV.setBounds(new Rectangle(156, 291, 105, 25));
        this.jComboBoxSnmpV.addItem("V2C");
        this.jComboBoxSnmpV.addItem("V1");
        this.jLabel7.setForeground(Color.red);
        this.jLabel7.setRequestFocusEnabled(true);
        this.jLabel7.setHorizontalAlignment(0);
        this.jLabel7.setHorizontalTextPosition(0);
        this.jLabel7.setText("*");
        this.jLabel7.setBounds(new Rectangle(267, 25, 9, 19));
        this.jLabel8.setForeground(Color.red);
        this.jLabel8.setText("*");
        this.jLabel8.setBounds(new Rectangle(267, 66, 9, 19));
        this.jLabel8.setHorizontalTextPosition(0);
        this.jLabel8.setHorizontalAlignment(0);
        this.jLabel9.setForeground(Color.red);
        this.jLabel9.setHorizontalAlignment(0);
        this.jLabel9.setHorizontalTextPosition(0);
        this.jLabel9.setText("*");
        this.jLabel9.setBounds(new Rectangle(267, 156, 9, 19));
        this.jLabel10.setForeground(Color.red);
        this.jLabel10.setHorizontalAlignment(0);
        this.jLabel10.setHorizontalTextPosition(0);
        this.jLabel10.setText("*");
        this.jLabel10.setBounds(new Rectangle(267, 201, 9, 19));
        this.panel1.setBorder(this.border4);
        this.jButtonAdd.setText(res.getString("String_163"));
        this.jButtonAdd.addActionListener(new CommNodeAddDialog_jButtonAdd_actionAdapter(this));
        this.jButtonClose.setText(res.getString("String_164"));
        this.jButtonClose.addActionListener(new CommNodeAddDialog_jButtonClose_actionAdapter(this));
        this.panel1.add((Component)this.jTextFieldWrite, null);
        this.panel1.add((Component)this.jLabel1, null);
        this.panel1.add((Component)this.jTextFieldName, null);
        this.panel1.add((Component)this.jTextFieldRead, null);
        this.panel1.add((Component)this.jTextFieldIP, null);
        this.panel1.add((Component)this.jLabel3, null);
        this.panel1.add((Component)this.jLabel4, null);
        this.panel1.add((Component)this.jLabel5, null);
        this.panel1.add((Component)this.jLabel7, null);
        this.panel1.add((Component)this.jLabel8, null);
        this.panel1.add((Component)this.jLabel9, null);
        this.panel1.add((Component)this.jLabel10, null);
        this.panel1.add((Component)this.portLabel, null);
        this.panel1.add((Component)this.jLabeSnmpV, null);
        this.panel1.add((Component)this.jLabeSnmpProxy, null);
        this.panel1.add((Component)this.jLabeProxyIp, null);
        this.panel1.add((Component)this.jComboBoxSnmpV, null);
        this.panel1.add((Component)this.jComboBoxSnmpProxy, null);
        this.panel1.add((Component)this.jTextFieldproxyIp, null);
        this.panel1.add(this.jComboBoxType);
        this.panel1.add((Component)this.jLabel2, null);
        this.panel1.add((Component)this.jLabelPort, null);
        this.panel1.add((Component)this.jTextFieldPort, null);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel1.add((Component)this.jButtonAdd, null);
        this.jPanel1.add((Component)this.jLabel11, null);
        this.jPanel1.add((Component)this.jButtonClose, null);
        this.getContentPane().add((Component)this.panel1, "Center");
    }

    void jButtonClose_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    public void jButtonAdd_actionPerformed(ActionEvent actionEvent) {
        try {
            NodeDevice nodeDevice = new NodeDevice();
            if ("".equals(this.jTextFieldName.getText().trim())) {
                DialogTools.showErroMsg(this, "\u8bf7\u8f93\u5165\u8bbe\u5907\u540d\u79f0!");
                return;
            }
            String string = this.jTextFieldIP.getText().trim();
            if (string == null || string.equals("")) {
                DialogTools.showErroMsg(this, "\u8bf7\u8f93\u5165\u8bbe\u5907IP\u5730\u5740!");
                return;
            }
            if (!CheckIPUtil.checkIP(string)) {
                DialogTools.showErroMsg(this, "\u8bbe\u5907IP\u5730\u5740\u8f93\u5165\u9519\u8bef,\u8bf7\u91cd\u65b0\u8f93\u5165!");
                this.jTextFieldIP.grabFocus();
                return;
            }
            if (this.jComboBoxType.getSelectedItem() == null) {
                DialogTools.showErroMsg(this, "\u8bf7\u9009\u62e9\u8bbe\u5907\u7c7b\u578b!");
                return;
            }
            if ("".equals(this.jTextFieldRead.getText().trim())) {
                DialogTools.showErroMsg(this, "\u8bf7\u8f93\u5165SNMP\u8bfb\u5171\u540c\u4f53!");
                return;
            }
            if ("".equals(this.jTextFieldWrite.getText().trim())) {
                DialogTools.showErroMsg(this, "\u8bf7\u8f93\u5165SNMP\u5199\u5171\u540c\u4f53!");
                return;
            }
            if ("".equals(this.jTextFieldPort.getText().trim())) {
                DialogTools.showErroMsg(this, "\u8bf7\u8f93\u5165SNMP\u7aef\u53e3\u53f7!");
                return;
            }
            if (TopoDataManager.getInstance().checkExistDeviceByIP(string)) {
                DialogTools.showErroMsg(this, "\u5f53\u524d\u62d3\u6251\u5df2\u5b58\u5728\u8be5IP\u7684\u8bbe\u5907,\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0!");
                return;
            }
            nodeDevice.setIpAddress(string);
            nodeDevice.setReadCommit(this.jTextFieldRead.getText());
            nodeDevice.setWriteCommit(this.jTextFieldWrite.getText());
            nodeDevice.setNodeType(this.jComboBoxType.getSelectedItem().toString());
            nodeDevice.setDisplayName(this.jTextFieldName.getText());
            nodeDevice.setSnmpPort(new Integer(this.jTextFieldPort.getText()));
            nodeDevice.setNodeName(nodeDevice.genKey());
            if (this.jComboBoxSnmpV.getSelectedIndex() == 0) {
                nodeDevice.setSnmpVersion(1);
            } else if (this.jComboBoxSnmpV.getSelectedIndex() == 1) {
                nodeDevice.setSnmpVersion(0);
            }
            int n = this.jComboBoxSnmpProxy.getSelectedIndex();
            if (n == 0) {
                String string2 = this.jTextFieldIP.getText().trim();
                if (string2 == null || string2.equals("")) {
                    DialogTools.showErroMsg(this, "\u8bf7\u8f93\u5165\u4ee3\u7406\u670d\u52a1\u5668IP\u5730\u5740!");
                    return;
                }
                if (!CheckIPUtil.checkIP(string2)) {
                    DialogTools.showErroMsg(this, "\u4ee3\u7406\u670d\u52a1\u5668IP\u5730\u5740\u8f93\u5165\u9519\u8bef,\u8bf7\u91cd\u65b0\u8f93\u5165!");
                    this.jTextFieldIP.grabFocus();
                    return;
                }
                nodeDevice.setIsEnableSNMPProxy(1);
            } else if (this.jComboBoxSnmpProxy.getSelectedIndex() == 1) {
                nodeDevice.setIsEnableSNMPProxy(0);
            }
            nodeDevice.setSnmpProxyIP(this.jTextFieldproxyIp.getText().trim());
            TopoDataManager.getInstance().addNode(nodeDevice);
            this.dispose();
        }
        catch (Exception exception) {
            DialogTools.showErroMsg(this, res.getString("String_167"));
            exception.printStackTrace();
        }
    }

    void jComboBoxSnmpProxy_itemStateChanged(ItemEvent itemEvent) {
        if (this.jComboBoxSnmpProxy.getSelectedIndex() == 0) {
            this.jTextFieldproxyIp.setEnabled(true);
        } else {
            this.jTextFieldproxyIp.setEnabled(false);
        }
    }

    class CommNodeAddDialog_jComboBoxSnmpProxy_itemAdapter
    implements ItemListener {
        NodeAddDialog adaptee;

        CommNodeAddDialog_jComboBoxSnmpProxy_itemAdapter(NodeAddDialog nodeAddDialog2) {
            this.adaptee = nodeAddDialog2;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            this.adaptee.jComboBoxSnmpProxy_itemStateChanged(itemEvent);
        }
    }
}

