/*
 * Decompiled with CFR 0.152.
 */
package topo.menu;

import com.zhtelecom.common.topograph.TopoGraphView;
import com.zhtelecom.common.topograph.TopoLayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import topo.action.AutoDiscoverByIPRoamingAction;
import topo.action.AutoDiscoverByIpAction;
import topo.action.AutoDiscoverByNetAction;
import topo.action.AutoDiscoverByRouterAction;
import topo.action.BackupTopoDataAction;
import topo.action.CompanyDescAction;
import topo.action.NodeAddAction;
import topo.action.SystemExitAction;

public class MenuBarManager {
    private static JMenu fileMenu = new JMenu("\u6587\u4ef6(F)");
    private static JMenu addDevice = new JMenu("\u8bbe\u5907\u7ba1\u7406(A)");
    private static JMenu autoDevice = new JMenu("\u81ea\u52a8\u641c\u7d22\u8bbe\u5907(S)");
    private static JMenu netLayout = new JMenu("\u7f51\u7edc\u91cd\u65b0\u5e03\u5c40(V)");
    private static JMenu helpMe = new JMenu("\u5e2e\u52a9(H)");
    private static JMenuBar menubar;

    public static void initMenu(JMenuBar jMenuBar, TopoGraphView topoGraphView) {
        menubar = jMenuBar;
        MenuBarManager.initFileMenu();
        MenuBarManager.addDevice(topoGraphView);
        MenuBarManager.autoDevice(topoGraphView);
        MenuBarManager.netLayout(topoGraphView);
        MenuBarManager.addHelpMe();
    }

    private static void initFileMenu() {
        fileMenu.setMnemonic('f');
        menubar.add(fileMenu);
        BackupTopoDataAction backupTopoDataAction = new BackupTopoDataAction();
        fileMenu.add(backupTopoDataAction);
        fileMenu.addSeparator();
        SystemExitAction systemExitAction = new SystemExitAction();
        fileMenu.add(systemExitAction);
    }

    private static void addDevice(TopoGraphView topoGraphView) {
        addDevice.setMnemonic('a');
        menubar.add(addDevice);
        NodeAddAction nodeAddAction = new NodeAddAction();
        nodeAddAction.putValue("ActionDataTopoview", topoGraphView);
        addDevice.add(nodeAddAction);
    }

    private static void autoDevice(TopoGraphView topoGraphView) {
        autoDevice.setMnemonic('s');
        menubar.add(autoDevice);
        AutoDiscoverByIpAction autoDiscoverByIpAction = new AutoDiscoverByIpAction();
        autoDiscoverByIpAction.putValue("ActionDataTopoview", topoGraphView);
        autoDevice.add(autoDiscoverByIpAction);
        AutoDiscoverByNetAction autoDiscoverByNetAction = new AutoDiscoverByNetAction();
        autoDiscoverByNetAction.putValue("ActionDataKeyName", topoGraphView);
        autoDevice.add(autoDiscoverByNetAction);
        AutoDiscoverByRouterAction autoDiscoverByRouterAction = new AutoDiscoverByRouterAction();
        autoDiscoverByRouterAction.putValue("ActionDataKeyName", topoGraphView);
        autoDevice.add(autoDiscoverByRouterAction);
        AutoDiscoverByIPRoamingAction autoDiscoverByIPRoamingAction = new AutoDiscoverByIPRoamingAction();
        autoDiscoverByIPRoamingAction.putValue("ActionDataKeyName", topoGraphView);
        autoDevice.add(autoDiscoverByIPRoamingAction);
    }

    private static void netLayout(final TopoGraphView topoGraphView) {
        netLayout.setMnemonic('v');
        menubar.add(netLayout);
        netLayout.add(new AbstractAction("Hierarchical\u5e03\u5c40"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TopoLayoutManager.hierarchicalLayout(topoGraphView);
            }
        });
        netLayout.add(new AbstractAction("\u5feb\u901fOrganic\u5e03\u5c40"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TopoLayoutManager.fastOrganicLayout(topoGraphView);
            }
        });
        netLayout.add(new AbstractAction("Organic\u5e03\u5c40"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TopoLayoutManager.organicLayout(topoGraphView);
            }
        });
        netLayout.add(new AbstractAction("Self-Organizing\u5e03\u5c40"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TopoLayoutManager.selfOrganicLayout(topoGraphView);
            }
        });
        netLayout.add(new AbstractAction("\u7d27\u51d1\u6811\u578b\u5e03\u5c40"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TopoLayoutManager.compactTreeLayout(topoGraphView);
            }
        });
        netLayout.add(new AbstractAction("\u653e\u5c04\u6811\u5f62\u5e03\u5c40"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TopoLayoutManager.radialTreeLayout(topoGraphView);
            }
        });
        netLayout.add(new AbstractAction("\u57fa\u672c\u6811\u5f62\u5e03\u5c40"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TopoLayoutManager.treeLayout(topoGraphView);
            }
        });
        netLayout.add(new AbstractAction("Organizational\u5e03\u5c40"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TopoLayoutManager.organizationalLayout(topoGraphView);
            }
        });
        netLayout.add(new AbstractAction("Spring\u5e03\u5c40"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TopoLayoutManager.springLayout(topoGraphView);
            }
        });
        netLayout.add(new AbstractAction("\u7b80\u5355\u968f\u673a\u5e03\u5c40"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TopoLayoutManager.simpleRandomLayout(topoGraphView);
            }
        });
        netLayout.add(new AbstractAction("\u7b80\u5355\u6807\u9898\u5e03\u5c40"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TopoLayoutManager.simpleTiltLayout(topoGraphView);
            }
        });
        netLayout.add(new AbstractAction("\u5706\u5f62\u5e03\u5c40"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TopoLayoutManager.simpleCircleLayout(topoGraphView);
            }
        });
    }

    private static void addHelpMe() {
        helpMe.setMnemonic('h');
        menubar.add(helpMe);
        CompanyDescAction companyDescAction = new CompanyDescAction();
        helpMe.add(companyDescAction);
    }
}

