/*
 * Decompiled with CFR 0.152.
 */
package topo.service;

import com.zhtelecom.common.base.MyException;
import com.zhtelecom.common.base.MyLog;
import com.zhtelecom.common.snmp.OMMappingInfo;
import com.zhtelecom.common.snmp.SNMPAPI;
import com.zhtelecom.common.snmp.SNMPFactory;
import com.zhtelecom.common.snmp.SNMPTarget;
import java.util.List;
import topo.data.NodeDevice;
import topo.utils.SNMPTargetTool;

public class SNMPBaseObjectService {
    private static SNMPBaseObjectService snmpService = new SNMPBaseObjectService();
    private SNMPAPI snmpAPI = null;

    private SNMPBaseObjectService() {
        try {
            this.snmpAPI = SNMPFactory.getSNMPAPI();
        }
        catch (Exception exception) {
            MyLog.err("Init SNMP Moudle Erro\uff1a" + exception.getMessage());
            MyLog.debug(exception);
        }
    }

    public static SNMPBaseObjectService getInstance() {
        if (snmpService == null) {
            snmpService = new SNMPBaseObjectService();
        }
        return snmpService;
    }

    public void add(OMMappingInfo oMMappingInfo) throws MyException {
    }

    public List getTableAll(Class clazz, NodeDevice nodeDevice) throws MyException {
        try {
            SNMPTarget sNMPTarget = SNMPTargetTool.nodeToSNMPConnInfo(nodeDevice);
            List list = this.snmpAPI.getAllTableData(clazz, sNMPTarget);
            int n = 0;
            while (n < list.size()) {
                OMMappingInfo oMMappingInfo = (OMMappingInfo)list.get(n);
                oMMappingInfo.setNodeName(nodeDevice.getNodeName());
                oMMappingInfo.setDbKey(oMMappingInfo.genKey());
                ++n;
            }
            return list;
        }
        catch (Exception exception) {
            throw new MyException(exception);
        }
    }

    public String getSNMPOIDValue(NodeDevice nodeDevice, String string) throws MyException {
        return SNMPTargetTool.getSNMPOIDValue(nodeDevice, string);
    }

    public String getSNMPNextOIDValue(NodeDevice nodeDevice, String string) throws MyException {
        return SNMPTargetTool.getSNMPNextOIDValue(nodeDevice, string);
    }

    public OMMappingInfo refresh(OMMappingInfo oMMappingInfo) throws MyException {
        return null;
    }

    public void update(OMMappingInfo oMMappingInfo) throws MyException {
    }

    public void delete(OMMappingInfo oMMappingInfo) throws MyException {
    }

    public String checkAgentErroMsg(NodeDevice nodeDevice) {
        return SNMPTargetTool.checkAgentErroMsg(nodeDevice);
    }

    public static SNMPTarget nodeToSNMPConnInfo(NodeDevice nodeDevice) {
        return SNMPTargetTool.nodeToSNMPConnInfo(nodeDevice);
    }

    public static void main(String[] stringArray) {
        try {
            SNMPTarget sNMPTarget = new SNMPTarget();
            sNMPTarget.nodeIP = "192.168.0.120";
            sNMPTarget.readCommunity = "bjjh";
            sNMPTarget.port = 11210;
            sNMPTarget.proxySNMPGateIP = "192.168.6.1:11210";
            SNMPFactory.init(1, "", 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

