/*
 * Decompiled with CFR 0.152.
 */
package topo.service;

import com.zhtelecom.common.base.MyException;
import com.zhtelecom.common.topograph.TopoDataSource;
import com.zhtelecom.common.topograph.TopoLink;
import com.zhtelecom.common.topograph.TopoNode;
import com.zhtelecom.common.topograph.TopoObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import topo.MainFrame;
import topo.data.NodeDevice;
import topo.data.NodeLink;
import topo.data.NodeType;

public class TopoDataManager {
    private static TopoDataManager topoDataManager;
    private TopoDataSource topoDataSource;

    private TopoDataManager(TopoDataSource topoDataSource) {
        this.topoDataSource = topoDataSource;
    }

    public static TopoDataManager getInstance() {
        if (topoDataManager == null) {
            topoDataManager = new TopoDataManager(MainFrame.source);
        }
        return topoDataManager;
    }

    public void clearTopoSource() {
        this.topoDataSource.clearAllData();
    }

    public void delNode(NodeDevice nodeDevice) {
        this.topoDataSource.removeTopoDataByUserID(nodeDevice);
    }

    public void updateNode(NodeDevice nodeDevice) {
        TopoNode topoNode = (TopoNode)this.topoDataSource.getTopoObject(nodeDevice);
        NodeType nodeType = NodeType.getNodeTypeByKey(nodeDevice.getNodeType());
        topoNode.setDisplayName(nodeDevice.getIpAddress());
        if (nodeType != null) {
            topoNode.setImageIcon(nodeType.getTypeImage());
        } else {
            topoNode.setImageIcon(TopoNode.defaultIcon);
        }
        topoNode.fireChanged();
    }

    public void addLink(NodeLink nodeLink) {
        NodeDevice nodeDevice = this.getNodeByNodeName(nodeLink.getFromNode());
        NodeDevice nodeDevice2 = this.getNodeByNodeName(nodeLink.getToNode());
        TopoNode topoNode = (TopoNode)this.topoDataSource.getTopoObject(nodeDevice);
        TopoNode topoNode2 = (TopoNode)this.topoDataSource.getTopoObject(nodeDevice2);
        if (nodeDevice != null && nodeDevice2 != null) {
            TopoLink topoLink = new TopoLink(nodeLink, topoNode, topoNode2);
            topoLink.setShowArrow(false);
            this.topoDataSource.addTopoData(topoLink);
        }
    }

    public void delLink(NodeLink nodeLink) {
        this.topoDataSource.removeTopoDataByUserID(nodeLink);
    }

    public void updateLink(NodeLink nodeLink) {
        TopoLink topoLink = (TopoLink)this.topoDataSource.getTopoObject(nodeLink);
        topoLink.fireChanged();
    }

    public void addNode(NodeDevice nodeDevice) {
        try {
            TopoNode topoNode = new TopoNode(nodeDevice);
            topoNode.setDisplayName(nodeDevice.getIpAddress());
            topoNode.setXY(nodeDevice.getPoseX(), nodeDevice.getPoseY());
            NodeType nodeType = NodeType.getNodeTypeByKey(nodeDevice.getNodeType());
            if (nodeType != null) {
                topoNode.setImageIcon(nodeType.getTypeImage());
            } else {
                topoNode.setImageIcon(TopoNode.defaultIcon);
            }
            this.topoDataSource.addTopoData(topoNode);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addNodeList(List<NodeDevice> list) {
        this.topoDataSource.beginChange();
        for (NodeDevice nodeDevice : list) {
            this.addNode(nodeDevice);
        }
        this.topoDataSource.commitChange();
    }

    public void addLinkList(List<NodeLink> list) {
        this.topoDataSource.beginChange();
        for (NodeLink nodeLink : list) {
            this.addLink(nodeLink);
        }
        this.topoDataSource.commitChange();
    }

    public TopoNode getTopoNodeByName(String string) {
        NodeDevice nodeDevice = new NodeDevice();
        nodeDevice.setNodeName(string);
        return (TopoNode)this.topoDataSource.getTopoObject(nodeDevice);
    }

    public NodeDevice getNodeByNodeName(String string) {
        TopoNode topoNode = this.getTopoNodeByName(string);
        if (topoNode != null) {
            return (NodeDevice)topoNode.getUserID();
        }
        return null;
    }

    public boolean checkExistDeviceByIP(String string) {
        Vector<TopoNode> vector = this.topoDataSource.getAllTopoNode();
        NodeDevice nodeDevice = new NodeDevice();
        int n = 0;
        while (n < vector.size()) {
            nodeDevice = (NodeDevice)vector.get(n).getUserID();
            if (nodeDevice.getIpAddress().equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public List<Object> getTopoData() throws MyException {
        try {
            Vector<TopoObject> vector = this.topoDataSource.getAllTopoObject();
            Iterator iterator = vector.iterator();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<NodeDevice> arrayList2 = new ArrayList<NodeDevice>();
            ArrayList<NodeLink> arrayList3 = new ArrayList<NodeLink>();
            while (iterator.hasNext()) {
                TopoObject topoObject = (TopoObject)iterator.next();
                if (topoObject.getUserID() instanceof NodeDevice) {
                    TopoNode topoNode = (TopoNode)topoObject;
                    int n = topoNode.getX();
                    int n2 = topoNode.getY();
                    NodeDevice nodeDevice = (NodeDevice)topoNode.getUserID();
                    nodeDevice.setPoseX(n);
                    nodeDevice.setPoseY(n2);
                    arrayList2.add(nodeDevice);
                    continue;
                }
                if (!(topoObject.getUserID() instanceof NodeLink)) continue;
                arrayList3.add((NodeLink)topoObject.getUserID());
            }
            if (arrayList2.size() > 0) {
                arrayList.add(arrayList2);
                arrayList.add(arrayList3);
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw new MyException(exception.getMessage());
        }
    }
}

