/*
 * Decompiled with CFR 0.152.
 */
package topo.sourcecode;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class LineNumber
extends JComponent {
    static final long serialVersionUID = 3679449495322768618L;
    private static final Color DEFAULT_BACKGROUND = new Color(238, 238, 238);
    private static final Color DEFAULT_FOREGROUND = Color.GRAY;
    private static final Font DEFAULT_FONT = new Font("monospaced", 0, 12);
    private static final int HEIGHT = 2146483647;
    private static final int MARGIN = 5;
    private int lineHeight;
    private int fontLineHeight;
    private int currentRowWidth;
    private FontMetrics fontMetrics;

    public LineNumber(JComponent jComponent) {
        if (jComponent == null) {
            this.setBackground(DEFAULT_BACKGROUND);
            this.setForeground(DEFAULT_FOREGROUND);
            this.setFont(DEFAULT_FONT);
        } else {
            this.setBackground(DEFAULT_BACKGROUND);
            this.setForeground(DEFAULT_FOREGROUND);
            this.setFont(jComponent.getFont());
        }
        this.setPreferredSize(9999);
    }

    public void setPreferredSize(int n) {
        int n2 = this.fontMetrics.stringWidth(String.valueOf(n));
        if (this.currentRowWidth < n2) {
            this.currentRowWidth = n2;
            this.setPreferredSize(new Dimension(10 + n2, 2146483647));
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.fontMetrics = this.getFontMetrics(this.getFont());
        this.fontLineHeight = this.fontMetrics.getHeight();
    }

    public int getLineHeight() {
        if (this.lineHeight == 0) {
            return this.fontLineHeight;
        }
        return this.lineHeight;
    }

    public void setLineHeight(int n) {
        if (n > 0) {
            this.lineHeight = n;
        }
    }

    public int getStartOffset() {
        return 4;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int n = this.getLineHeight();
        int n2 = this.getStartOffset();
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(this.getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(this.getForeground());
        int n3 = rectangle.y / n + 1;
        int n4 = n3 + rectangle.height / n;
        int n5 = rectangle.y / n * n + n - n2;
        int n6 = n3;
        while (n6 <= n4) {
            String string = String.valueOf(n6);
            int n7 = this.fontMetrics.stringWidth(string);
            graphics.drawString(string, 5 + this.currentRowWidth - n7, n5);
            n5 += n;
            ++n6;
        }
        this.setPreferredSize(n4);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("LineNumberDemo");
        jFrame.setDefaultCloseOperation(3);
        JPanel jPanel = new JPanel();
        jFrame.setContentPane(jPanel);
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        jPanel.setLayout(new BorderLayout());
        JTextArea jTextArea = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jPanel.add(jScrollPane);
        jScrollPane.setPreferredSize(new Dimension(300, 250));
        LineNumber lineNumber = new LineNumber(jTextArea);
        lineNumber.setPreferredSize(99999);
        jScrollPane.setRowHeaderView(lineNumber);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

