/*
 * Decompiled with CFR 0.152.
 */
package topo.sourcecode;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SourceCodeTextArea
extends JTextArea
implements ActionListener {
    private JPopupMenu consoleMenu;
    private JMenuItem copyItem;
    private JMenuItem selectAllItem;
    Font font = new Font("Courier", 0, 14);

    public SourceCodeTextArea() throws IOException {
        this.initCoreCodeArea();
    }

    private void initCoreCodeArea() {
        this.consoleMenu = new JPopupMenu();
        this.copyItem = new JMenuItem("\u590d\u5236");
        this.selectAllItem = new JMenuItem("\u5168\u90e8\u9009\u4e2d");
        this.consoleMenu.add(this.copyItem);
        this.consoleMenu.addSeparator();
        this.consoleMenu.add(this.selectAllItem);
        this.copyItem.addActionListener(this);
        this.selectAllItem.addActionListener(this);
        this.add(this.consoleMenu);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 3) {
                    SourceCodeTextArea.this.copyItem.setEnabled(SourceCodeTextArea.this.isCanCopy());
                    SourceCodeTextArea.this.consoleMenu.show(SourceCodeTextArea.this, mouseEvent.getX(), mouseEvent.getY());
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                SourceCodeTextArea.this.setCursor(new Cursor(2));
            }
        });
        this.getCaret().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SourceCodeTextArea.this.getCaret().setVisible(true);
            }
        });
        this.setEditable(false);
        this.setFont(this.font);
        this.setCaretColor(Color.RED);
        this.setTabSize(4);
    }

    public boolean isCanCopy() {
        int n;
        boolean bl = false;
        int n2 = this.getSelectionStart();
        if (n2 != (n = this.getSelectionEnd())) {
            bl = true;
        }
        return bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(this.copyItem.getText())) {
            this.copy();
        } else if (string.equals(this.selectAllItem.getText())) {
            this.selectAll();
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("CoreCodeArea\u6d4b\u8bd5");
        SourceCodeTextArea sourceCodeTextArea = null;
        try {
            sourceCodeTextArea = new SourceCodeTextArea();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        jFrame.getContentPane().add((Component)new JScrollPane(sourceCodeTextArea), "Center");
        jFrame.setBounds(50, 50, 300, 300);
        jFrame.setVisible(true);
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
    }
}

