/*
 * Decompiled with CFR 0.152.
 */
package topo.table;

import com.l2fprod.common.beans.editor.ComboBoxPropertyEditor;
import com.l2fprod.common.demo.KVTableCellRenderer;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import topo.table.ObjectTableModel;
import topo.table.TableMouseHandle;

public class ObjectTable
extends JTable {
    TableMouseHandle handle;
    private ObjectTableModel mod;
    TableRowSorter sorter;

    public ObjectTable(ObjectTableModel objectTableModel) {
        super(objectTableModel);
        this.mod = objectTableModel;
        this.setAutoscrolls(true);
        this.addMouseListener(new Table_mouseAdapter());
        this.setSelectionMode(0);
        TableColumn tableColumn = this.getColumn(".ObjectIDName.");
        tableColumn.setMaxWidth(0);
        tableColumn.setMinWidth(0);
        tableColumn.setPreferredWidth(0);
        tableColumn.setResizable(false);
        tableColumn.setWidth(0);
        this.setRowHeight(20);
        this.getTableHeader().setFont(new Font("Dialog", 0, 12));
        this.sorter = new TableRowSorter<ObjectTableModel>(objectTableModel);
        this.setRowSorter(this.sorter);
    }

    public ObjectTableModel getObjectTableModel() {
        return this.mod;
    }

    public void setRendererKVType(int n, ComboBoxPropertyEditor.Value[] valueArray) {
        String string = this.getColumnName(n);
        this.getColumn(string).setCellRenderer(new KVTableCellRenderer(valueArray));
    }

    public void setRenderer(int n, TableCellRenderer tableCellRenderer) {
        String string = this.getColumnName(n);
        this.getColumn(string).setCellRenderer(tableCellRenderer);
    }

    public void setRendererIntAsBoolean(int n) {
        String string = this.getColumnName(n);
        ComboBoxPropertyEditor.Value[] valueArray = new ComboBoxPropertyEditor.Value[]{new ComboBoxPropertyEditor.Value(new Integer(1), "\u662f"), new ComboBoxPropertyEditor.Value(new Integer(0), "\u5426")};
        this.getColumn(string).setCellRenderer(new KVTableCellRenderer(valueArray));
    }

    public Object getSelectRowObject() {
        int n = this.getSelectedRow();
        if (n >= 0) {
            n = this.sorter.convertRowIndexToModel(n);
            return this.mod.getRowObject(n);
        }
        return null;
    }

    public List getSelectRowObjects() {
        Vector<Object> vector = new Vector<Object>();
        int[] nArray = this.getSelectedRows();
        int n = 0;
        while (n < nArray.length) {
            int n2 = this.sorter.convertRowIndexToModel(nArray[n]);
            Object object = this.mod.getRowObject(n2);
            if (object != null) {
                vector.add(object);
            }
            ++n;
        }
        return vector;
    }

    void myMouseReleased(MouseEvent mouseEvent) {
        if (this.handle == null) {
            return;
        }
        if (mouseEvent.getClickCount() == 2) {
            this.handle.doubleClickAction(mouseEvent);
        }
        if (mouseEvent.getButton() == 3) {
            int n;
            int n2 = this.rowAtPoint(mouseEvent.getPoint());
            if (n2 >= 0) {
                this.addRowSelectionInterval(n2, n2);
            }
            if ((n = this.getSelectedRow()) >= 0) {
                JPopupMenu jPopupMenu = this.handle.createObjectMenu(mouseEvent);
                jPopupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    void setMouseHandle(TableMouseHandle tableMouseHandle) {
        this.handle = tableMouseHandle;
    }

    class Table_mouseAdapter
    extends MouseAdapter {
        Table_mouseAdapter() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            ObjectTable.this.myMouseReleased(mouseEvent);
        }
    }
}

